/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.core.NAnyBootAwareExceptionBase;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NSessionAwareExceptionBase;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NExceptionWorkspaceHandler;

public class NException
extends RuntimeException
implements NSessionAwareExceptionBase,
NAnyBootAwareExceptionBase {
    private final NSession session = NSession.get().orNull();
    private final NMsg formattedMessage;

    public NException(NMsg message) {
        super(NException.messageToString(message));
        this.formattedMessage = NException.validateFormattedMessage(message);
    }

    public NException(NMsg message, Throwable cause) {
        super(message == null ? "error occurred" : message.toString(), cause);
        this.formattedMessage = NException.validateFormattedMessage(message);
    }

    public NException(NMsg message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(NException.messageToString(message), cause, enableSuppression, writableStackTrace);
        this.formattedMessage = NException.validateFormattedMessage(message);
    }

    public static NMsg validateFormattedMessage(NMsg message) {
        if (message == null) {
            message = NMsg.ofPlain("error occurred");
        }
        return message;
    }

    public static NText messageToFormattedString(NMsg message) {
        if (NWorkspace.get().isNotPresent()) {
            throw new IllegalArgumentException(message == null ? "missing workspace" : message.toString());
        }
        return NText.of(NException.validateFormattedMessage(message));
    }

    public static String messageToString(NMsg message) {
        return NException.messageToFormattedString(message).filteredText();
    }

    @Override
    public NMsg getFormattedMessage() {
        return this.formattedMessage;
    }

    @Override
    public NWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    @Override
    public NSession getSession() {
        return this.session;
    }

    @Override
    public int processThrowable(NBootOptionsInfo options) {
        if (this.session != null) {
            return this.session.callWith(() -> NExceptionWorkspaceHandler.of().processThrowable(options.getApplicationArguments().toArray(new String[0]), this));
        }
        return NBootUtils.processThrowable(this, true, NBootUtils.resolveShowStackTrace(options), NBootUtils.resolveGui(options));
    }
}

