/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Arrays;

public class NEvictingIntQueue {
    private int from = 0;
    private int len;
    private int[] values;

    public NEvictingIntQueue(int max) {
        this.values = new int[max];
    }

    public void clear() {
        this.from = 0;
        this.len = 0;
    }

    public int size() {
        return this.len;
    }

    public int get(int pos) {
        if (pos >= 0 && pos < this.len) {
            int i = (this.from + pos) % this.values.length;
            return this.values[i];
        }
        throw new IllegalArgumentException("invalid index " + pos);
    }

    public void add(int t) {
        int pos = (this.from + this.len) % this.values.length;
        this.values[pos] = t;
        if (this.len < this.values.length) {
            ++this.len;
        } else {
            this.from = (this.from + 1) % this.values.length;
        }
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            sb.append(this.get(i));
        }
        return "EvictingIntQueue{from=" + this.from + ", len=" + this.len + ", raw=" + Arrays.toString(this.values) + ", values='" + sb + "'" + '}';
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.get(i));
        }
        sb.append("}");
        return sb.toString();
    }
}

