/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.function.Function;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public class NEnumUtils {
    private NEnumUtils() {
    }

    public static <T extends Enum> NOptional<T> parseEnum(String value, Class<T> type) {
        if (NBlankable.isBlank(value)) {
            return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", type.getSimpleName()));
        }
        String normalizedValue = NNameFormat.CONST_NAME.format(value);
        try {
            return NOptional.of(Enum.valueOf(type, normalizedValue));
        }
        catch (Exception notFound) {
            return NOptional.ofError(() -> NMsg.ofC(type.getSimpleName() + " invalid value : %s", value));
        }
    }

    public static <T extends Enum> NOptional<T> parseEnum(String value, Class<T> type, Function<EnumValue, NOptional<T>> mapper) {
        if (NBlankable.isBlank(value)) {
            return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", type.getSimpleName()));
        }
        String[] parsedValue = NNameFormat.parse(value);
        String normalizedValue = NNameFormat.CONST_NAME.format(parsedValue);
        if (mapper != null) {
            try {
                NOptional<T> o = mapper.apply(new EnumValue(value, normalizedValue, parsedValue));
                if (o != null) {
                    return o;
                }
            }
            catch (Exception o) {
                // empty catch block
            }
        }
        try {
            return NOptional.of(Enum.valueOf(type, normalizedValue));
        }
        catch (Exception notFound) {
            return NOptional.ofError(() -> NMsg.ofC("%s invalid value : %s", type.getSimpleName(), value), (Throwable)notFound);
        }
    }

    public static class EnumValue {
        private String value;
        private String normalizedValue;
        private String[] parsedValue;

        public EnumValue(String value, String normalizedValue, String[] parsedValue) {
            this.value = value;
            this.normalizedValue = normalizedValue;
            this.parsedValue = parsedValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getNormalizedValue() {
            return this.normalizedValue;
        }

        public String[] getParsedValue() {
            return this.parsedValue;
        }
    }
}

