/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NFunction2;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class NEnumSet<T extends Enum<T>>
implements Iterable<T> {
    private EnumSet<T> values;
    private Class<T> type;
    private int maxSize;
    private NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr;

    public static <T extends Enum<T>> NOptional<NEnumSet<T>> parse(String value, Class<T> type) {
        return NEnumSet.parseType(NEnumSet.DEFAULT_CTR(), value, type);
    }

    public static <T extends Enum<T>> NEnumSet<T> noneOf(Class<T> type) {
        return NEnumSet.noneOfType(NEnumSet.DEFAULT_CTR(), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(Collection<T> value, Class<T> tt) {
        return NEnumSet.ofType(NEnumSet.DEFAULT_CTR(), value, tt);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(T[] value, Class<T> tt) {
        return NEnumSet.ofType(NEnumSet.DEFAULT_CTR(), value, tt);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofBitSet(long bits, Class<T> type) {
        return NEnumSet.ofTypeBitSet(NEnumSet.DEFAULT_CTR(), bits, type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofBitSet(BitSet bits, Class<T> type) {
        return NEnumSet.ofTypeBitSet(NEnumSet.DEFAULT_CTR(), bits, type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofBitSet(BigInteger bits, Class<T> type) {
        return NEnumSet.ofTypeBitSet(NEnumSet.DEFAULT_CTR(), bits, type);
    }

    public static <T extends Enum<T>> NEnumSet<T> allOf(Class<T> type) {
        return NEnumSet.allOfType(NEnumSet.DEFAULT_CTR(), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(T value) {
        return NEnumSet.ofType(NEnumSet.DEFAULT_CTR(), value);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(T ... value) {
        return NEnumSet.ofType(NEnumSet.DEFAULT_CTR(), value);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(Collection<T> value) {
        return NEnumSet.ofType(NEnumSet.DEFAULT_CTR(), value);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> NOptional<V> parseType(Class<V> setType, String value, Class<T> type) {
        return NEnumSet.parseType(NEnumSet.TYPED_CTR(setType), value, type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V noneOfType(Class<V> setType, Class<T> type) {
        return (V)NEnumSet.noneOfType(NEnumSet.TYPED_CTR(setType), type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofType(Class<V> setType, Collection<T> value, Class<T> tt) {
        return (V)NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), value, tt);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofType(Class<V> setType, T[] value, Class<T> tt) {
        return (V)NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), value, tt);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofTypeBitSet(Class<V> setType, long bits, Class<T> type) {
        return (V)NEnumSet.ofTypeBitSet(NEnumSet.TYPED_CTR(setType), bits, type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofTypeBitSet(Class<V> setType, BitSet bits, Class<T> type) {
        return (V)NEnumSet.ofTypeBitSet(NEnumSet.TYPED_CTR(setType), bits, type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofTypeBitSet(Class<V> setType, BigInteger bits, Class<T> type) {
        return (V)NEnumSet.ofTypeBitSet(NEnumSet.TYPED_CTR(setType), bits, type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V allOfType(Class<V> setType, Class<T> type) {
        return (V)NEnumSet.allOfType(NEnumSet.TYPED_CTR(setType), type);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofType(Class<V> setType, T value) {
        return (V)NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), value);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofType(Class<V> setType, T ... value) {
        return (V)NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), value);
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> V ofType(Class<V> setType, Collection<T> value) {
        return (V)NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), value);
    }

    public static <T extends Enum<T>> NOptional<NEnumSet<T>> parseType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> setType, String value, Class<T> type) {
        NOptional<BigInteger> lng;
        if (value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("null enum set"));
        }
        List<String> z = NStringUtils.split(value, ",;|+", true, true);
        if (z.size() == 1 && (lng = NLiteral.of(z.get(0)).asBigInt()).isPresent()) {
            return NOptional.of(NEnumSet.ofTypeBitSet(setType, lng.get(), type));
        }
        LinkedHashSet<Enum> set = new LinkedHashSet<Enum>();
        if (NEnum.class.isAssignableFrom(type)) {
            for (String s : z) {
                NOptional<T> y = NEnum.parse(type, s);
                if (y.isPresent()) {
                    set.add((Enum)y.get());
                    continue;
                }
                return NOptional.ofError(y.getMessage());
            }
        } else {
            for (String s : z) {
                try {
                    T t = Enum.valueOf(type, s);
                    set.add((Enum)t);
                }
                catch (Exception e) {
                    return NOptional.ofError(() -> NMsg.ofPlain(e.getMessage()));
                }
            }
        }
        return NOptional.of(NEnumSet.ofType(setType, set, type));
    }

    public static <T extends Enum<T>, V extends NEnumSet<T>> NEnumSet<T> ofType(Class<V> setType, Class<T> valueType) {
        return NEnumSet.ofType(NEnumSet.TYPED_CTR(setType), valueType);
    }

    public static <T extends Enum<T>> NEnumSet<T> allOfType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, Class<T> type) {
        return NEnumSet.newInstance(ctr, EnumSet.allOf(type), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, T value) {
        return NEnumSet.newInstance(ctr, EnumSet.of(value), value.getClass());
    }

    public static <T extends Enum<T>> NEnumSet<T> noneOfType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, Class<T> type) {
        return NEnumSet.newInstance(ctr, EnumSet.noneOf(type), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, T ... value) {
        Class<?> t = value[0].getClass();
        EnumSet<?> e = EnumSet.noneOf(t);
        e.addAll(Arrays.asList(value));
        return NEnumSet.newInstance(ctr, e, t);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, Collection<T> value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("unable to resolve enum type from empty collection");
        }
        Enum a = (Enum)value.stream().findAny().get();
        Class<?> t = a.getClass();
        return ctr.apply(NEnumSet.asSet(value), t);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, Collection<T> value, Class<T> tt) {
        return NEnumSet.newInstance(ctr, NEnumSet.asSet(value), tt);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, T[] value, Class<T> tt) {
        return NEnumSet.newInstance(ctr, NEnumSet.asSet(Arrays.asList(value)), tt);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofTypeBitSet(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, long bits, Class<T> type) {
        return NEnumSet.newInstance(ctr, NEnumSet.bitToSet(bits, type), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofTypeBitSet(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, BigInteger bits, Class<T> type) {
        return NEnumSet.newInstance(ctr, NEnumSet.bitToSet(BitSet.valueOf(bits.toByteArray()), type), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofTypeBitSet(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, BitSet bits, Class<T> type) {
        return NEnumSet.newInstance(ctr, NEnumSet.bitToSet(bits, type), type);
    }

    public static <T extends Enum<T>> NEnumSet<T> of(Class<T> type) {
        return NEnumSet.noneOf(type);
    }

    public static <T extends Enum<T>> NEnumSet<T> ofType(NFunction2<Set<T>, Class<T>, NEnumSet<T>> setType, Class<T> type) {
        return NEnumSet.noneOfType(setType, type);
    }

    protected NEnumSet(Set<T> values, Class<T> type, NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr) {
        this.ctr = ctr;
        NAssert.requireNonNull(ctr, "ctr");
        this.maxSize = ((Enum[])type.getEnumConstants()).length;
        this.values = EnumSet.noneOf(type);
        this.type = type;
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public boolean contains(T any) {
        return any != null && this.values.contains(any);
    }

    public NEnumSet<T> retainAll(T ... any) {
        return this.retainAll((Collection<T>)Arrays.asList(any));
    }

    public NEnumSet<T> retainAll(Collection<T> any) {
        HashSet<T> values2;
        if (any != null && (values2 = new HashSet<T>(this.values)).retainAll(any)) {
            return this.ctr.apply(values2, this.type);
        }
        return this;
    }

    public boolean containsAll(T ... any) {
        if (any != null) {
            return this.containsAll((Collection<T>)Arrays.asList(any));
        }
        return false;
    }

    public boolean containsAll(Collection<T> any) {
        return any != null && this.values.containsAll(any);
    }

    public boolean containsNone(T ... any) {
        if (any != null) {
            return this.containsNone((Collection<T>)Arrays.asList(any));
        }
        return false;
    }

    public boolean containsNone(Collection<T> any) {
        if (any != null) {
            for (Enum t : any) {
                if (!this.values.contains(t)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(T ... any) {
        if (any != null) {
            return this.containsAny((Collection<T>)Arrays.asList(any));
        }
        return false;
    }

    public boolean containsAny(Collection<T> any) {
        if (any != null) {
            for (Enum t : any) {
                if (!this.values.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public NEnumSet<T> add(T any) {
        if (any != null && !this.values.contains(any)) {
            HashSet<T> values2 = new HashSet<T>(this.values);
            values2.add(any);
            return this.ctr.apply(values2, this.type);
        }
        return this;
    }

    public NEnumSet<T> addAll(NEnumSet<T> other) {
        if (other != null) {
            return this.addAll((Collection<T>)other.toSet());
        }
        return this;
    }

    public NEnumSet<T> addAll(T ... any) {
        return this.addAll((Collection<T>)Arrays.asList(any));
    }

    public NEnumSet<T> addAll(Collection<T> any) {
        HashSet<T> values2 = new HashSet<T>(this.values);
        boolean changed = false;
        if (any != null) {
            for (Enum t : any) {
                if (!values2.add(t)) continue;
                changed = true;
            }
        }
        if (changed) {
            return this.ctr.apply(values2, this.type);
        }
        return this;
    }

    public NEnumSet<T> remove(T any) {
        if (any != null && this.values.contains(any)) {
            HashSet<T> values2 = new HashSet<T>(this.values);
            values2.remove(any);
            return this.ctr.apply(values2, this.type);
        }
        return this;
    }

    public NEnumSet<T> removeAll(T ... any) {
        return this.removeAll((Collection<T>)Arrays.asList(any));
    }

    public NEnumSet<T> complement() {
        return NEnumSet.allOf(this.type).removeAll((Collection<T>)this.values);
    }

    public NEnumSet<T> removeAll(Collection<T> any) {
        HashSet<T> values2 = new HashSet<T>(this.values);
        boolean changed = false;
        if (any != null) {
            for (Enum t : any) {
                if (!values2.remove(t)) continue;
                changed = true;
            }
        }
        if (changed) {
            return this.ctr.apply(values2, this.type);
        }
        return this;
    }

    public BitSet bitSet() {
        BitSet b = new BitSet();
        for (Enum value : this.values) {
            b.set(value.ordinal(), true);
        }
        return b;
    }

    public long bits() {
        long x = 0L;
        for (Enum value : this.values) {
            x += (long)value.ordinal() + 1L << 2;
        }
        return x;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isFull() {
        return this.values.size() == this.maxSize;
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    public Stream<T> stream() {
        return this.values.stream();
    }

    public Set<T> toSet() {
        return Collections.unmodifiableSet(this.values);
    }

    public T[] toArray() {
        return this.values.toArray((Enum[])Array.newInstance(this.type, 0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NEnumSet that = (NEnumSet)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.type);
    }

    public String toString() {
        return "{" + this.values.stream().map(x -> x instanceof NEnum ? ((NEnum)((Object)x)).id() : x.name()).collect(Collectors.joining(", ")) + "}";
    }

    private static <T extends Enum<T>> NEnumSet<T> newInstance(NFunction2<Set<T>, Class<T>, NEnumSet<T>> ctr, Set<T> set, Class<T> cls) {
        NAssert.requireNonNull(ctr, "constructor");
        NEnumSet<T> a = ctr.apply(set, cls);
        NAssert.requireNonNull(a, "instance");
        return a;
    }

    private static <T extends Enum<T>> NFunction2<Set<T>, Class<T>, NEnumSet<T>> DEFAULT_CTR() {
        return new NFunction2<Set<T>, Class<T>, NEnumSet<T>>(){

            @Override
            public NEnumSet<T> apply(Set<T> ts, Class<T> aClass) {
                return new NEnumSet(ts, aClass, this);
            }
        };
    }

    private static <T extends Enum<T>, V extends NEnumSet<T>> NFunction2<Set<T>, Class<T>, NEnumSet<T>> TYPED_CTR(Class<V> clz) {
        Constructor<V> d;
        NAssert.requireNonNull(clz, "enum set class");
        try {
            d = clz.getDeclaredConstructor(Set.class, Class.class, NFunction2.class);
            d.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("missing constructor for " + clz);
        }
        return new NFunction2<Set<T>, Class<T>, NEnumSet<T>>(){

            @Override
            public NEnumSet<T> apply(Set<T> ts, Class<T> aClass) {
                try {
                    return (NEnumSet)d.newInstance(ts, aClass, this);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
            }
        };
    }

    private static <T> Set<T> bitToSet(long values, Class<T> type) {
        LinkedHashSet<T> v = new LinkedHashSet<T>();
        T[] allValues = type.getEnumConstants();
        long x = 1L;
        int index = 0;
        while (values != 0L) {
            if ((values & x) != 0L) {
                v.add(allValues[index]);
                values &= x ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++index;
            x <<= 2;
        }
        return v;
    }

    private static <T> Set<T> bitToSet(BitSet values, Class<T> type) {
        LinkedHashSet<T> v = new LinkedHashSet<T>();
        T[] allValues = type.getEnumConstants();
        int index = 0;
        values = (BitSet)values.clone();
        while (values.isEmpty()) {
            if (values.get(index)) {
                v.add(allValues[index]);
                values.set(0);
            }
            ++index;
        }
        return v;
    }

    private static <T extends Enum<T>> LinkedHashSet<T> asSet(Collection<T> value) {
        if (value instanceof Set) {
            return (LinkedHashSet)value;
        }
        return new LinkedHashSet<T>(value);
    }
}

