/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.HashSet;
import java.util.function.Function;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.spi.base.AbstractNPredicate;

class NDistinctWithConverterPredicate<F, T>
extends AbstractNPredicate<F> {
    private final Function<F, T> converter;
    HashSet<T> visited;

    public NDistinctWithConverterPredicate(Function<F, T> converter) {
        this.converter = converter;
        this.visited = new HashSet();
    }

    @Override
    public boolean test(F value) {
        T t = this.converter.apply(value);
        if (this.visited.contains(t)) {
            return false;
        }
        this.visited.add(t);
        return true;
    }

    public String toString() {
        return "DistinctConverter[" + this.converter + "]";
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().set("distinctBy", NElementDescribables.describeResolveOrDestruct(this.converter)).build();
    }
}

