/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.util.NObservableSet;
import net.thevpc.nuts.util.NObservableSetListener;

public class NDefaultObservableSet<V>
extends AbstractSet<V>
implements NObservableSet<V> {
    private Set<V> base = new HashSet<V>();
    private List<NObservableSetListener<V>> listeners;

    public NDefaultObservableSet(Set<V> base) {
        this.base = base == null ? new HashSet() : base;
    }

    @Override
    public void addSetListener(NObservableSetListener<V> listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<NObservableSetListener<V>>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeSetListener(NObservableSetListener<V> listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public boolean add(V v) {
        if (super.add(v)) {
            if (this.listeners != null) {
                for (NObservableSetListener<V> listener : this.listeners) {
                    listener.itemAdded(v);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o) && this.listeners != null) {
            for (NObservableSetListener<Object> nObservableSetListener : this.listeners) {
                nObservableSetListener.itemRemoved(o);
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof NDefaultObservableSet) {
            return this.base.equals(((NDefaultObservableSet)o).base);
        }
        return this.base.equals(o);
    }

    @Override
    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public List<NObservableSetListener<V>> getSetListeners() {
        return this.listeners;
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.base.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.base.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.base.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.base.containsAll(c);
    }

    @Override
    public String toString() {
        return this.base.toString();
    }

    @Override
    public Iterator<V> iterator() {
        final Iterator<V> baseIterator = this.base.iterator();
        return new Iterator<V>(){
            V curr;

            @Override
            public boolean hasNext() {
                return baseIterator.hasNext();
            }

            @Override
            public V next() {
                this.curr = baseIterator.next();
                return this.curr;
            }

            @Override
            public void remove() {
                baseIterator.remove();
                if (NDefaultObservableSet.this.listeners != null) {
                    for (NObservableSetListener listener : NDefaultObservableSet.this.listeners) {
                        listener.itemRemoved(this.curr);
                    }
                }
            }
        };
    }
}

