/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;

public class NDateUtils {
    public static Instant toStartOfDay(Instant instant) {
        return NDateUtils.toStartOfDay(instant, null);
    }

    public static Instant toEndOfDay(Instant instant) {
        return NDateUtils.toEndOfDay(instant, null);
    }

    public static Instant toStartOfWeek(Instant instant) {
        return NDateUtils.toStartOfWeek(instant, null);
    }

    public static Instant toEndOfWeek(Instant instant) {
        return NDateUtils.toEndOfWeek(instant, null);
    }

    public static Instant toStartOfMonth(Instant instant) {
        return NDateUtils.toStartOfMonth(instant, null);
    }

    public static Instant toEndOfMonth(Instant instant) {
        return NDateUtils.toEndOfMonth(instant, null);
    }

    public static Instant toStartOfYear(Instant instant) {
        return NDateUtils.toStartOfYear(instant, null);
    }

    public static Instant toEndOfYear(Instant instant) {
        return NDateUtils.toEndOfYear(instant, null);
    }

    public static Instant toStartOfSemester(Instant instant) {
        return NDateUtils.toStartOfSemester(instant, null);
    }

    public static Instant toEndOfSemester(Instant instant) {
        return NDateUtils.toEndOfSemester(instant, null);
    }

    public static Instant toStartOfQuarter(Instant instant) {
        return NDateUtils.toStartOfQuarter(instant, null);
    }

    public static Instant toEndOfQuarter(Instant instant) {
        return NDateUtils.toEndOfQuarter(instant, null);
    }

    public static Instant toStartOfDay(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        ZonedDateTime zonedDateTime = instant.atZone(zone);
        LocalDate date = zonedDateTime.toLocalDate();
        return date.atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfDay(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        ZonedDateTime zonedDateTime = instant.atZone(zone);
        LocalDate date = zonedDateTime.toLocalDate();
        return LocalDateTime.of(date, LocalTime.MAX).atZone(zone).toInstant();
    }

    public static Instant toStartOfWeek(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return instant.atZone(zone).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).toLocalDate().atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfWeek(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate endOfWeekDate = instant.atZone(zone).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)).toLocalDate();
        LocalDateTime endOfDay = LocalDateTime.of(endOfWeekDate, LocalTime.MAX);
        return endOfDay.atZone(zone).toInstant();
    }

    public static Instant toStartOfMonth(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return instant.atZone(zone).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate().atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfMonth(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate endOfMonthDate = instant.atZone(zone).with(TemporalAdjusters.lastDayOfMonth()).toLocalDate();
        LocalDateTime endOfDay = LocalDateTime.of(endOfMonthDate, LocalTime.MAX);
        return endOfDay.atZone(zone).toInstant();
    }

    public static Instant toStartOfYear(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        return instant.atZone(zone).with(TemporalAdjusters.firstDayOfYear()).toLocalDate().atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfYear(Instant instant, ZoneId zone) {
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate endOfYearDate = instant.atZone(zone).with(TemporalAdjusters.lastDayOfYear()).toLocalDate();
        LocalDateTime endOfDay = LocalDateTime.of(endOfYearDate, LocalTime.MAX);
        return endOfDay.atZone(zone).toInstant();
    }

    public static Instant toStartOfSemester(Instant instant, ZoneId zone) {
        int month;
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate startOfSemester = (month = instant.atZone(zone).getMonthValue()) <= 6 ? LocalDate.of(instant.atZone(zone).getYear(), 1, 1) : LocalDate.of(instant.atZone(zone).getYear(), 7, 1);
        return startOfSemester.atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfSemester(Instant instant, ZoneId zone) {
        int month;
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate endOfSemester = (month = instant.atZone(zone).getMonthValue()) <= 6 ? LocalDate.of(instant.atZone(zone).getYear(), 6, 30) : LocalDate.of(instant.atZone(zone).getYear(), 12, 31);
        LocalDateTime endOfDay = LocalDateTime.of(endOfSemester, LocalTime.MAX);
        return endOfDay.atZone(zone).toInstant();
    }

    public static Instant toStartOfQuarter(Instant instant, ZoneId zone) {
        int month;
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate startOfQuarter = (month = instant.atZone(zone).getMonthValue()) <= 3 ? LocalDate.of(instant.atZone(zone).getYear(), 1, 1) : (month <= 6 ? LocalDate.of(instant.atZone(zone).getYear(), 4, 1) : (month <= 9 ? LocalDate.of(instant.atZone(zone).getYear(), 7, 1) : LocalDate.of(instant.atZone(zone).getYear(), 10, 1)));
        return startOfQuarter.atStartOfDay(zone).toInstant();
    }

    public static Instant toEndOfQuarter(Instant instant, ZoneId zone) {
        int month;
        if (instant == null) {
            return null;
        }
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        LocalDate endOfQuarter = (month = instant.atZone(zone).getMonthValue()) <= 3 ? LocalDate.of(instant.atZone(zone).getYear(), 3, 31) : (month <= 6 ? LocalDate.of(instant.atZone(zone).getYear(), 6, 30) : (month <= 9 ? LocalDate.of(instant.atZone(zone).getYear(), 9, 30) : LocalDate.of(instant.atZone(zone).getYear(), 12, 31)));
        LocalDateTime endOfDay = LocalDateTime.of(endOfQuarter, LocalTime.MAX);
        return endOfDay.atZone(zone).toInstant();
    }
}

