/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Iterator;
import java.util.function.Function;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NIteratorBase;

public class NConvertedNonNullIterator<F, T>
extends NIteratorBase<T> {
    private final Iterator<F> base;
    private final Function<F, T> converter;
    private final String convertName;
    private T lastVal;

    public NConvertedNonNullIterator(Iterator<F> base, Function<F, T> converter, String convertName) {
        this.base = base;
        this.converter = converter;
        if (convertName == null) {
            convertName = this.converter.toString();
        }
        this.convertName = convertName;
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("Map").set("accept", "isNotNull").set("mapper", (NElement)NElementDescribables.describeResolveOrDestructAsObject(this.converter).builder().set("name", this.convertName).build()).build();
    }

    @Override
    public boolean hasNext() {
        while (this.base.hasNext()) {
            F i = this.base.next();
            if (i == null) continue;
            this.lastVal = this.converter.apply(i);
            if (this.lastVal == null) continue;
            break;
        }
        return this.lastVal != null;
    }

    @Override
    public T next() {
        return this.lastVal;
    }

    @Override
    public void remove() {
        throw new IllegalArgumentException("unsupported remove");
    }

    public String toString() {
        return "ConvertedNonNullIterator(" + this.base + "," + this.convertName + ")";
    }
}

