/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.thevpc.nuts.util.NCollectionDiff;
import net.thevpc.nuts.util.NCollectionDiffChange;
import net.thevpc.nuts.util.NDiffMode;
import net.thevpc.nuts.util.NEqualizer;
import net.thevpc.nuts.util.NValueAndPos;

public class NCollectionDiffBuilder<T, K> {
    private Collection<T> oldItems;
    private Collection<T> newItems;
    private Function<T, K> idResolver;
    private NEqualizer<T> equalizer;

    NCollectionDiffBuilder() {
    }

    public Collection<T> getOldItems() {
        return this.oldItems;
    }

    public NCollectionDiffBuilder<T, K> setOldItems(Collection<T> oldItems) {
        this.oldItems = oldItems;
        return this;
    }

    public Collection<T> getNewItems() {
        return this.newItems;
    }

    public NCollectionDiffBuilder<T, K> setNewItems(Collection<T> newItems) {
        this.newItems = newItems;
        return this;
    }

    public Function<T, K> getIdResolver() {
        return this.idResolver;
    }

    public NCollectionDiffBuilder<T, K> setIdResolver(Function<T, K> idResolver) {
        this.idResolver = idResolver;
        return this;
    }

    public NEqualizer<T> getEqualizer() {
        return this.equalizer;
    }

    public NCollectionDiffBuilder<T, K> setEqualizer(NEqualizer<T> equalize) {
        this.equalizer = equalize;
        return this;
    }

    public NCollectionDiff<T> diff() {
        NValueAndPos n;
        Iterator iterator;
        List values;
        List e;
        Object k;
        int pos;
        NEqualizer<Object> equalizer;
        Function<Object, Object> id = this.idResolver;
        if (id == null) {
            id = x -> x;
        }
        if ((equalizer = this.equalizer) == null) {
            equalizer = (a, b) -> Objects.equals(a, b);
        }
        LinkedHashMap<Object, List> oldMap = new LinkedHashMap<Object, List>();
        LinkedHashMap<Object, List> newMap = new LinkedHashMap<Object, List>();
        if (this.oldItems != null) {
            pos = 0;
            for (T t : this.oldItems) {
                k = t == null ? null : id.apply(t);
                e = oldMap.computeIfAbsent(k, x -> new ArrayList());
                e.add(new NValueAndPos<T>(t, pos));
                ++pos;
            }
        }
        if (this.newItems != null) {
            pos = 0;
            for (T t : this.newItems) {
                k = t == null ? null : id.apply(t);
                e = newMap.computeIfAbsent(k, x -> new ArrayList());
                e.add(new NValueAndPos<T>(t, pos));
                ++pos;
            }
        }
        NCollectionDiff d = new NCollectionDiff(this.oldItems, this.newItems);
        for (Map.Entry entry : oldMap.entrySet()) {
            values = (List)entry.getValue();
            iterator = values.iterator();
            while (iterator.hasNext()) {
                NValueAndPos oldValue = (NValueAndPos)iterator.next();
                iterator.remove();
                List inB = (List)newMap.get(entry.getKey());
                if (inB != null && inB.size() > 0) {
                    n = (NValueAndPos)inB.remove(0);
                    if (equalizer.equals(oldValue.value, n.value)) {
                        d.register(new NCollectionDiffChange(NDiffMode.UNCHANGED, oldValue, n));
                        continue;
                    }
                    d.register(new NCollectionDiffChange(NDiffMode.CHANGED, oldValue, n));
                    continue;
                }
                d.register(new NCollectionDiffChange<Object>(NDiffMode.REMOVED, oldValue, new NValueAndPos<Object>(null, -1)));
            }
        }
        for (Map.Entry entry : newMap.entrySet()) {
            values = (List)entry.getValue();
            iterator = values.iterator();
            while (iterator.hasNext()) {
                NValueAndPos newValue = (NValueAndPos)iterator.next();
                iterator.remove();
                List inA = (List)oldMap.get(entry.getKey());
                if (inA != null && inA.size() > 0) {
                    n = (NValueAndPos)inA.remove(0);
                    if (equalizer.equals(newValue.value, n.value)) {
                        d.register(new NCollectionDiffChange(NDiffMode.UNCHANGED, newValue, n));
                        continue;
                    }
                    d.register(new NCollectionDiffChange(NDiffMode.CHANGED, newValue, n));
                    continue;
                }
                d.register(new NCollectionDiffChange<Object>(NDiffMode.ADDED, new NValueAndPos<Object>(null, -1), newValue));
            }
        }
        d.sort();
        return d;
    }
}

