/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thevpc.nuts.util.NCollectionDiffApplier;
import net.thevpc.nuts.util.NCollectionDiffBuilder;
import net.thevpc.nuts.util.NCollectionDiffChange;
import net.thevpc.nuts.util.NDiffMode;

public class NCollectionDiff<T>
implements Iterable<NCollectionDiffChange<T>> {
    private final Collection<T> oldItems;
    private final Collection<T> newItems;
    private final List<NCollectionDiffChange<T>> changes = new ArrayList<NCollectionDiffChange<T>>();

    public NCollectionDiff(Collection<T> oldItems, Collection<T> newItems) {
        this.oldItems = oldItems;
        this.newItems = newItems;
    }

    public Collection<T> getOldItems() {
        return this.oldItems;
    }

    public Collection<T> getNewItems() {
        return this.newItems;
    }

    void register(NCollectionDiffChange<T> a) {
        this.changes.add(a);
    }

    public boolean anyAdd() {
        return this.changes.stream().anyMatch(x -> x.getMode() == NDiffMode.ADDED);
    }

    @Override
    public Iterator<NCollectionDiffChange<T>> iterator() {
        return Collections.unmodifiableList(this.changes).iterator();
    }

    public boolean anyRemove() {
        return this.changes.stream().anyMatch(x -> x.getMode() == NDiffMode.REMOVED);
    }

    public boolean anyChange() {
        return this.changes.stream().anyMatch(x -> x.getMode() != NDiffMode.UNCHANGED);
    }

    public List<T> getAdded() {
        return this.changes.stream().filter(x -> x.getMode() == NDiffMode.ADDED).map((? super T x) -> x.getNewValue()).collect(Collectors.toList());
    }

    public List<T> getRemoved() {
        return this.changes.stream().filter(x -> x.getMode() == NDiffMode.REMOVED).map((? super T x) -> x.getOldValue()).collect(Collectors.toList());
    }

    public List<NCollectionDiffChange<T>> getChanged() {
        return this.changes.stream().filter(x -> x.getMode() == NDiffMode.CHANGED).collect(Collectors.toList());
    }

    public List<NCollectionDiffChange<T>> getUnchanged() {
        return this.changes.stream().filter(x -> x.getMode() == NDiffMode.UNCHANGED).collect(Collectors.toList());
    }

    public <H> NCollectionDiff<H> map(Function<T, H> f) {
        NCollectionDiff<T> d = new NCollectionDiff<T>(new MappedCollection<T, H>(this.oldItems, f), new MappedCollection<T, H>(this.newItems, f));
        d.changes.addAll(this.changes.stream().map((? super T x) -> x.map(f)).collect(Collectors.toList()));
        return d;
    }

    public static <T> NCollectionDiff<T> diffList(List<T> oldItems, List<T> newItems) {
        return NCollectionDiff.diffList(oldItems, newItems, x -> x);
    }

    public static <K, V> NCollectionDiff<Map.Entry<K, V>> diffMapEntries(Map<K, V> oldItems, Map<K, V> newItems) {
        return NCollectionDiff.diffList(oldItems.entrySet(), newItems.entrySet(), Map.Entry::getKey);
    }

    public static <K, V> NCollectionDiff<V> diffMapValues(Map<K, V> oldItems, Map<K, V> newItems) {
        return NCollectionDiff.diffMapEntries(oldItems, newItems).map(Map.Entry::getValue);
    }

    public static <K, V> NCollectionDiff<K> diffMapKeys(Map<K, V> oldItems, Map<K, V> newItems) {
        return NCollectionDiff.diffMapEntries(oldItems, newItems).map(Map.Entry::getKey);
    }

    public static <T, K> NCollectionDiff<T> diffList(Collection<T> oldItems, Collection<T> newItems, Function<T, K> id) {
        return new NCollectionDiffBuilder().setOldItems(oldItems).setNewItems(newItems).setIdResolver(id).diff();
    }

    public static <T, K> NCollectionDiffBuilder<T, K> of(Collection<T> oldItems, Collection<T> newItems) {
        return new NCollectionDiffBuilder().setOldItems(oldItems).setNewItems(newItems);
    }

    void sort() {
        this.changes.sort(Comparator.comparingInt(a -> a.newPos));
    }

    public void apply(NCollectionDiffApplier<T> a) {
        for (T t : this.getRemoved()) {
            a.remove(t, this);
        }
        for (T t : this.getAdded()) {
            a.add(t, this);
        }
        for (NCollectionDiffChange nCollectionDiffChange : this.getChanged()) {
            a.update(nCollectionDiffChange.getNewValue(), nCollectionDiffChange.getOldValue(), this);
        }
    }

    private static class MappedCollection<A, B>
    extends AbstractCollection<B> {
        private Collection<A> base;
        private Function<A, B> f;

        public MappedCollection(Collection<A> base, Function<A, B> f) {
            this.base = base;
            this.f = f;
        }

        @Override
        public Iterator<B> iterator() {
            final Iterator<A> baseIt = this.base.iterator();
            return new Iterator<B>(){

                @Override
                public boolean hasNext() {
                    return baseIt.hasNext();
                }

                @Override
                public B next() {
                    return f.apply(baseIt.next());
                }
            };
        }

        @Override
        public int size() {
            return this.base.size();
        }
    }
}

