/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.LinkedList;
import java.util.Queue;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBase;
import net.thevpc.nuts.util.NIteratorUtils;

public class NCoalesceIterator<T>
extends NIteratorBase<T> {
    private Queue<NIterator<? extends T>> children = new LinkedList<NIterator<? extends T>>();
    private int size = 0;

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().name("Coalesce").addAll((NElement[])this.children.stream().map(x -> NElementDescribables.describeResolveOrDestruct(x)).toArray(NElement[]::new)).build();
    }

    public void addNonNull(NIterator<T> child) {
        if (child != null) {
            this.add(child);
        }
    }

    public void addNonEmpty(NIterator<T> child) {
        if ((child = NIteratorUtils.nullifyIfEmpty(child)) != null) {
            this.add(child);
        }
    }

    public void add(NIterator<? extends T> child) {
        NAssert.requireNonNull(child, "child");
        if (child instanceof NCoalesceIterator) {
            this.children.addAll(((NCoalesceIterator)child).children);
        } else {
            this.children.add(child);
        }
        this.size = this.children.size();
    }

    public int size() {
        return this.children.size();
    }

    public NIterator<T>[] getChildren() {
        return this.children.toArray(new NIterator[0]);
    }

    @Override
    public boolean hasNext() {
        while (!this.children.isEmpty()) {
            if (this.children.peek().hasNext()) {
                if (this.size > 1) {
                    NIterator<? extends T> h = this.children.poll();
                    this.children.clear();
                    this.children.offer(h);
                    this.size = 1;
                }
                return true;
            }
            this.children.poll();
            --this.size;
        }
        return false;
    }

    @Override
    public T next() {
        return (T)this.children.peek().next();
    }

    @Override
    public void remove() {
        this.children.peek().remove();
    }

    public String toString() {
        return "Coalesce(" + this.children + ')';
    }
}

