/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class NCaseInsensitiveStringMap<T>
extends AbstractMap<String, T>
implements Map<String, T> {
    private final Map<String, Map.Entry<String, T>> map = new HashMap<String, Map.Entry<String, T>>();

    public NCaseInsensitiveStringMap() {
    }

    public NCaseInsensitiveStringMap(Map<String, T> other) {
        if (other != null) {
            this.putAll(other);
        }
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet().stream().map(x -> new AbstractMap.SimpleImmutableEntry((String)((Map.Entry)x.getValue()).getKey(), ((Map.Entry)x.getValue()).getValue())).collect(Collectors.toSet());
    }

    @Override
    public T get(Object key) {
        Map.Entry<String, T> u = this.map.get(NCaseInsensitiveStringMap.normalizeKey(key));
        return u == null ? null : (T)u.getValue();
    }

    private static String normalizeKey(Object key) {
        return key == null ? null : key.toString().toLowerCase();
    }

    private static String normalizeKey(String key) {
        return key == null ? null : key.toLowerCase();
    }

    @Override
    public T put(String key, T value) {
        Map.Entry old = this.map.put(NCaseInsensitiveStringMap.normalizeKey(key), new AbstractMap.SimpleImmutableEntry<String, T>(key, value));
        return old == null ? null : (T)old.getValue();
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(NCaseInsensitiveStringMap.normalizeKey(key), value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(NCaseInsensitiveStringMap.normalizeKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }
}

