/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.util.NBPlusTree;
import net.thevpc.nuts.util.NBPlusTreeStoreMemNode;

public class NBPlusTreeStoreMemLeafNode<K extends Comparable<K>, V>
extends NBPlusTreeStoreMemNode<K, V>
implements NBPlusTree.LeafNode<K, V> {
    NBPlusTree.LeafNode<K, V> leftSibling;
    NBPlusTree.LeafNode<K, V> rightSibling;
    Map.Entry<K, V>[] dictionary;

    public void delete(int index) {
        this.dictionary[index] = null;
        --this.size;
    }

    @Override
    public K firstKey() {
        return (K)((Comparable)this.dictionary[0].getKey());
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public List<K> keys() {
        return new AbstractList<K>(){

            @Override
            public K get(int index) {
                return (Comparable)NBPlusTreeStoreMemLeafNode.this.dictionary[index].getKey();
            }

            @Override
            public int size() {
                return NBPlusTreeStoreMemLeafNode.this.size;
            }
        };
    }

    @Override
    public V valueAt(int index) {
        return this.dictionary[index].getValue();
    }

    @Override
    public K keyAt(int index) {
        return (K)((Comparable)this.dictionary[index].getKey());
    }

    public V setValueAt(int index, V value) {
        Map.Entry<K, V> e = this.dictionary[index];
        V old = e.getValue();
        this.dictionary[index] = new AbstractMap.SimpleEntry<Comparable, V>((Comparable)e.getKey(), value);
        return old;
    }

    @Override
    public Map.Entry<K, V> entryAt(int index) {
        return this.dictionary[index];
    }

    @Override
    public NBPlusTree.LeafNode<K, V> leftSibling() {
        return this.leftSibling;
    }

    @Override
    public NBPlusTree.LeafNode<K, V> rightSibling() {
        return this.rightSibling;
    }

    public NBPlusTreeStoreMemLeafNode(int m, NBPlusTree.IntermediateNode<K, V> parent) {
        this.maxSize = m - 1;
        this.minSize = (int)(Math.ceil(m / 2) - 1.0);
        this.dictionary = new Map.Entry[m];
        this.size = 0;
        this.parent = parent;
    }

    public String toString() {
        return "LeafNodeMem{size=" + this.size + ", firstKey=" + this.firstKey() + ", values=" + Arrays.toString(this.dictionary) + '}';
    }
}

