/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.util.NBPlusTree;
import net.thevpc.nuts.util.NBPlusTreeHelper;
import net.thevpc.nuts.util.NBPlusTreeStore;
import net.thevpc.nuts.util.NBPlusTreeStoreMemIntermediateNode;
import net.thevpc.nuts.util.NBPlusTreeStoreMemLeafNode;
import net.thevpc.nuts.util.NBPlusTreeStoreMemNode;

public class NBPlusTreeStoreMem<K extends Comparable<K>, V>
implements NBPlusTreeStore<K, V> {
    protected boolean allowDuplicates;
    protected int m;
    protected long size;
    protected NBPlusTree.IntermediateNode<K, V> root;
    protected NBPlusTree.LeafNode<K, V> firstLeaf;

    public NBPlusTreeStoreMem() {
    }

    public NBPlusTreeStoreMem(int m, boolean allowDuplicates) {
        this.m = m;
        this.allowDuplicates = allowDuplicates;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public void updateParent(NBPlusTree.Node<K, V> root, NBPlusTree.IntermediateNode<K, V> parent) {
        ((NBPlusTreeStoreMemNode)root).parent = parent;
    }

    @Override
    public void save() {
    }

    @Override
    public NBPlusTree.LeafNode<K, V> createLeafNode(NBPlusTree.IntermediateNode<K, V> parent) {
        return new NBPlusTreeStoreMemLeafNode<K, V>(this.m, parent);
    }

    @Override
    public NBPlusTree.IntermediateNode<K, V> createInternalNode() {
        return new NBPlusTreeStoreMemIntermediateNode(this.m);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void incSize(long sizeDiff) {
        this.size += sizeDiff;
    }

    @Override
    public NBPlusTree.IntermediateNode<K, V> root() {
        return this.root;
    }

    @Override
    public NBPlusTree.LeafNode<K, V> firstLeaf() {
        return this.firstLeaf;
    }

    @Override
    public int m() {
        return this.m;
    }

    @Override
    public void updateRoot(NBPlusTree.IntermediateNode<K, V> node) {
        this.root = node;
    }

    @Override
    public void updateFirstLeaf(NBPlusTree.LeafNode<K, V> node) {
        this.firstLeaf = node;
    }

    @Override
    public void free(NBPlusTree.Node<K, V> node) {
    }

    @Override
    public void updateLeftSibling(NBPlusTree.IntermediateNode<K, V> node, NBPlusTree.IntermediateNode<K, V> value) {
        NBPlusTreeStoreMemIntermediateNode m = (NBPlusTreeStoreMemIntermediateNode)node;
        m.leftSibling = (NBPlusTreeStoreMemIntermediateNode)value;
    }

    @Override
    public void updateRightSibling(NBPlusTree.IntermediateNode<K, V> node, NBPlusTree.IntermediateNode<K, V> value) {
        NBPlusTreeStoreMemIntermediateNode m = (NBPlusTreeStoreMemIntermediateNode)node;
        m.rightSibling = (NBPlusTreeStoreMemIntermediateNode)value;
    }

    @Override
    public void updateLeftSibling(NBPlusTree.LeafNode<K, V> node, NBPlusTree.LeafNode<K, V> value) {
        NBPlusTreeStoreMemLeafNode m = (NBPlusTreeStoreMemLeafNode)node;
        m.leftSibling = (NBPlusTreeStoreMemLeafNode)value;
    }

    @Override
    public void updateRightSibling(NBPlusTree.LeafNode<K, V> node, NBPlusTree.LeafNode<K, V> value) {
        NBPlusTreeStoreMemLeafNode m = (NBPlusTreeStoreMemLeafNode)node;
        m.rightSibling = (NBPlusTreeStoreMemLeafNode)value;
    }

    @Override
    public void addEntry(NBPlusTree.LeafNode<K, V> node, K k, V v) {
        NBPlusTreeStoreMemLeafNode nn = (NBPlusTreeStoreMemLeafNode)node;
        AbstractMap.SimpleEntry<K, V> nv = new AbstractMap.SimpleEntry<K, V>(k, v);
        int index = Arrays.binarySearch(nn.dictionary, 0, nn.size, nv, NBPlusTreeHelper::compareEntries);
        if (index >= 0) {
            while (index < nn.size && Objects.equals(nn.dictionary[index].getKey(), k)) {
                ++index;
            }
            System.arraycopy(nn.dictionary, index, nn.dictionary, index + 1, nn.size - index);
            nn.dictionary[index] = nv;
        } else {
            index = -index - 1;
        }
        System.arraycopy(nn.dictionary, index, nn.dictionary, index + 1, nn.size - index);
        nn.dictionary[index] = nv;
        ++nn.size;
    }

    @Override
    public void addEntries(NBPlusTree.LeafNode<K, V> node, Map.Entry<K, V>[] orderedElements) {
        NBPlusTreeStoreMemLeafNode nn = (NBPlusTreeStoreMemLeafNode)node;
        if (orderedElements != null && orderedElements.length > 0) {
            Map.Entry<K, V> firstNext = orderedElements[0];
            Map.Entry[] arr1 = new Map.Entry[nn.size];
            System.arraycopy(nn.dictionary, 0, arr1, 0, arr1.length);
            Map.Entry<K, V>[] arr2 = orderedElements;
            int i = 0;
            int j = 0;
            int k = 0;
            int n1 = nn.size;
            int n2 = arr2.length;
            while (i < n1 && j < n2) {
                if (NBPlusTreeHelper.compareEntries(arr1[i], arr2[j]) < 0) {
                    nn.dictionary[k++] = arr1[i++];
                    continue;
                }
                nn.dictionary[k++] = arr2[j++];
            }
            System.arraycopy(arr1, i, nn.dictionary, k, n1 - i);
            System.arraycopy(arr2, j, nn.dictionary, k + n1 - i, n2 - j);
            nn.size += orderedElements.length;
        }
    }

    @Override
    public int findIndexOfChild(NBPlusTree.IntermediateNode<K, V> node, NBPlusTree.Node<K, V> child) {
        NBPlusTreeStoreMemIntermediateNode nn = (NBPlusTreeStoreMemIntermediateNode)node;
        for (int i = 0; i < nn.children.length; ++i) {
            if (!NBPlusTreeHelper.eq(nn.children[i], child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addChild(NBPlusTree.IntermediateNode<K, V> node, NBPlusTree.Node<K, V> pointer, int index) {
        NBPlusTreeStoreMemIntermediateNode nn = (NBPlusTreeStoreMemIntermediateNode)node;
        if (index < 0) {
            index = nn.size;
        }
        System.arraycopy(nn.children, index, nn.children, index + 1, nn.size - index);
        nn.children[index] = (NBPlusTreeStoreMemNode)pointer;
        ++nn.size;
        if (index == 0) {
            nn.firstKey = nn.children[0].firstKey();
        }
    }

    @Override
    public void updateChildAt(NBPlusTree.IntermediateNode<K, V> node, int index, K key, NBPlusTree.Node<K, V> child) {
        NBPlusTreeStoreMemIntermediateNode nn = (NBPlusTreeStoreMemIntermediateNode)node;
        nn.children[index] = (NBPlusTreeStoreMemNode)child;
        if (index == 0) {
            nn.firstKey = nn.children[0].firstKey();
        }
    }

    @Override
    public V updateValueAt(NBPlusTree.LeafNode<K, V> node, int index, V value) {
        NBPlusTreeStoreMemLeafNode nn = (NBPlusTreeStoreMemLeafNode)node;
        return nn.setValueAt(index, value);
    }

    @Override
    public void removeChildAt(NBPlusTree.LeafNode<K, V> node, int index) {
        NBPlusTreeStoreMemLeafNode nn = (NBPlusTreeStoreMemLeafNode)node;
        System.arraycopy(nn.dictionary, index + 1, nn.dictionary, index, nn.size - index - 1);
        --nn.size;
        nn.dictionary[nn.size] = null;
    }

    @Override
    public int indexOfKey(NBPlusTree.LeafNode<K, V> node, K key) {
        NBPlusTreeStoreMemLeafNode nn = (NBPlusTreeStoreMemLeafNode)node;
        AbstractMap.SimpleEntry<K, Object> e = new AbstractMap.SimpleEntry<K, Object>(key, null);
        return Arrays.binarySearch(nn.dictionary, 0, nn.size, e, NBPlusTreeHelper::compareEntries);
    }

    @Override
    public void removeChildAt(NBPlusTree.IntermediateNode<K, V> node, int index) {
        NBPlusTreeStoreMemIntermediateNode nn = (NBPlusTreeStoreMemIntermediateNode)node;
        System.arraycopy(nn.children, index + 1, nn.children, index, nn.size - index - 1);
        --nn.size;
        nn.children[nn.size] = null;
        if (index == 0) {
            nn.firstKey = nn.children[0] == null ? null : nn.children[0].firstKey();
        }
    }
}

