/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBPlusTreeHelper;
import net.thevpc.nuts.util.NBPlusTreeStore;
import net.thevpc.nuts.util.NBPlusTreeStoreMem;
import net.thevpc.nuts.util.NOptional;

public class NBPlusTree<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private NBPlusTreeStore<K, V> store;
    private int m;

    public static <K extends Comparable<K>, V> NBPlusTree<K, V> of(int m, boolean allowDuplicates) {
        return new NBPlusTree(new NBPlusTreeStoreMem(m, allowDuplicates));
    }

    public static <K extends Comparable<K>, V> NBPlusTree<K, V> of(int m) {
        return new NBPlusTree(new NBPlusTreeStoreMem(m, false));
    }

    public NBPlusTree(NBPlusTreeStore<K, V> store) {
        this.store = store;
        this.m = store.m();
    }

    private LeafNode<K, V> findLeafNode(K key) {
        IntermediateNode<K, V> node = this.store.root();
        if (node == null) {
            return this.store.firstLeaf();
        }
        return this.findLeafNode(node, key);
    }

    private LeafNode<K, V> findLeafNode(IntermediateNode<K, V> node, K key) {
        K key1;
        int i;
        int size = node.size();
        for (i = 0; i < size - 1 && NBPlusTreeHelper.compareKey(key, key1 = node.key(i + 1)) >= 0; ++i) {
        }
        Node<K, V> child = node.child(i);
        if (child.isLeaf()) {
            return (LeafNode)child;
        }
        return this.findLeafNode((IntermediateNode)child, key);
    }

    private int getMidpoint() {
        return (int)Math.ceil((double)(this.m + 1) / 2.0) - 1;
    }

    private void handleDeficiency(IntermediateNode<K, V> in) {
        if (in == null) {
            return;
        }
        if (in.size() != 0 && !NBPlusTreeHelper.isDeficient(in)) {
            return;
        }
        IntermediateNode parent = in.parent();
        if (NBPlusTreeHelper.eq(this.store.root(), in)) {
            for (int i = 0; i < in.size(); ++i) {
                if (in.child(i) == null) continue;
                if (in.child(i).isLeaf()) {
                    this.store.updateRoot(null);
                    continue;
                }
                this.store.updateRoot((IntermediateNode)in.child(i));
                this.store.updateParent(this.store.root(), null);
            }
        } else if (in.leftSibling() != null && NBPlusTreeHelper.isLendable(in.leftSibling())) {
            IntermediateNode<K, V> sibling = in.leftSibling();
        } else if (in.rightSibling() != null && NBPlusTreeHelper.isLendable(in.rightSibling())) {
            IntermediateNode<K, V> sibling = in.rightSibling();
            Node<K, V> node = sibling.child(0);
            this.store.updateChildAt(in, in.size(), parent.key(0), node);
            this.store.removeChildAt(sibling, 0);
        } else if ((in.leftSibling() == null || !NBPlusTreeHelper.isMergeable(in.leftSibling())) && in.rightSibling() != null && NBPlusTreeHelper.isMergeable(in.rightSibling())) {
            IntermediateNode<K, V> sibling = in.rightSibling();
            int childrenCount = in.size();
            for (int i = childrenCount - 1; i >= 0; ++i) {
                this.store.addChild(sibling, in.child(i), 0);
                this.store.updateParent(in.child(i), sibling);
            }
            this.store.removeChildAt(parent, this.store.findIndexOfChild(parent, in));
            this.store.updateLeftSibling(sibling, in.leftSibling());
            this.store.free(in);
        }
        this.handleDeficiency(parent);
        this.store.save();
    }

    @Override
    public boolean isEmpty() {
        return this.store.firstLeaf() == null;
    }

    private void splitInternalNode(IntermediateNode<K, V> in) {
        IntermediateNode parent = in.parent();
        int midpoint = this.getMidpoint();
        int childrenCount = in.size();
        Node[] halfPointers = new Node[this.m + 1];
        for (int i = childrenCount - 1; i >= midpoint + 1; --i) {
            halfPointers[i - midpoint - 1] = in.child(i);
            this.store.removeChildAt(in, i);
        }
        IntermediateNode<K, V> sibling = this.store.createInternalNode();
        for (int i = 0; i < halfPointers.length; ++i) {
            Node pointer = halfPointers[i];
            if (pointer == null) continue;
            this.store.addChild(sibling, pointer, -1);
            this.store.updateParent(pointer, sibling);
        }
        this.store.updateRightSibling(sibling, in.rightSibling());
        if (sibling.rightSibling() != null) {
            this.store.updateLeftSibling(sibling.rightSibling(), sibling);
        }
        this.store.updateRightSibling(in, sibling);
        this.store.updateLeftSibling(sibling, in);
        if (parent == null) {
            IntermediateNode<K, V> newRoot = this.store.createInternalNode();
            this.store.addChild(newRoot, in, -1);
            this.store.addChild(newRoot, sibling, -1);
            this.store.updateRoot(newRoot);
            this.store.updateParent(in, newRoot);
            this.store.updateParent(sibling, newRoot);
        } else {
            int pointerIndex = this.store.findIndexOfChild(parent, in) + 1;
            this.store.addChild(parent, sibling, pointerIndex);
            this.store.updateParent(sibling, parent);
        }
        this.store.save();
    }

    @Override
    public int size() {
        return (int)this.store.size();
    }

    public long sizeLong() {
        return this.store.size();
    }

    @Override
    public boolean remove(K key) {
        if (this.isEmpty()) {
            return false;
        }
        LeafNode<K, V> leafNode = this.findLeafNode(key);
        int dpIndex = this.store.indexOfKey(leafNode, key);
        if (dpIndex < 0) {
            return false;
        }
        this.store.removeChildAt(leafNode, dpIndex);
        for (Node<K, V> nn = leafNode; nn != null; nn = nn.parent()) {
            Node<K, V> ln;
            if (NBPlusTreeHelper.isEmpty(nn)) {
                Node oldRight;
                Node oldLeft;
                if (nn.isLeaf()) {
                    ln = nn;
                    oldLeft = ln.leftSibling();
                    oldRight = ln.rightSibling();
                    if (oldRight != null) {
                        this.store.updateLeftSibling(oldRight, oldLeft);
                    }
                    if (oldLeft != null) {
                        this.store.updateRightSibling(oldLeft, oldRight);
                    }
                    if (ln.parent() != null) {
                        int indexOfChild = this.store.findIndexOfChild(ln.parent(), ln);
                        this.store.removeChildAt(ln.parent(), indexOfChild);
                    }
                } else {
                    ln = (IntermediateNode)nn;
                    oldLeft = ln.leftSibling();
                    oldRight = ln.rightSibling();
                    if (oldRight != null) {
                        this.store.updateLeftSibling(oldRight, oldLeft);
                    }
                    if (oldLeft != null) {
                        this.store.updateRightSibling(oldLeft, oldRight);
                    }
                    if (ln.parent() != null) {
                        int indexOfChild = this.store.findIndexOfChild(ln.parent(), ln);
                        this.store.removeChildAt(ln.parent(), indexOfChild);
                    }
                }
                this.store.free(nn);
                continue;
            }
            if (NBPlusTreeHelper.isDeficient(nn)) {
                LeafNode sibling;
                if (!nn.isLeaf()) continue;
                ln = nn;
                IntermediateNode<K, V> parent = nn.parent();
                if (ln.leftSibling() != null && NBPlusTreeHelper.eq(ln.leftSibling().parent(), ln.parent()) && NBPlusTreeHelper.isLendable(ln.leftSibling())) {
                    sibling = ln.leftSibling();
                    Map.Entry borrowedDP = sibling.entryAt(sibling.size() - 1);
                    this.store.addEntry((LeafNode<Comparable, V>)ln, (Comparable)borrowedDP.getKey(), borrowedDP.getValue());
                    this.store.removeChildAt(sibling, sibling.size() - 1);
                    continue;
                }
                if (ln.rightSibling() != null && NBPlusTreeHelper.eq(ln.rightSibling().parent(), ln.parent()) && NBPlusTreeHelper.isLendable(ln.rightSibling())) {
                    sibling = ln.rightSibling();
                    Map.Entry borrowedDP = sibling.entryAt(0);
                    this.store.addEntry((LeafNode<Comparable, V>)ln, (Comparable)borrowedDP.getKey(), borrowedDP.getValue());
                    this.store.removeChildAt(sibling, 0);
                    continue;
                }
                if (ln.leftSibling() != null && ln.leftSibling().parent() == ln.parent() && NBPlusTreeHelper.isMergeable(ln.leftSibling())) {
                    sibling = ln.leftSibling();
                    this.store.removeChildAt(parent, this.store.findIndexOfChild(parent, ln));
                    this.store.updateRightSibling(sibling, ln.rightSibling());
                    this.handleDeficiency(parent);
                    continue;
                }
                if (ln.rightSibling() == null || !NBPlusTreeHelper.eq(ln.rightSibling().parent(), ln.parent()) || !NBPlusTreeHelper.isMergeable(ln.rightSibling())) continue;
                sibling = ln.rightSibling();
                int pointerIndex = this.store.findIndexOfChild(parent, ln);
                this.store.removeChildAt(parent, pointerIndex);
                this.store.updateLeftSibling(sibling, ln.leftSibling());
                if (sibling.leftSibling() == null) {
                    this.store.updateFirstLeaf(sibling);
                }
                this.handleDeficiency(parent);
                continue;
            }
            if (this.store.root() != null || this.store.firstLeaf().size() != 0) break;
            this.store.updateFirstLeaf(null);
            break;
        }
        this.store.incSize(-1L);
        this.store.save();
        return true;
    }

    @Override
    public V put(K key, V value) {
        return this.add(key, value, this.store.isAllowDuplicates());
    }

    @Override
    public V putIfAbsent(K key, V value) {
        NOptional<V> v = this.getOptional(key);
        if (v.isNotPresent()) {
            return this.put(key, value);
        }
        return v.get();
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        NAssert.requireNonNull(mappingFunction);
        NOptional<V> u = this.getOptional(key);
        if (u.isNotPresent()) {
            V newValue = mappingFunction.apply(key);
            this.put(key, newValue);
            return newValue;
        }
        return u.get();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return NBPlusTree.this.entryIterator();
            }

            @Override
            public int size() {
                return NBPlusTree.this.size();
            }
        };
    }

    public V add(K key, V value, boolean allowDuplicate) {
        int index;
        allowDuplicate &= this.store.isAllowDuplicates();
        if (this.isEmpty()) {
            LeafNode<K, V> ln = this.store.createLeafNode(null);
            this.store.addEntry(ln, key, value);
            this.store.incSize(1L);
            this.store.updateFirstLeaf(ln);
            this.store.save();
            return null;
        }
        LeafNode<K, V> ln = this.findLeafNode(key);
        if (!allowDuplicate && (index = this.store.indexOfKey(ln, key)) >= 0) {
            V oldValue = this.store.updateValueAt(ln, index, value);
            this.store.save();
            return oldValue;
        }
        if (NBPlusTreeHelper.isFull(ln)) {
            int midpoint = this.getMidpoint();
            int lnSize = ln.size();
            Map.Entry[] halfDict = new Map.Entry[lnSize - midpoint + 1];
            for (int i = lnSize - 1; i >= midpoint; --i) {
                halfDict[i - midpoint] = ln.entryAt(i);
                this.store.removeChildAt(ln, i);
            }
            halfDict[halfDict.length - 1] = new AbstractMap.SimpleEntry<K, V>(key, value);
            Comparable k0 = null;
            if (ln.parent() == null) {
                IntermediateNode<K, V> parent = this.store.createInternalNode();
                this.store.updateParent(ln, parent);
                this.store.addChild(parent, ln, -1);
            } else {
                Comparable newParentKey;
                k0 = newParentKey = (Comparable)halfDict[0].getKey();
            }
            LeafNode<K, V> newLeafNode = this.store.createLeafNode(ln.parent());
            this.store.addEntries(newLeafNode, halfDict);
            int pointerIndex = this.store.findIndexOfChild(ln.parent(), ln) + 1;
            this.store.addChild(ln.parent(), newLeafNode, pointerIndex);
            this.store.updateRightSibling(newLeafNode, ln.rightSibling());
            if (newLeafNode.rightSibling() != null) {
                this.store.updateLeftSibling(newLeafNode.rightSibling(), newLeafNode);
            }
            this.store.updateRightSibling(ln, newLeafNode);
            this.store.updateLeftSibling(newLeafNode, ln);
            if (this.store.root() == null) {
                this.store.updateRoot(ln.parent());
            } else {
                for (IntermediateNode in = ln.parent(); in != null && NBPlusTreeHelper.isOverfull(in); in = in.parent()) {
                    this.splitInternalNode(in);
                }
            }
        } else {
            this.store.addEntry(ln, key, value);
            this.store.incSize(1L);
            this.store.save();
            return null;
        }
        this.store.incSize(1L);
        this.store.save();
        return null;
    }

    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            private LeafNode<K, V> curr;
            private int index;
            private Map.Entry e;
            {
                this.curr = NBPlusTree.this.store.firstLeaf();
            }

            @Override
            public boolean hasNext() {
                while (this.curr != null) {
                    if (this.index < this.curr.size()) {
                        this.e = this.curr.entryAt(this.index);
                        ++this.index;
                        if (this.index >= this.curr.size()) {
                            this.index = 0;
                            this.curr = this.curr.rightSibling();
                        }
                        return true;
                    }
                    this.index = 0;
                    this.curr = this.curr.rightSibling();
                }
                return false;
            }

            @Override
            public Map.Entry<K, V> next() {
                return this.e;
            }
        };
    }

    public Iterator<K> keyIterator() {
        return new Iterator<K>(){
            private LeafNode<K, V> curr;
            private int index;
            private K e;
            {
                this.curr = NBPlusTree.this.store.firstLeaf();
            }

            @Override
            public boolean hasNext() {
                while (this.curr != null) {
                    if (this.index < this.curr.size()) {
                        this.e = this.curr.keyAt(this.index);
                        ++this.index;
                        if (this.index >= this.curr.size()) {
                            this.index = 0;
                            this.curr = this.curr.rightSibling();
                        }
                        return true;
                    }
                    this.index = 0;
                    this.curr = this.curr.rightSibling();
                }
                return false;
            }

            @Override
            public K next() {
                return this.e;
            }
        };
    }

    public List<V> search(K key) {
        K u;
        if (this.isEmpty()) {
            return new ArrayList();
        }
        LeafNode<K, V> ln = this.findLeafNode(key);
        int index = this.store.indexOfKey(ln, key);
        if (index < 0) {
            return new ArrayList();
        }
        ArrayList<V> all = new ArrayList<V>();
        all.add(ln.valueAt(index));
        for (int i = index + 1; i < ln.size() && Objects.equals(key, u = ln.keyAt(i)); ++i) {
            all.add(ln.valueAt(i));
        }
        return all;
    }

    @Override
    public V get(K key) {
        if (this.isEmpty()) {
            return null;
        }
        LeafNode<K, V> ln = this.findLeafNode(key);
        int index = this.store.indexOfKey(ln, key);
        if (index < 0) {
            return null;
        }
        return ln.valueAt(index);
    }

    public NOptional<V> getOptional(K key) {
        if (this.isEmpty()) {
            return NOptional.ofNamedEmpty("key " + key);
        }
        LeafNode<K, V> ln = this.findLeafNode(key);
        int index = this.store.indexOfKey(ln, key);
        if (index < 0) {
            return NOptional.ofNamedEmpty("key " + key);
        }
        return NOptional.ofNullable(ln.valueAt(index));
    }

    public List<V> search(K lowerBound, K upperBound) {
        ArrayList<V> values = new ArrayList<V>();
        for (LeafNode<K, V> currNode = this.store.firstLeaf(); currNode != null; currNode = currNode.rightSibling()) {
            K dp;
            int max = currNode.size();
            for (int i = 0; i < max && (dp = currNode.keyAt(i)) != null; ++i) {
                if (NBPlusTreeHelper.compareKey(lowerBound, dp) > 0 || NBPlusTreeHelper.compareKey(dp, upperBound) > 0) continue;
                values.add(currNode.valueAt(i));
            }
        }
        return values;
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(final PrintStream out) {
        this.visit(new Visitor<K, V>(){

            @Override
            public void visitLeaf(LeafNode<K, V> node, int level) {
                out.print(this.lvlStr(level));
                out.println(node);
            }

            @Override
            public void visitIntermediate(IntermediateNode<K, V> node, int level) {
                out.print(this.lvlStr(level));
                out.println(node);
            }

            private String lvlStr(int level) {
                char[] cc = new char[level * 2];
                Arrays.fill(cc, ' ');
                return new String(cc);
            }
        });
    }

    public void visit(Visitor<K, V> visitor) {
        class NodeAndLevel {
            Node<K, V> node;
            int level;

            public NodeAndLevel(Node<K, V> node, int level) {
                this.node = node;
                this.level = level;
            }
        }
        Stack<NodeAndLevel> stack = new Stack<NodeAndLevel>();
        IntermediateNode<K, V> root = this.store.root();
        if (root != null) {
            stack.push(new NodeAndLevel(root, 0));
        } else {
            LeafNode<K, V> kvLeafNode = this.store.firstLeaf();
            if (kvLeafNode != null) {
                stack.push(new NodeAndLevel(kvLeafNode, 0));
            }
        }
        while (!stack.isEmpty()) {
            NodeAndLevel n = (NodeAndLevel)stack.pop();
            if (n.node == null) {
                visitor.visitLeaf(null, n.level);
                continue;
            }
            if (n.node.isLeaf()) {
                visitor.visitLeaf((LeafNode)n.node, n.level);
                continue;
            }
            IntermediateNode nn = (IntermediateNode)n.node;
            visitor.visitIntermediate(nn, n.level);
            int count = nn.size();
            for (int i = count - 1; i >= 0; --i) {
                stack.push(new NodeAndLevel(nn.child(i), n.level + 1));
            }
        }
    }

    public static interface IntermediateNode<K extends Comparable<K>, V>
    extends Node<K, V> {
        public Node<K, V> child(int var1);

        public K key(int var1);

        public IntermediateNode<K, V> leftSibling();

        public IntermediateNode<K, V> rightSibling();
    }

    public static interface LeafNode<K extends Comparable<K>, V>
    extends Node<K, V> {
        public List<K> keys();

        public V valueAt(int var1);

        public K keyAt(int var1);

        public Map.Entry<K, V> entryAt(int var1);

        public LeafNode<K, V> leftSibling();

        public LeafNode<K, V> rightSibling();
    }

    public static interface Node<K extends Comparable<K>, V> {
        public IntermediateNode<K, V> parent();

        public boolean isLeaf();

        public int size();

        public int minSize();

        public int maxSize();

        public K firstKey();
    }

    public static interface Visitor<K extends Comparable<K>, V> {
        public void visitLeaf(LeafNode<K, V> var1, int var2);

        public void visitIntermediate(IntermediateNode<K, V> var1, int var2);
    }
}

