/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;

public class NAssert {
    private NAssert() {
    }

    private static NMsg createMessage(Supplier<NMsg> msg) {
        NAssert.requireNonNull(msg, "message supplier");
        NMsg m = msg.get();
        NAssert.requireNonNull(m, "message");
        return m;
    }

    private static String createName(String name) {
        return NBlankable.isBlank(name) ? "value" : name;
    }

    public static <T> T requireNonNull(T object, Supplier<NMsg> msg) {
        if (object == null) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return object;
    }

    public static <T> T requireNonNull(T object, String name) {
        return NAssert.requireNonNull(object, () -> NMsg.ofC("%s should not be null", NAssert.createName(name)));
    }

    public static <T> T requireNonNull(T object) {
        return NAssert.requireNonNull(object, "value");
    }

    public static void requireNull(Object object, String name) {
        if (object != null) {
            throw NExceptions.ofSafeAssertException(NMsg.ofC("%s must be null", NAssert.createName(name)));
        }
    }

    public static void requireNull(Object object, Supplier<NMsg> message) {
        if (object != null) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(message));
        }
    }

    public static <T> T requireNonBlank(T object, String name) {
        if (NBlankable.isBlank(object)) {
            throw NExceptions.ofSafeAssertException(NMsg.ofC("%s should not be blank", NAssert.createName(name)));
        }
        return object;
    }

    public static <T> T requireNonBlank(T object, Supplier<NMsg> msg) {
        if (NBlankable.isBlank(object)) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return object;
    }

    public static void requireNull(Object object) {
        NAssert.requireNull(object, (String)null);
    }

    public static boolean requireTrue(boolean value, String name) {
        return NAssert.requireTrue(value, () -> NMsg.ofC("should be %s", NAssert.createName(name)));
    }

    public static boolean requireTrue(boolean object, Supplier<NMsg> msg) {
        if (!object) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return object;
    }

    public static <T> T requireEquals(T a, T b, Supplier<NMsg> msg) {
        if (!Objects.equals(a, b)) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return a;
    }

    public static <T> T requireNotEquals(T a, T b, String name) {
        return NAssert.requireNotEquals(a, b, () -> NMsg.ofC("%s non equality failed", NAssert.createName(name)));
    }

    public static <T> T requireNotEquals(T a, T b, Supplier<NMsg> msg) {
        if (Objects.equals(a, b)) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return a;
    }

    public static <T> T requireEquals(T a, T b, String name) {
        return NAssert.requireEquals(a, b, () -> NMsg.ofC("%s equality failed", NAssert.createName(name)));
    }

    public static boolean requireFalse(boolean value, String name) {
        return NAssert.requireFalse(value, () -> NMsg.ofC("should not be %s", NAssert.createName(name)));
    }

    public static boolean requireFalse(boolean value, Supplier<NMsg> msg) {
        if (value) {
            throw NExceptions.ofSafeAssertException(NAssert.createMessage(msg));
        }
        return value;
    }

    public static boolean requireNonEmpty(Collection<?> value, String name) {
        return NAssert.requireTrue(!value.isEmpty(), () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(Collection<?> value, String name) {
        return NAssert.requireTrue(value.isEmpty(), () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value == null ? "null" : Integer.valueOf(value.size())));
    }

    public static boolean requireNonEmpty(CharSequence value, String name) {
        return NAssert.requireTrue(value.length() != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(CharSequence value, String name) {
        return NAssert.requireTrue(value.length() == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value));
    }

    public static boolean requireNonEmpty(Object[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(Object[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(boolean[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(boolean[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(byte[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(byte[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(short[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(short[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(char[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(char[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(int[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(int[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(long[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(long[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(float[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(float[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }

    public static boolean requireNonEmpty(double[] value, String name) {
        return NAssert.requireTrue(value.length != 0, () -> NMsg.ofC("should not be empty %s", NAssert.createName(name)));
    }

    public static boolean requireEmpty(double[] value, String name) {
        return NAssert.requireTrue(value.length == 0, () -> NMsg.ofC("should be empty %s, was %s", NAssert.createName(name), value.length));
    }
}

