/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.util;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NReaderProvider;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNLiteral
implements NLiteral {
    private static NLiteral NULL = new DefaultNLiteral(null);
    public static final DateTimeFormatter[] DATE_TIME_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX"), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss")};
    public static final DateTimeFormatter[] TIME_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("HH:mm:ss.SSSX"), DateTimeFormatter.ofPattern("HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("HH:mm:ss"), DateTimeFormatter.ofPattern("HH:mm")};
    public static final DateTimeFormatter[] DATE_FORMATS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("yyyy/MM/dd")};
    private Object value;
    private NElementType type;

    public static NLiteral of(Object any) {
        if (any == null) {
            return NULL;
        }
        if (any instanceof NLiteral) {
            return (NLiteral)any;
        }
        return new DefaultNLiteral(any);
    }

    public static NOptional<Instant> parseInstant(String text) {
        for (DateTimeFormatter f : DATE_TIME_FORMATS) {
            try {
                Instant instant;
                TemporalAccessor ta = f.parse(text);
                if (ta.isSupported(ChronoField.INSTANT_SECONDS)) {
                    instant = Instant.from(ta);
                } else if (ta.isSupported(ChronoField.OFFSET_SECONDS)) {
                    instant = OffsetDateTime.from(ta).toInstant();
                } else if (ta.isSupported(ChronoField.HOUR_OF_DAY)) {
                    LocalDateTime ldt = LocalDateTime.from(ta);
                    instant = ldt.toInstant(ZoneOffset.UTC);
                } else {
                    if (!ta.isSupported(ChronoField.DAY_OF_MONTH)) continue;
                    LocalDate ld = LocalDate.from(ta);
                    instant = ld.atStartOfDay(ZoneOffset.UTC).toInstant();
                }
                return NOptional.of(instant);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid Instant %s", text));
    }

    public DefaultNLiteral(Object value) {
        this.value = value;
    }

    private static NElementType resolveType(Object value) {
        if (value == null) {
            return NElementType.NULL;
        }
        switch (value.getClass().getName()) {
            case "java.lang.Byte": {
                return NElementType.BYTE;
            }
            case "java.lang.Short": {
                return NElementType.SHORT;
            }
            case "java.lang.Integer": {
                return NElementType.INT;
            }
            case "java.lang.Long": {
                return NElementType.LONG;
            }
            case "java.math.BigInteger": {
                return NElementType.BIG_INT;
            }
            case "java.lang.Float": {
                return NElementType.FLOAT;
            }
            case "java.lang.Double": {
                return NElementType.DOUBLE;
            }
            case "java.math.BigDecimal": {
                return NElementType.BIG_DECIMAL;
            }
            case "java.lang.String": 
            case "java.lang.StringBuilder": 
            case "java.lang.StringBuffer": {
                return NElementType.DOUBLE_QUOTED_STRING;
            }
            case "java.util.Date": 
            case "java.time.Instant": {
                return NElementType.INSTANT;
            }
            case "java.time.LocalDateTime": {
                return NElementType.LOCAL_DATETIME;
            }
            case "java.time.LocalDate": {
                return NElementType.LOCAL_DATE;
            }
            case "java.time.LocalTime": {
                return NElementType.LOCAL_TIME;
            }
            case "java.lang.Boolean": {
                return NElementType.BOOLEAN;
            }
            case "net.thevpc.nuts.math.NDoubleComplex": {
                return NElementType.DOUBLE_COMPLEX;
            }
            case "net.thevpc.nuts.math.NFloatComplex": {
                return NElementType.FLOAT_COMPLEX;
            }
            case "net.thevpc.nuts.math.NBigComplex": {
                return NElementType.BIG_COMPLEX;
            }
            case "net.thevpc.nuts.elem.NName": {
                return NElementType.NAME;
            }
            case "net.thevpc.nuts.elem.NAliasName": {
                return NElementType.ALIAS;
            }
        }
        if (value instanceof Number) {
            return NElementType.DOUBLE;
        }
        if (value instanceof NInputStreamProvider) {
            return NElementType.BINARY_STREAM;
        }
        if (value instanceof NReaderProvider) {
            return NElementType.CHAR_STREAM;
        }
        if (value instanceof CharSequence) {
            return NElementType.DOUBLE_QUOTED_STRING;
        }
        return NElementType.OBJECT;
    }

    public NElementType type() {
        if (this.type == null) {
            this.type = DefaultNLiteral.resolveType(this.value);
        }
        return this.type;
    }

    @Override
    public NOptional<NFloatComplex> asFloatComplex() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty FloatComplex"));
        }
        if (this.value instanceof NDoubleComplex) {
            return NOptional.of(new NFloatComplex((float)((NDoubleComplex)this.value).real(), (float)((NDoubleComplex)this.value).imag()));
        }
        if (this.value instanceof NFloatComplex) {
            return NOptional.of((NFloatComplex)this.value);
        }
        if (this.value instanceof NBigComplex) {
            return NOptional.of(new NFloatComplex(((NBigComplex)this.value).real().floatValue(), ((NBigComplex)this.value).imag().floatValue()));
        }
        return this.asFloat().map(x -> new NFloatComplex(((Float)this.value).floatValue(), 0.0f));
    }

    @Override
    public NOptional<NDoubleComplex> asDoubleComplex() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty DoubleComplex"));
        }
        if (this.value instanceof NDoubleComplex) {
            return NOptional.of((NDoubleComplex)this.value);
        }
        if (this.value instanceof NFloatComplex) {
            return NOptional.of(new NDoubleComplex(((NFloatComplex)this.value).real(), ((NFloatComplex)this.value).imag()));
        }
        if (this.value instanceof NBigComplex) {
            return NOptional.of(new NDoubleComplex(((NBigComplex)this.value).real().doubleValue(), ((NBigComplex)this.value).imag().doubleValue()));
        }
        return this.asDouble().map(x -> new NDoubleComplex((Double)this.value, 0.0));
    }

    @Override
    public NOptional<NBigComplex> asBigComplex() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty DoubleComplex"));
        }
        if (this.value instanceof NDoubleComplex) {
            return NOptional.of(new NBigComplex(BigDecimal.valueOf(((NDoubleComplex)this.value).real()), BigDecimal.valueOf(((NDoubleComplex)this.value).real())));
        }
        if (this.value instanceof NFloatComplex) {
            return NOptional.of(new NBigComplex(BigDecimal.valueOf(((NFloatComplex)this.value).real()), BigDecimal.valueOf(((NFloatComplex)this.value).real())));
        }
        if (this.value instanceof NBigComplex) {
            return NOptional.of((NBigComplex)this.value);
        }
        return this.asBigDecimal().map(x -> new NBigComplex(BigDecimal.valueOf(x.doubleValue()), BigDecimal.ZERO));
    }

    @Override
    public NOptional<LocalTime> asLocalTime() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty instant"));
        }
        if (this.value instanceof LocalDateTime) {
            return NOptional.of(((LocalDateTime)this.value).toLocalTime());
        }
        if (this.value instanceof LocalDate) {
            return NOptional.of(LocalTime.MIN);
        }
        if (this.value instanceof LocalTime) {
            return NOptional.of((LocalTime)this.value);
        }
        return this.asInstant().map(x -> x.atZone(ZoneId.systemDefault()).toLocalTime());
    }

    @Override
    public NOptional<LocalDateTime> asLocalDateTime() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty instant"));
        }
        if (this.value instanceof LocalDateTime) {
            return NOptional.of((LocalDateTime)this.value);
        }
        if (this.value instanceof LocalDate) {
            return NOptional.of(((LocalDate)this.value).atStartOfDay());
        }
        if (this.value instanceof LocalTime) {
            return NOptional.of(LocalDateTime.of(LocalDate.now(), (LocalTime)this.value));
        }
        return this.asInstant().map(x -> x.atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    @Override
    public NOptional<LocalDate> asLocalDate() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty instant"));
        }
        if (this.value instanceof LocalDateTime) {
            return NOptional.of(((LocalDateTime)this.value).toLocalDate());
        }
        if (this.value instanceof LocalDate) {
            return NOptional.of((LocalDate)this.value);
        }
        if (this.value instanceof LocalTime) {
            return NOptional.of(LocalDate.now());
        }
        return this.asInstant().map(x -> x.atZone(ZoneId.systemDefault()).toLocalDate());
    }

    @Override
    public NOptional<Instant> asInstant() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty instant"));
        }
        if (this.value instanceof Boolean) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("cannot convert boolean to Instant"));
        }
        if (this.value instanceof Date) {
            return NOptional.of(((Date)this.value).toInstant());
        }
        if (this.value instanceof Instant) {
            return NOptional.of((Instant)this.value);
        }
        if (this.value instanceof LocalDateTime) {
            return NOptional.of(((LocalDateTime)this.value).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (this.value instanceof LocalDate) {
            return NOptional.of(((LocalDate)this.value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        if (this.value instanceof LocalTime) {
            return NOptional.of(LocalDateTime.of(LocalDate.now(), (LocalTime)this.value).atZone(ZoneId.systemDefault()).toInstant());
        }
        String s = String.valueOf(this.value).trim();
        if (s.isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty instant"));
        }
        try {
            return NOptional.of(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from));
        }
        catch (Exception exception) {
            Instant instant = DefaultNLiteral.parseInstant(s).orNull();
            if (instant != null) {
                return NOptional.of(instant);
            }
            try {
                String sd = s.replace("/", "-");
                if (sd.matches("\\d{2}-\\d{2}-\\d{4}")) {
                    String y = sd.substring(6, 10);
                    String m = sd.substring(3, 5);
                    String d = sd.substring(0, 2);
                    return NOptional.of(Instant.parse(y + "-" + m + "-" + d + "T00:00:00Z"));
                }
                if (sd.matches("\\d{4}-\\d{2}-\\d{2}")) {
                    sd = sd + "T00:00:00Z";
                } else if (sd.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}")) {
                    sd = sd.replace(" ", "T") + "Z";
                } else if (sd.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}")) {
                    sd = sd.replace(" ", "T") + ":00:00Z";
                } else if (sd.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}")) {
                    sd = sd.replace(" ", "T") + ":00Z";
                } else if (sd.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}[hH]\\d{2}")) {
                    sd = sd.replace(" ", "T").replace("h", ":").replace("H", ":") + ":00Z";
                } else if (sd.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}[hH]")) {
                    sd = sd.replace(" ", "T").substring(0, sd.length() - 1) + ":00:00Z";
                }
                return NOptional.of(Instant.parse(sd));
            }
            catch (Exception exception2) {
                if (this.asLong().isPresent()) {
                    try {
                        return NOptional.of(Instant.ofEpochMilli(this.asLong().get()));
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (this.isNumber()) {
                    return NOptional.ofEmpty(() -> NMsg.ofPlain("cannot convert number to Instant"));
                }
                return NOptional.ofEmpty(() -> NMsg.ofC("cannot convert to Instant %s", this.value));
            }
        }
    }

    @Override
    public NOptional<Object> asObject() {
        return NOptional.of(this.value);
    }

    @Override
    public NOptional<Number> asNumber() {
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty number"));
        }
        if (this.value instanceof Boolean) {
            return NOptional.of((Boolean)this.value != false ? 1 : 0);
        }
        if (this.value instanceof Number) {
            return NOptional.of((Number)this.value);
        }
        if (this.value instanceof Date) {
            return NOptional.of(((Date)this.value).getTime());
        }
        if (this.value instanceof Instant) {
            return NOptional.of(((Instant)this.value).toEpochMilli());
        }
        String s = String.valueOf(this.value);
        if (this.isCouldBeNumber(s)) {
            if (s.indexOf(46) >= 0 || s.toLowerCase().indexOf(101) >= 0) {
                try {
                    return NOptional.of(Double.parseDouble(s));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return NOptional.of(new BigDecimal(s));
                    }
                    catch (NumberFormatException numberFormatException2) {
                    }
                }
            } else {
                try {
                    return NOptional.of(Integer.parseInt(s));
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return NOptional.of(Long.parseLong(s));
                    }
                    catch (NumberFormatException numberFormatException3) {
                        try {
                            return NOptional.of(new BigInteger(s));
                        }
                        catch (NumberFormatException numberFormatException4) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return NOptional.ofError(() -> NMsg.ofPlain("cannot convert to Number"));
    }

    @Override
    public NOptional<Boolean> asBoolean() {
        String svalue;
        if (this.value == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty boolean"));
        }
        if (this.value instanceof Boolean) {
            return NOptional.of((Boolean)this.value);
        }
        if (this.value instanceof Number) {
            if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long || this.value instanceof BigInteger) {
                return NOptional.of(((Number)this.value).longValue() != 0L);
            }
            if (this.value instanceof Float || this.value instanceof Double || this.value instanceof BigDecimal) {
                double d = ((Number)this.value).doubleValue();
                return NOptional.of(d != 0.0 && !Double.isNaN(d));
            }
        }
        if ((svalue = String.valueOf(this.value).trim().toLowerCase()).isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty boolean"));
        }
        if (svalue.matches("true|enable|enabled|yes|always|y|on|ok|t|o")) {
            return NOptional.of(true);
        }
        if (svalue.matches("false|disable|disabled|no|none|never|n|off|ko|f")) {
            return NOptional.of(false);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid boolean %s", svalue));
    }

    @Override
    public NOptional<Long> asLong() {
        String s;
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty Long"));
        }
        if (this.value instanceof Number) {
            long ln;
            if (this.value instanceof BigInteger && BigInteger.valueOf(ln = ((BigInteger)this.value).longValue()).equals(this.value)) {
                return NOptional.of(ln);
            }
            return NOptional.of(((Number)this.value).longValue());
        }
        if (this.value instanceof Date) {
            return NOptional.of(((Date)this.value).getTime());
        }
        if (this.value instanceof CharSequence && this.isCouldBeNumber(s = this.value.toString().trim())) {
            if (s.indexOf(46) >= 0 || s.toLowerCase().indexOf(101) >= 0) {
                try {
                    double a = Double.parseDouble(s);
                    if (a == (double)((long)a)) {
                        return NOptional.of((long)a);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return NOptional.ofError(() -> NMsg.ofC("invalid Long %s", this.value));
            }
            try {
                if (s.startsWith("0x")) {
                    return NOptional.of(Long.parseLong(s.substring(2), 16));
                }
                return NOptional.of(Long.parseLong(s));
            }
            catch (NumberFormatException numberFormatException) {
                return NOptional.ofError(() -> NMsg.ofC("invalid Long %s", this.value));
            }
        }
        if (this.value instanceof Boolean) {
            return NOptional.of((Boolean)this.value != false ? 1L : 0L);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid Long %s", this.value));
    }

    private boolean isCouldBeNumber(String s) {
        if (!(s = s.trim()).isEmpty()) {
            char c = s.charAt(0);
            if (c == '-' || c == '+') {
                if ((s = s.substring(1)).isEmpty()) {
                    return false;
                }
                c = s.charAt(0);
            }
            return c >= '0' && c <= '9' || c == '.';
        }
        return false;
    }

    @Override
    public NOptional<Double> asDouble() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty Double"));
        }
        if (this.value instanceof Double || this.value instanceof Float) {
            return NOptional.of(((Number)this.value).doubleValue());
        }
        if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
            return NOptional.of(((Number)this.value).doubleValue());
        }
        if (this.value instanceof BigDecimal) {
            try {
                BigDecimal bd = (BigDecimal)this.value;
                BigDecimal abs = bd.abs();
                if (abs.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) >= 0 && abs.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0) {
                    return NOptional.of(bd.doubleValue());
                }
            }
            catch (Exception bd) {
                // empty catch block
            }
            return NOptional.ofError(() -> NMsg.ofC("invalid Double %s", this.value));
        }
        if (this.value instanceof BigInteger) {
            try {
                BigInteger bi = (BigInteger)this.value;
                BigDecimal bd = new BigDecimal(bi);
                BigDecimal abs = bd.abs();
                if (abs.compareTo(BigDecimal.valueOf(Double.MIN_VALUE)) >= 0 && abs.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0) {
                    return NOptional.of(bd.doubleValue());
                }
            }
            catch (Exception bi) {
                // empty catch block
            }
            return NOptional.ofError(() -> NMsg.ofC("invalid Double %s", this.value));
        }
        if (this.value instanceof Date) {
            return NOptional.of(Double.valueOf(((Date)this.value).getTime()));
        }
        if (this.value instanceof CharSequence) {
            String s = this.value.toString();
            try {
                return NOptional.of(Double.parseDouble(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid Double %s", this.value));
    }

    @Override
    public NOptional<Float> asFloat() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty Float"));
        }
        if (this.value instanceof Float) {
            return NOptional.of(Float.valueOf(((Number)this.value).floatValue()));
        }
        if (this.value instanceof Double) {
            Double d = (Double)this.value;
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return NOptional.of(Float.valueOf(d.floatValue()));
            }
            double abs = Math.abs(d);
            if (abs >= (double)1.4E-45f && abs <= 3.4028234663852886E38) {
                return NOptional.of(Float.valueOf(d.floatValue()));
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
        }
        if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
            double d = ((Number)this.value).doubleValue();
            double abs = Math.abs(d);
            if (abs >= (double)1.4E-45f && abs <= 3.4028234663852886E38) {
                return NOptional.of(Float.valueOf((float)d));
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
        }
        if (this.value instanceof BigDecimal) {
            try {
                BigDecimal bd = (BigDecimal)this.value;
                BigDecimal abs = bd.abs();
                if (abs.compareTo(BigDecimal.valueOf(1.4E-45f)) >= 0 && abs.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) <= 0) {
                    return NOptional.of(Float.valueOf(bd.floatValue()));
                }
            }
            catch (Exception bd) {
                // empty catch block
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
        }
        if (this.value instanceof BigInteger) {
            try {
                BigInteger bi = (BigInteger)this.value;
                BigDecimal bd = new BigDecimal(bi);
                BigDecimal abs = bd.abs();
                if (abs.compareTo(BigDecimal.valueOf(1.4E-45f)) >= 0 && abs.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) <= 0) {
                    return NOptional.of(Float.valueOf(bd.floatValue()));
                }
            }
            catch (Exception bi) {
                // empty catch block
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
        }
        if (this.value instanceof CharSequence) {
            String s = this.value.toString();
            try {
                return NOptional.of(Float.valueOf(Float.parseFloat(s)));
            }
            catch (NumberFormatException numberFormatException) {
                return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("invalid Float %s", this.value));
    }

    @Override
    public NOptional<Byte> asByte() {
        return this.asLong().ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofPlain("empty Byte"))).ifErrorUse(() -> NOptional.ofError(() -> NMsg.ofC("invalid Byte : %s", this.asObject().orNull()))).flatMap(value -> {
            byte smallValue = value.byteValue();
            if (!Long.valueOf(smallValue).equals(value)) {
                return NOptional.ofError(() -> NMsg.ofC("invalid Byte : %s", this.asObject().orNull()));
            }
            return NOptional.of(smallValue);
        });
    }

    @Override
    public NOptional<Short> asShort() {
        return this.asLong().ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofPlain("empty Short"))).ifErrorUse(() -> NOptional.ofError(() -> NMsg.ofC("invalid Short : %s", this.asObject().orNull()))).flatMap(value -> {
            short smallValue = value.shortValue();
            if (!Long.valueOf(smallValue).equals(value)) {
                return NOptional.ofError(() -> NMsg.ofC("invalid Short : %s", this.asObject().orNull()));
            }
            return NOptional.of(smallValue);
        });
    }

    @Override
    public NOptional<Integer> asInt() {
        return this.asLong().ifEmptyUse(() -> NOptional.ofEmpty(() -> NMsg.ofPlain("empty Integer"))).ifErrorUse(() -> NOptional.ofError(() -> NMsg.ofC("invalid Integer : %s", this.asObject().orNull()))).flatMap(value -> {
            int smallValue = value.intValue();
            if (!Long.valueOf(smallValue).equals(value)) {
                return NOptional.ofError(() -> NMsg.ofC("invalid Integer : %s", this.asObject().orNull()));
            }
            return NOptional.of(smallValue);
        });
    }

    @Override
    public NOptional<String> asString() {
        if (this.value == null) {
            return NOptional.of(null);
        }
        return NOptional.of(this.value.toString());
    }

    @Override
    public boolean isBoolean() {
        return this.asBoolean().isPresent();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isByte() {
        return this.value instanceof Byte;
    }

    @Override
    public boolean isString() {
        return this.asString().isPresent();
    }

    @Override
    public boolean isInt() {
        return this.value instanceof Integer;
    }

    @Override
    public boolean isLong() {
        return this.value instanceof Long;
    }

    @Override
    public boolean isShort() {
        return this.value instanceof Short;
    }

    @Override
    public boolean isFloat() {
        return this.value instanceof Float;
    }

    @Override
    public boolean isDouble() {
        return this.value instanceof Double;
    }

    @Override
    public boolean isInstant() {
        return this.value instanceof Instant;
    }

    @Override
    public boolean isDecimalNumber() {
        return this.value instanceof BigDecimal || this.value instanceof Float || this.value instanceof Double;
    }

    @Override
    public boolean isBigNumber() {
        return this.value instanceof BigDecimal || this.value instanceof BigInteger;
    }

    @Override
    public boolean isBigDecimal() {
        return this.value instanceof BigDecimal;
    }

    @Override
    public boolean isBigInt() {
        return this.value instanceof BigInteger;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNLiteral other = (DefaultNLiteral)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return Objects.toString(this.asObject().orNull());
    }

    @Override
    public String toStringLiteral() {
        switch (this.type()) {
            case NULL: {
                return "null";
            }
            case CHAR: {
                return NStringUtils.formatStringLiteral(this.asString().get(), NElementType.SINGLE_QUOTED_STRING);
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return NStringUtils.formatStringLiteral(this.asString().get(), this.type());
            }
            case BOOLEAN: {
                return String.valueOf(this.asBoolean().get());
            }
            case BYTE: 
            case LONG: 
            case BIG_DECIMAL: 
            case BIG_INT: 
            case SHORT: 
            case INT: 
            case FLOAT: 
            case DOUBLE: {
                return String.valueOf(this.asNumber().get());
            }
            case INSTANT: 
            case LOCAL_TIME: 
            case LOCAL_DATE: 
            case LOCAL_DATETIME: {
                return NStringUtils.formatStringLiteral(this.asInstant().get().toString(), NElementType.DOUBLE_QUOTED_STRING);
            }
        }
        return this.asString().get();
    }

    @Override
    public boolean isEmpty() {
        switch (this.type()) {
            case NULL: {
                return true;
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return this.toString().isEmpty();
            }
        }
        return false;
    }

    @Override
    public NOptional<String> asStringAt(int index) {
        return this.asLiteralAt(index).asString();
    }

    @Override
    public NOptional<Long> asLongAt(int index) {
        return this.asLiteralAt(index).asLong();
    }

    @Override
    public NOptional<Integer> asIntAt(int index) {
        return this.asLiteralAt(index).asInt();
    }

    @Override
    public NOptional<Double> asDoubleAt(int index) {
        return this.asLiteralAt(index).asDouble();
    }

    @Override
    public boolean isNullAt(int index) {
        return this.asLiteralAt(index).isNull();
    }

    @Override
    public NLiteral asLiteralAt(int index) {
        return DefaultNLiteral.of(this.asObjectAt(index).orNull());
    }

    @Override
    public NOptional<Object> asObjectAt(int index) {
        if (this.value != null) {
            if (this.value instanceof Object[]) {
                Object[] e = (Object[])this.value;
                if (index >= 0 && index < e.length) {
                    return NOptional.ofNamed(e[index], "object at " + index);
                }
            }
            if (this.value.getClass().isArray()) {
                int len = Array.getLength(this.value);
                if (index >= 0 && index < len) {
                    return NOptional.ofNamed(Array.get(this.value, index), "object at " + index);
                }
            }
            if (this.value instanceof List) {
                List li = (List)this.value;
                int len = li.size();
                if (index >= 0 && index < len) {
                    return NOptional.ofNamed(li.get(index), "object at " + index);
                }
            }
            if (this.value instanceof NElement) {
                return ((NElement)this.value).asElementAt(index).map(x -> x.asLiteral().asObject().orNull());
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("invalid object at %s", index));
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.value);
    }

    @Override
    public NOptional<BigInteger> asBigInt() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty BigInteger"));
        }
        if (this.value instanceof BigInteger) {
            return NOptional.of((BigInteger)this.value);
        }
        if (this.value instanceof Long || this.value instanceof Integer || this.value instanceof Short || this.value instanceof Byte) {
            return NOptional.of(BigInteger.valueOf(((Number)this.value).longValue()));
        }
        if (this.value instanceof Date) {
            return NOptional.of(BigInteger.valueOf(((Date)this.value).getTime()));
        }
        if (this.value instanceof Boolean) {
            return NOptional.of(BigInteger.valueOf((Boolean)this.value != false ? 1L : 0L));
        }
        if (this.value instanceof CharSequence) {
            String s = this.value.toString();
            if (s.indexOf(46) >= 0 || s.toLowerCase().indexOf(101) >= 0) {
                try {
                    double a = Double.parseDouble(s);
                    if (a == (double)((long)a)) {
                        return NOptional.of(BigInteger.valueOf((long)a));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    return NOptional.of(new BigDecimal(s).toBigInteger());
                }
                catch (NumberFormatException numberFormatException) {
                    return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigInteger %s", this.value));
                }
            }
            try {
                if (s.startsWith("0x")) {
                    return NOptional.of(new BigInteger(s.substring(2), 16));
                }
                return NOptional.of(new BigInteger(s));
            }
            catch (NumberFormatException numberFormatException) {
                return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigInteger %s", this.value));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigInteger %s", this.value));
    }

    @Override
    public NOptional<BigDecimal> asBigDecimal() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty BigDecimal"));
        }
        if (this.value instanceof BigDecimal) {
            return NOptional.of((BigDecimal)this.value);
        }
        if (this.value instanceof BigInteger) {
            return NOptional.of(new BigDecimal((BigInteger)this.value));
        }
        if (this.value instanceof Double || this.value instanceof Float) {
            return NOptional.of(BigDecimal.valueOf(((Number)this.value).doubleValue()));
        }
        if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
            return NOptional.of(BigDecimal.valueOf(((Number)this.value).longValue()));
        }
        if (this.value instanceof Date) {
            return NOptional.of(BigDecimal.valueOf(((Date)this.value).getTime()));
        }
        if (this.value instanceof CharSequence) {
            String s = this.value.toString();
            if (s.indexOf(46) >= 0 || s.toLowerCase().indexOf(101) >= 0) {
                try {
                    return NOptional.of(new BigDecimal(s));
                }
                catch (NumberFormatException numberFormatException) {
                    return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigDecimal %s", this.value));
                }
            }
            try {
                return NOptional.of(new BigDecimal(new BigInteger(s)));
            }
            catch (NumberFormatException numberFormatException) {
                return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigDecimal %s", this.value));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("invalid BigDecimal %s", this.value));
    }

    @Override
    public boolean isNumber() {
        NElementType t = this.type();
        switch (t) {
            case BYTE: 
            case LONG: 
            case BIG_DECIMAL: 
            case BIG_INT: 
            case SHORT: 
            case INT: 
            case FLOAT: 
            case DOUBLE: 
            case BIG_COMPLEX: 
            case DOUBLE_COMPLEX: 
            case FLOAT_COMPLEX: {
                return true;
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                String s = this.asString().get();
                s = s.trim();
                try {
                    new BigDecimal(s);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public NOptional<Character> asChar() {
        if (this.isBlank()) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("empty Character"));
        }
        if (this.value instanceof Character) {
            return NOptional.of((Character)this.value);
        }
        if (this.value instanceof Number) {
            return NOptional.of(Character.valueOf((char)((Number)this.value).intValue()));
        }
        if (this.value instanceof CharSequence) {
            CharSequence e = (CharSequence)this.value;
            if (e.length() == 1) {
                return NOptional.of(Character.valueOf(e.charAt(0)));
            }
            if (e.length() == 0) {
                return NOptional.ofEmpty(() -> NMsg.ofPlain("empty Character"));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("invalid character %s", this.value));
    }

    @Override
    public boolean isSupportedType(Class<?> type) {
        if (type == null) {
            return false;
        }
        switch (type.getName()) {
            case "java.lang.String": 
            case "java.lang.Boolean": 
            case "boolean": 
            case "java.lang.Byte": 
            case "byte": 
            case "java.lang.Short": 
            case "short": 
            case "java.lang.Character": 
            case "char": 
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": 
            case "java.lang.Float": 
            case "float": 
            case "java.lang.Double": 
            case "double": 
            case "java.time.Instant": 
            case "java.lang.Number": {
                return true;
            }
        }
        return false;
    }

    @Override
    public <ET> NOptional<ET> asType(Type expectedType) {
        if (expectedType instanceof Class) {
            return this.asType((Class)expectedType);
        }
        if (expectedType instanceof ParameterizedType) {
            return this.asType(((ParameterizedType)expectedType).getRawType());
        }
        return NOptional.ofError(() -> NMsg.ofC("unsupported type %s", expectedType));
    }

    @Override
    public <ET> NOptional<ET> asType(Class<ET> type) {
        NAssert.requireNonNull(type, "type");
        switch (type.getName()) {
            case "java.lang.String": {
                return NOptional.of(this.value);
            }
            case "java.lang.Boolean": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asBoolean();
            }
            case "boolean": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asBoolean();
            }
            case "java.lang.Byte": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asByte();
            }
            case "byte": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asByte();
            }
            case "java.lang.Short": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asShort();
            }
            case "short": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asShort();
            }
            case "java.lang.Character": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asChar();
            }
            case "char": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asChar();
            }
            case "java.lang.Integer": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asInt();
            }
            case "int": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asInt();
            }
            case "java.lang.Long": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asLong();
            }
            case "long": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asLong();
            }
            case "java.lang.Float": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asFloat();
            }
            case "float": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asFloat();
            }
            case "java.lang.Double": {
                if (NBlankable.isBlank(this.value)) {
                    return null;
                }
                return this.asDouble();
            }
            case "double": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.of(DefaultNLiteral.getDefaultValue(type));
                }
                return this.asDouble();
            }
            case "java.time.Instant": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.ofEmpty();
                }
                return this.asInstant();
            }
            case "java.lang.Number": {
                if (NBlankable.isBlank(this.value)) {
                    return NOptional.ofEmpty();
                }
                return this.asNumber();
            }
        }
        if (type.isEnum()) {
            if (NBlankable.isBlank(this.value)) {
                return NOptional.ofEmpty();
            }
            if (this.asInt().isPresent()) {
                ET[] enumConstants = type.getEnumConstants();
                Integer ordinal = this.asInt().get();
                if (ordinal >= 0 && ordinal <= enumConstants.length) {
                    return NOptional.of(enumConstants[ordinal]);
                }
                NOptional.ofError(() -> NMsg.ofC("invalid ordinal %s for %s", ordinal, type));
            }
            if (NEnum.class.isAssignableFrom(type)) {
                try {
                    return NOptional.of((NEnum)NEnum.parse(type, String.valueOf(this.value).trim()).get());
                }
                catch (RuntimeException ex) {
                    NOptional.ofError(() -> NMsg.ofC("unable to parse %s as %s", String.valueOf(this.value).trim(), type));
                }
            }
            try {
                return NOptional.of(Enum.valueOf(type, String.valueOf(this.value).trim()));
            }
            catch (RuntimeException ex) {
                NOptional.ofError(() -> NMsg.ofC("unable to parse %s as %s", String.valueOf(this.value).trim(), type));
            }
        }
        return NOptional.ofError(() -> NMsg.ofC("unsupported type %s", type));
    }

    private static Object getDefaultValue(Class<?> anyType) {
        NAssert.requireNonNull(anyType, "type");
        switch (anyType.getName()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "void": {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isStream() {
        return this.value instanceof NInputStreamProvider || this.value instanceof NReaderProvider;
    }

    @Override
    public boolean isComplexNumber() {
        return this.value instanceof NDoubleComplex || this.value instanceof NFloatComplex || this.value instanceof NBigComplex;
    }

    @Override
    public boolean isTemporal() {
        return this.value instanceof Instant || this.value instanceof LocalTime || this.value instanceof LocalDate || this.value instanceof LocalDateTime;
    }

    @Override
    public boolean isLocalTemporal() {
        return this.value instanceof LocalTime || this.value instanceof LocalDate || this.value instanceof LocalDateTime;
    }

    @Override
    public boolean isOrdinalNumber() {
        return this.type().isAnyOrdinalNumber();
    }

    @Override
    public boolean isFloatingNumber() {
        return this.type().isAnyFloatingNumber();
    }
}

