/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.time;

import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.elem.NMapBy;
import net.thevpc.nuts.time.NDuration;

public class NClock {
    private final long timeMillis;
    private final long nanos;

    public static NClock now() {
        return new NClock(System.currentTimeMillis(), System.nanoTime());
    }

    @NMapBy
    public NClock(@NMapBy(name="timeMillis") long timeMillis, @NMapBy(name="nanos") long nanos) {
        this.timeMillis = timeMillis;
        this.nanos = nanos;
    }

    public NDuration minus(NClock o) {
        return NDuration.ofNanos(this.nanos - o.nanos);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.timeMillis);
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public long getTimeNanos() {
        return this.nanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NClock nClock = (NClock)o;
        return this.timeMillis == nClock.timeMillis && this.nanos == nClock.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.timeMillis, this.nanos);
    }

    public String toString() {
        return "NutsClock{timeMillis=" + this.timeMillis + ", timeNanos=" + this.nanos + '}';
    }
}

