/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.time;

import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import net.thevpc.nuts.elem.NMapBy;
import net.thevpc.nuts.time.NClock;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.time.NDurationFormatMode;

public class NChronometer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long accumulatedNanos;
    private NClock startClock;
    private NClock endClock;
    private String name;
    private long lastNanos;
    private boolean running;
    private ChronoUnit smallestUnit;
    private ChronoUnit largestUnit;

    public static NChronometer startNow() {
        return NChronometer.startNow(null, null);
    }

    public static NChronometer startNow(String name) {
        return NChronometer.startNow(name, null);
    }

    public static NChronometer startNow(ChronoUnit smallestUnit) {
        return NChronometer.startNow(null, smallestUnit);
    }

    public static NChronometer startNow(String name, ChronoUnit smallestUnit) {
        return new NChronometer(name, smallestUnit).start();
    }

    public NChronometer() {
    }

    public NChronometer copy() {
        return new NChronometer(this.name, this.startClock, this.endClock, this.accumulatedNanos, this.lastNanos, this.running, this.smallestUnit, this.largestUnit);
    }

    @NMapBy
    public NChronometer(@NMapBy(name="name") String name, @NMapBy(name="startClock") NClock startClock, @NMapBy(name="endClock") NClock endClock, @NMapBy(name="accumulatedNanos") long accumulatedNanos, @NMapBy(name="lastNanos") long lastNanos, @NMapBy(name="running") boolean running, @NMapBy(name="smallestUnit") ChronoUnit smallestUnit, @NMapBy(name="largestUnit") ChronoUnit largestUnit) {
        this.accumulatedNanos = accumulatedNanos;
        this.startClock = startClock;
        this.endClock = endClock;
        this.name = name;
        this.lastNanos = lastNanos;
        this.running = running;
        this.smallestUnit = smallestUnit;
        this.largestUnit = largestUnit;
    }

    public NChronometer restart() {
        this.stop();
        NChronometer c = this.copy();
        this.start();
        return c;
    }

    public NChronometer restart(String newName) {
        this.stop();
        NChronometer c = this.copy();
        this.setName(newName);
        this.start();
        return c;
    }

    public NChronometer(String name) {
        this.name = name;
    }

    public NChronometer(String name, ChronoUnit smallestUnit) {
        this.name = name;
        this.smallestUnit = smallestUnit;
    }

    public NChronometer setName(String desc) {
        this.name = desc;
        return this;
    }

    public NChronometer updateDescription(String desc) {
        this.setName(desc);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return this.startClock != null;
    }

    public boolean isStopped() {
        return this.endClock != null;
    }

    public NChronometer reset() {
        this.endClock = null;
        this.startClock = null;
        this.lastNanos = 0L;
        this.accumulatedNanos = 0L;
        this.running = false;
        return this;
    }

    public NChronometer start() {
        this.endClock = null;
        this.startClock = NClock.now();
        this.lastNanos = this.startClock.getTimeNanos();
        this.accumulatedNanos = 0L;
        this.running = true;
        return this;
    }

    public NChronometer accumulate() {
        if (this.running) {
            long n = System.nanoTime();
            this.accumulatedNanos += n - this.lastNanos;
            this.lastNanos = n;
        }
        return this;
    }

    public NDuration lap() {
        if (this.running) {
            long n = System.nanoTime();
            long lapValue = n - this.lastNanos;
            this.accumulatedNanos += lapValue;
            this.lastNanos = n;
            return NDuration.ofNanos(lapValue);
        }
        return NDuration.ZERO;
    }

    public boolean isSuspended() {
        return !this.running;
    }

    public NChronometer suspend() {
        if (this.running) {
            long n = System.nanoTime();
            this.accumulatedNanos += n - this.lastNanos;
            this.lastNanos = -1L;
            this.running = false;
        }
        return this;
    }

    public NChronometer resume() {
        if (!this.running) {
            this.lastNanos = System.nanoTime();
            this.running = true;
        }
        return this;
    }

    public NChronometer stop() {
        if (this.running) {
            this.endClock = NClock.now();
            this.accumulatedNanos += this.endClock.getTimeNanos() - this.lastNanos;
            this.lastNanos = -1L;
            this.running = false;
        }
        return this;
    }

    public NClock getStartClock() {
        return this.startClock;
    }

    public NClock getEndClock() {
        return this.endClock;
    }

    public NDuration getDuration() {
        return NDuration.ofNanos(this.getDurationNanos(), this.getSmallestUnit(), this.getLargestUnit());
    }

    public long getDurationMs() {
        return this.getDurationNanos() / 1000000L;
    }

    public long getDurationNanos() {
        if (this.startClock == null) {
            return 0L;
        }
        if (this.running) {
            long curr = System.nanoTime() - this.lastNanos;
            return curr + this.accumulatedNanos;
        }
        return this.accumulatedNanos;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(NDurationFormatMode mode) {
        String s = this.name == null ? "" : this.name + "=";
        return s + this.getDuration().toString(mode);
    }

    public ChronoUnit getSmallestUnit() {
        return this.smallestUnit;
    }

    public NChronometer setSmallestUnit(ChronoUnit smallestUnit) {
        this.smallestUnit = smallestUnit;
        return this;
    }

    public ChronoUnit getLargestUnit() {
        return this.largestUnit;
    }

    public NChronometer setLargestUnit(ChronoUnit largestUnit) {
        this.largestUnit = largestUnit;
        return this;
    }
}

