/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.time;

import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressEventType;

public class DefaultNProgressEvent
implements NProgressEvent {
    private final Object source;
    private final NMsg message;
    private final long globalCount;
    private final NDuration globalDuration;
    private final long partialCount;
    private final NDuration partialDuration;
    private final long length;
    private final Throwable exception;
    private final NSession session;
    private final double progress;
    private final boolean indeterminate;
    private final NProgressEventType state;

    public DefaultNProgressEvent(Object source, NMsg message, long globalCount, long globalDurationNanos, Double progress, long partialCount, long partialDurationNanos, long length, Throwable exception, NSession session, Boolean indeterminate, NProgressEventType state) {
        this.source = source;
        this.length = length;
        this.message = message;
        this.globalCount = globalCount;
        this.globalDuration = NDuration.ofNanos(globalDurationNanos);
        this.partialCount = partialCount;
        this.partialDuration = NDuration.ofNanos(partialDurationNanos);
        this.exception = exception;
        this.session = session;
        this.state = state;
        if (progress == null) {
            progress = length > 0L ? Double.valueOf((double)globalCount * 1.0 / (double)length) : Double.valueOf(Double.NaN);
        }
        this.progress = progress;
        if (indeterminate == null) {
            indeterminate = Double.isNaN(progress);
        }
        this.indeterminate = indeterminate;
    }

    @Override
    public NProgressEventType getState() {
        return this.state;
    }

    @Override
    public NSession getSession() {
        return this.session;
    }

    @Override
    public Throwable getError() {
        return this.exception;
    }

    @Override
    public long getMaxValue() {
        return this.length;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public NMsg getMessage() {
        return this.message;
    }

    @Override
    public long getCurrentCount() {
        return this.globalCount;
    }

    @Override
    public NDuration getDuration() {
        return this.globalDuration;
    }

    @Override
    public NDuration getPartialDuration() {
        return this.partialDuration;
    }

    @Override
    public long getPartialCount() {
        return this.partialCount;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public boolean isIndeterminate() {
        return this.indeterminate;
    }
}

