/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NNormalizedText;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NStringFormat;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextAnchor;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCmd;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextFormat;
import net.thevpc.nuts.text.NTextFormatTheme;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextParser;
import net.thevpc.nuts.text.NTextPlain;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextVisitor;
import net.thevpc.nuts.text.NTitleSequence;
import net.thevpc.nuts.util.NOptional;

public interface NTexts
extends NComponent {
    public static NTexts of() {
        return NExtensions.of(NTexts.class);
    }

    public NTextBuilder ofBuilder();

    public NText ofBlank();

    public NText of(Object var1);

    public NText of(NMsg var1);

    public NTextPlain ofPlain(String var1);

    public NTextList ofList(NText ... var1);

    public NTextList ofList(Collection<NText> var1);

    public NText ofStyled(String var1, NTextStyles var2);

    public NText ofStyled(NMsg var1, NTextStyles var2);

    public NText ofStyled(NText var1, NTextStyles var2);

    public NText ofStyled(String var1, NTextStyle var2);

    public NText ofStyled(NMsg var1, NTextStyle var2);

    public NText ofStyled(NText var1, NTextStyle var2);

    public NTextTitle ofTitle(String var1, int var2);

    public NTextTitle ofTitle(NText var1, int var2);

    public NTextCmd ofCommand(NTerminalCmd var1);

    public NTextCode ofCode(String var1, String var2, String var3);

    public NTextCode ofCode(String var1, String var2);

    public NText ofCodeOrCommand(String var1, String var2);

    public NText ofCodeOrCommand(String var1);

    public NText ofCodeOrCommand(String var1, String var2, String var3);

    public NTitleSequence ofNumbering();

    public NTitleSequence ofNumbering(String var1);

    public NTextAnchor ofAnchor(String var1);

    public NTextLink ofLink(String var1, String var2);

    public NTextAnchor ofAnchor(String var1, String var2);

    public NTextLink ofLink(String var1);

    public NTextInclude ofInclude(String var1);

    public NTextInclude ofInclude(String var1, String var2);

    public NOptional<NTextFormatTheme> getTheme(String var1);

    public NTextFormatTheme getTheme();

    public NTexts setTheme(NTextFormatTheme var1);

    public NTexts setTheme(String var1);

    public NCodeHighlighter getCodeHighlighter(String var1);

    public NTexts addCodeHighlighter(NCodeHighlighter var1);

    public NTexts removeCodeHighlighter(String var1);

    public List<NCodeHighlighter> getCodeHighlighters();

    public NText of(String var1);

    public NTextParser parser();

    public void traverseDFS(NText var1, NTextVisitor var2);

    public void traverseBFS(NText var1, NTextVisitor var2);

    public NText transform(NText var1, NTextTransformConfig var2);

    public NText transform(NText var1, NTextTransformer var2, NTextTransformConfig var3);

    public NNormalizedText normalize(NText var1);

    public NNormalizedText normalize(NText var1, NTextTransformConfig var2);

    public NNormalizedText normalize(NText var1, NTextTransformer var2, NTextTransformConfig var3);

    public String escapeText(String var1);

    public String filterText(String var1);

    public NFormat createFormat(NFormatSPI var1);

    public <T> NFormat createFormat(T var1, NTextFormat<T> var2);

    public <T> NOptional<NTextFormat<T>> createTextFormat(String var1, String var2, Class<T> var3);

    public <T> NOptional<NStringFormat<T>> createStringFormat(String var1, String var2, Class<T> var3);

    public NOptional<NTextFormat<Number>> createNumberTextFormat(String var1, String var2);

    public NOptional<NStringFormat<Number>> createNumberStringFormat(String var1, String var2);

    public static NText[] trimLeft(NText[] value) {
        int st;
        if (value == null) {
            return new NText[0];
        }
        int len = value.length;
        if (len == 0) {
            return value;
        }
        for (st = 0; st < len && value[st].isWhitespace(); ++st) {
        }
        if (st > 0) {
            return Arrays.copyOfRange(value, st, len);
        }
        return value;
    }

    public static NText[] trimRight(NText[] value) {
        int st;
        if (value == null) {
            return new NPrimitiveText[0];
        }
        int len = value.length;
        if (len == 0) {
            return value;
        }
        for (st = len; st > 0 && value[st - 1].isWhitespace(); --st) {
        }
        if (st < len) {
            return Arrays.copyOfRange(value, 0, st);
        }
        return value;
    }

    public static NText[] trim(NText[] value) {
        int start;
        if (value == null || value.length == 0) {
            return new NPrimitiveText[0];
        }
        int end = value.length - 1;
        for (start = 0; start <= end && value[start].isWhitespace(); ++start) {
        }
        while (end >= start && value[end].isWhitespace()) {
            --end;
        }
        if (start == 0 && end == value.length - 1) {
            return value;
        }
        return Arrays.copyOfRange(value, start, end + 1);
    }

    public static NPrimitiveText[] trim(NPrimitiveText[] value) {
        int start;
        if (value == null || value.length == 0) {
            return new NPrimitiveText[0];
        }
        int end = value.length - 1;
        for (start = 0; start <= end && value[start].isWhitespace(); ++start) {
        }
        while (end >= start && value[end].isWhitespace()) {
            --end;
        }
        if (start == 0 && end == value.length - 1) {
            return value;
        }
        return Arrays.copyOfRange(value, start, end + 1);
    }

    public static NPrimitiveText[] trimLeft(NPrimitiveText[] value) {
        int st;
        if (value == null) {
            return new NPrimitiveText[0];
        }
        int len = value.length;
        if (len == 0) {
            return value;
        }
        for (st = 0; st < len && value[st].isWhitespace(); ++st) {
        }
        if (st > 0) {
            return Arrays.copyOfRange(value, st, len);
        }
        return value;
    }

    public static NPrimitiveText[] trimRight(NPrimitiveText[] value) {
        int st;
        if (value == null) {
            return new NPrimitiveText[0];
        }
        int len = value.length;
        if (len == 0) {
            return value;
        }
        for (st = len; st > 0 && value[st - 1].isWhitespace(); --st) {
        }
        if (st < len) {
            return Arrays.copyOfRange(value, 0, st);
        }
        return value;
    }
}

