/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Objects;
import java.util.function.Function;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.text.NTitleSequence;
import net.thevpc.nuts.util.NBlankable;

public class NTextTransformConfig
implements Cloneable,
NBlankable {
    private boolean filtered;
    private boolean flatten;
    private boolean normalize;
    private boolean applyTheme;
    private boolean basicTrueStyles;
    private boolean processTitleNumbers;
    private NTitleSequence titleNumberSequence;
    private boolean processIncludes;
    private NPath currentDir;
    private boolean processVars;
    private Function<String, String> varProvider;
    private String anchor;
    private Integer rootLevel;
    private String themeName;
    private ClassLoader importClassLoader;

    public String getThemeName() {
        return this.themeName;
    }

    public NTextTransformConfig setThemeName(String themeName) {
        this.themeName = themeName;
        return this;
    }

    public boolean isBasicTrueStyles() {
        return this.basicTrueStyles;
    }

    public NTextTransformConfig setBasicTrueStyles(boolean basicTrueStyles) {
        this.basicTrueStyles = basicTrueStyles;
        return this;
    }

    public boolean isApplyTheme() {
        return this.applyTheme;
    }

    public NTextTransformConfig setApplyTheme(boolean applyTheme) {
        this.applyTheme = applyTheme;
        return this;
    }

    public boolean isProcessTitleNumbers() {
        return this.processTitleNumbers;
    }

    public NTextTransformConfig setProcessTitleNumbers(boolean processTitleNumbers) {
        this.processTitleNumbers = processTitleNumbers;
        return this;
    }

    public NTitleSequence getTitleNumberSequence() {
        return this.titleNumberSequence;
    }

    public NTextTransformConfig setTitleNumberSequence(NTitleSequence titleNumberSequence) {
        this.titleNumberSequence = titleNumberSequence;
        return this;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public NTextTransformConfig setFiltered(boolean filtered) {
        this.filtered = filtered;
        return this;
    }

    public NTextTransformConfig copy() {
        return this.clone();
    }

    protected NTextTransformConfig clone() {
        try {
            return (NTextTransformConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isProcessIncludes() {
        return this.processIncludes;
    }

    public NTextTransformConfig setProcessIncludes(boolean processIncludes) {
        this.processIncludes = processIncludes;
        return this;
    }

    public Function<String, String> getVarProvider() {
        return this.varProvider;
    }

    public boolean isProcessVars() {
        return this.processVars;
    }

    public NTextTransformConfig setProcessVars(boolean processVars) {
        this.processVars = processVars;
        return this;
    }

    public NTextTransformConfig setVarProvider(Function<String, String> varProvider) {
        this.varProvider = varProvider;
        return this;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public NTextTransformConfig setAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public NTextTransformConfig setProcessAll(boolean enable) {
        this.setProcessTitleNumbers(enable);
        this.setProcessVars(enable);
        this.setProcessIncludes(enable);
        return this;
    }

    public Integer getRootLevel() {
        return this.rootLevel;
    }

    public NTextTransformConfig setRootLevel(Integer rootLevel) {
        this.rootLevel = rootLevel;
        return this;
    }

    @Override
    public boolean isBlank() {
        return !this.filtered && !this.flatten && !this.normalize && !this.processTitleNumbers && !this.processIncludes && !this.processVars && !this.applyTheme && this.titleNumberSequence == null && this.currentDir == null && this.varProvider == null && NBlankable.isBlank(this.anchor) && this.rootLevel == null && this.importClassLoader == null;
    }

    public NPath getCurrentDir() {
        return this.currentDir;
    }

    public NTextTransformConfig setCurrentDir(NPath currentDir) {
        this.currentDir = currentDir;
        return this;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public NTextTransformConfig setFlatten(boolean flatten) {
        this.flatten = flatten;
        return this;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public NTextTransformConfig setNormalize(boolean normalize) {
        this.normalize = normalize;
        return this;
    }

    public ClassLoader getImportClassLoader() {
        return this.importClassLoader;
    }

    public NTextTransformConfig setImportClassLoader(ClassLoader importClassLoader) {
        this.importClassLoader = importClassLoader;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTextTransformConfig that = (NTextTransformConfig)o;
        return this.filtered == that.filtered && this.flatten == that.flatten && this.normalize == that.normalize && this.applyTheme == that.applyTheme && this.basicTrueStyles == that.basicTrueStyles && this.processTitleNumbers == that.processTitleNumbers && this.processIncludes == that.processIncludes && this.processVars == that.processVars && Objects.equals(this.titleNumberSequence, that.titleNumberSequence) && Objects.equals(this.currentDir, that.currentDir) && Objects.equals(this.varProvider, that.varProvider) && Objects.equals(this.anchor, that.anchor) && Objects.equals(this.rootLevel, that.rootLevel) && Objects.equals(this.themeName, that.themeName) && Objects.equals(this.importClassLoader, that.importClassLoader);
    }

    public int hashCode() {
        return Objects.hash(this.filtered, this.flatten, this.normalize, this.applyTheme, this.basicTrueStyles, this.processTitleNumbers, this.titleNumberSequence, this.processIncludes, this.currentDir, this.processVars, this.varProvider, this.anchor, this.rootLevel, this.themeName, this.importClassLoader);
    }
}

