/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public final class NTextStyles
implements Iterable<NTextStyle>,
NEnum {
    public static NTextStyles PLAIN = new NTextStyles(new NTextStyle[0]);
    private final NTextStyle[] elements;

    private NTextStyles(NTextStyle[] elements) {
        this.elements = Arrays.copyOf(elements, elements.length);
    }

    public static NTextStyles of(NTextStyle ... others) {
        if (others == null || others.length == 0) {
            return PLAIN;
        }
        TreeMap<NTextStyleType, NTextStyle> visited = new TreeMap<NTextStyleType, NTextStyle>();
        for (NTextStyle element : others) {
            if (element == null) continue;
            visited.put(element.getType(), element);
        }
        visited.remove(NTextStyleType.PLAIN);
        if (visited.isEmpty()) {
            return PLAIN;
        }
        return new NTextStyles(visited.values().toArray(new NTextStyle[0]));
    }

    public static NTextStyles of(NTextStyle other) {
        if (other == null || other.getType() == NTextStyleType.PLAIN) {
            return PLAIN;
        }
        return new NTextStyles(new NTextStyle[]{other});
    }

    public static NOptional<NTextStyles> parse(String value) {
        if ((value = NStringUtils.trim(value)).isEmpty()) {
            return NOptional.ofEmpty(() -> NMsg.ofC("%s is empty", NTextStyles.class.getSimpleName()));
        }
        ArrayList<NTextStyle> all = new ArrayList<NTextStyle>();
        for (String s : NStringUtils.split(value, ",", true, true)) {
            if ((s = s.trim()).length() <= 0) continue;
            NTextStyle a = NTextStyle.parse(s).orNull();
            if (a == null) {
                String finalValue = value;
                return NOptional.ofError(() -> NMsg.ofC("%s invalid value : %s", NTextStyles.class.getSimpleName(), finalValue));
            }
            all.add(a);
        }
        return NOptional.of(NTextStyles.of(all.toArray(new NTextStyle[0])));
    }

    public NTextStyles append(NTextStyles other) {
        if (other == null || other.isPlain()) {
            return this;
        }
        if (this.isPlain()) {
            return other;
        }
        return this.append(other.elements);
    }

    public NTextStyles append(NTextStyle ... others) {
        if (others == null || others.length == 0) {
            return this;
        }
        ArrayList<NTextStyle> all = new ArrayList<NTextStyle>(this.size() + others.length + 1);
        all.addAll(Arrays.asList(this.elements));
        all.addAll(Arrays.asList(others));
        return NTextStyles.of(all.toArray(new NTextStyle[0]));
    }

    public NTextStyles append(NTextStyle other) {
        if (other == null || other.getType() == NTextStyleType.PLAIN) {
            return this;
        }
        NTextStyle[] elements2 = new NTextStyle[this.elements.length + 1];
        System.arraycopy(this.elements, 0, elements2, 0, this.elements.length);
        elements2[this.elements.length] = other;
        return NTextStyles.of(elements2);
    }

    public NTextStyles removeLast() {
        if (this.elements.length <= 0) {
            return this;
        }
        return NTextStyles.of(Arrays.copyOf(this.elements, this.elements.length - 1));
    }

    public NTextStyles removeFirst() {
        if (this.elements.length <= 0) {
            return this;
        }
        return NTextStyles.of(Arrays.copyOfRange(this.elements, 1, this.elements.length));
    }

    public NTextStyle get(int index) {
        return this.elements[index];
    }

    public int size() {
        return this.elements.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTextStyles that = (NTextStyles)o;
        return Arrays.equals(this.elements, that.elements);
    }

    public String toString() {
        return this.id();
    }

    public boolean isPlain() {
        return this.elements.length == 0;
    }

    @Override
    public Iterator<NTextStyle> iterator() {
        return Arrays.asList(this.elements).iterator();
    }

    public NTextStyle[] toArray() {
        return Arrays.copyOf(this.elements, this.elements.length);
    }

    public List<NTextStyle> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.elements));
    }

    @Override
    public String id() {
        if (this.elements.length == 0) {
            return "plain";
        }
        return Arrays.stream(this.elements).map(NTextStyle::id).collect(Collectors.joining(","));
    }
}

