/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.text;

import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NNormalizedText;
import net.thevpc.nuts.text.NPrimitiveText;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NTextAnchor;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextCmd;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.text.NTextInclude;
import net.thevpc.nuts.text.NTextLink;
import net.thevpc.nuts.text.NTextList;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.text.NTextTitle;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.text.NTextTransformer;
import net.thevpc.nuts.text.NTextType;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.text.NTitleSequence;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public interface NText
extends NBlankable {
    public static NText of(String str) {
        return NTexts.of().of(str);
    }

    public static NText ofPlain(String str) {
        return NTexts.of().ofPlain(str);
    }

    public static NText ofNewLine() {
        return NTexts.of().ofPlain("\n");
    }

    public static NText of(Object str) {
        return NTexts.of().of(str);
    }

    public static NText of(NMsg str) {
        return NTexts.of().of(str);
    }

    public static NText ofBlank() {
        return NTexts.of().ofBlank();
    }

    public static NTextList ofList(NText ... nodes) {
        return NTexts.of().ofList(nodes);
    }

    public static NTextList ofList(Collection<NText> nodes) {
        return NTexts.of().ofList(nodes);
    }

    public static NText ofStyled(String other, NTextStyles styles) {
        return NTexts.of().ofStyled(other, styles);
    }

    public static NText ofStyled(NMsg other, NTextStyles styles) {
        return NTexts.of().ofStyled(other, styles);
    }

    public static NText ofStyled(NText other, NTextStyles styles) {
        return NTexts.of().ofStyled(other, styles);
    }

    public static NText ofStyled(String plainText, NTextStyle style) {
        return NTexts.of().ofStyled(plainText, style);
    }

    public static NText ofStyledError(String other) {
        return NTexts.of().ofStyled(other, NTextStyle.error());
    }

    public static NText ofStyledPath(String plainPath) {
        return NTexts.of().ofStyled(plainPath, NTextStyle.path());
    }

    public static NText ofStyled(NMsg other, NTextStyle style) {
        return NTexts.of().ofStyled(other, style);
    }

    public static NText ofStyled(NText other, NTextStyle style) {
        return NTexts.of().ofStyled(other, style);
    }

    public static NTextTitle ofTitle(String other, int level) {
        return NTexts.of().ofTitle(other, level);
    }

    public static NTextTitle ofTitle(NText other, int level) {
        return NTexts.of().ofTitle(other, level);
    }

    public static NTextCmd ofCommand(NTerminalCmd command) {
        return NTexts.of().ofCommand(command);
    }

    public static NTextCode ofCode(String lang, String text, String sep) {
        return NTexts.of().ofCode(text, lang, sep);
    }

    public static NTextCode ofCode(String lang, String text) {
        return NTexts.of().ofCode(lang, text);
    }

    public static NText ofCodeOrCommand(String lang, String text) {
        return NTexts.of().ofCodeOrCommand(lang, text);
    }

    public static NText ofCodeOrCommand(String text) {
        return NTexts.of().ofCodeOrCommand(text);
    }

    public static NText ofCodeOrCommand(String lang, String text, String sep) {
        return NTexts.of().ofCodeOrCommand(lang, text, sep);
    }

    public static NTitleSequence ofNumbering() {
        return NTexts.of().ofNumbering();
    }

    public static NTitleSequence ofNumbering(String pattern) {
        return NTexts.of().ofNumbering(pattern);
    }

    public static NTextAnchor ofAnchor(String anchorName) {
        return NTexts.of().ofAnchor(anchorName);
    }

    public static NTextLink ofLink(String value, String sep) {
        return NTexts.of().ofLink(value, sep);
    }

    public static NTextAnchor ofAnchor(String anchorName, String sep) {
        return NTexts.of().ofAnchor(anchorName, sep);
    }

    public static NTextLink ofLink(String value) {
        return NTexts.of().ofLink(value);
    }

    public static NTextInclude ofInclude(String value) {
        return NTexts.of().ofInclude(value);
    }

    public static NTextInclude ofInclude(String value, String sep) {
        return NTexts.of().ofInclude(value, sep);
    }

    public static NText ofStyledSuccess(String value) {
        return NText.ofStyled(value, NTextStyle.success());
    }

    public static NText ofStyledWarn(String value) {
        return NText.ofStyled(value, NTextStyle.warn());
    }

    public static NText ofStyledPrimary1(String value) {
        return NText.ofStyled(value, NTextStyle.primary1());
    }

    public static NText ofStyledPrimary2(String value) {
        return NText.ofStyled(value, NTextStyle.primary2());
    }

    public static NText ofStyledPrimary3(String value) {
        return NText.ofStyled(value, NTextStyle.primary3());
    }

    public static NText ofStyledPrimary4(String value) {
        return NText.ofStyled(value, NTextStyle.primary4());
    }

    public static NText ofStyledPrimary5(String value) {
        return NText.ofStyled(value, NTextStyle.primary5());
    }

    public static NText ofStyledPrimary6(String value) {
        return NText.ofStyled(value, NTextStyle.primary6());
    }

    public static NText ofStyledPrimary7(String value) {
        return NText.ofStyled(value, NTextStyle.primary7());
    }

    public static NText ofStyledPrimary8(String value) {
        return NText.ofStyled(value, NTextStyle.primary8());
    }

    public static NText ofStyledPrimary9(String value) {
        return NText.ofStyled(value, NTextStyle.primary9());
    }

    public static NText ofSpace() {
        return NText.ofPlain(" ");
    }

    public static NText ofSpaces(int columns) {
        if (columns <= 0) {
            return NText.ofBlank();
        }
        return NText.ofPlain(NStringUtils.repeat(' ', columns));
    }

    public NTextType type();

    public NTextBuilder builder();

    public NText substring(int var1, int var2);

    public boolean isPrimitive();

    public boolean isNormalized();

    public NText immutable();

    public String filteredText();

    public String toString();

    public int length();

    public boolean isEmpty();

    public NText simplify();

    public List<NText> split(char var1);

    public List<NText> split(char var1, boolean var2);

    public List<NText> split(String var1);

    public List<NText> split(String var1, boolean var2);

    public NPrimitiveText[] toCharArray();

    public List<NPrimitiveText> toCharList();

    public NStream<NPrimitiveText> toCharStream();

    public NText trim();

    public NText trimLeft();

    public NText trimRight();

    public NText repeat(int var1);

    public NText repeatln(int var1);

    public NText concat(NText var1);

    public NText concat(NText ... var1);

    public boolean isString(String var1);

    public boolean isNewLine();

    public boolean isWhitespace();

    public NNormalizedText normalize();

    public NNormalizedText normalize(NTextTransformConfig var1);

    public NNormalizedText normalize(NTextTransformer var1, NTextTransformConfig var2);
}

