/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.net.NHttpCode;
import net.thevpc.nuts.net.NWebCookie;
import net.thevpc.nuts.net.NWebResponse;
import net.thevpc.nuts.net.NWebResponseException;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCookie;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebHeaders;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgCode;
import net.thevpc.nuts.util.NOptional;

public class NWebResponseImpl
implements NWebResponse {
    private NHttpCode httpCode;
    private NMsg msg;
    private DefaultNWebHeaders headers = new DefaultNWebHeaders();
    private NOnceValue<NInputSource> content;
    private NMsgCode msgCode;

    public NWebResponseImpl(NHttpCode code, NMsg msg, Map<String, List<String>> headers, Supplier<NInputSource> content) {
        this.httpCode = code;
        this.msg = msg;
        this.headers.addHeadersMulti(headers, DefaultNWebHeaders.Mode.ALWAYS);
        this.content = NOnceValue.ofSupplier(content);
    }

    @Override
    public NOptional<String> getHeader(String name) {
        return NOptional.ofNamedFirst(this.getHeaders(name), name);
    }

    @Override
    public int getIntCode() {
        return this.httpCode.getCode();
    }

    @Override
    public NHttpCode getCode() {
        return this.httpCode;
    }

    @Override
    public NMsg getMsg() {
        return this.msg;
    }

    @Override
    public List<String> getHeaders(String name) {
        List<String> u = this.headers.getOrEmpty(name);
        if (u == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(u);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers.toMap();
    }

    @Override
    public NInputSource getContent() {
        return this.content.get();
    }

    @Override
    public <K, V> Map<K, V> getContentMapAsJson() {
        return this.getContentAsJson(Map.class);
    }

    @Override
    public <K> List<K> getContentListAsJson() {
        return this.getContentAsJson(List.class);
    }

    @Override
    public <T> List<T> getContentArrayAsJson() {
        return this.getContentAsJson(List.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getContentAs(Class<T> clz, NContentType type) {
        if (this.content == null) {
            return null;
        }
        NInputSource content1 = this.getContent();
        if (content1 == null) {
            return null;
        }
        try (InputStream in = content1.getInputStream();){
            T t = NElementParser.ofJson().parse(in, clz);
            return t;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getContentAsJson(Class<T> clz) {
        if (this.content == null) {
            return null;
        }
        NInputSource content1 = this.getContent();
        if (content1 == null) {
            return null;
        }
        try (InputStream in = content1.getInputStream();){
            T t = NElementParser.ofJson().parse(in, clz);
            return t;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public Map<?, ?> getContentAsJsonMap() {
        return this.getContentAsJson(Map.class);
    }

    @Override
    public List<?> getContentAsJsonList() {
        return this.getContentAsJson(List.class);
    }

    @Override
    public String getContentAsString() {
        if (this.content == null) {
            return null;
        }
        NInputSource content1 = this.getContent();
        if (content1 == null) {
            return null;
        }
        return new String(content1.readBytes());
    }

    @Override
    public byte[] getContentAsBytes() {
        if (this.content == null) {
            return null;
        }
        NInputSource content1 = this.getContent();
        if (content1 == null) {
            return null;
        }
        return content1.readBytes();
    }

    @Override
    public NWebCookie[] getCookies() {
        return (NWebCookie[])this.getHeaders("Set-Cookie").stream().map(DefaultNWebCookie::new).toArray(NWebCookie[]::new);
    }

    @Override
    public boolean isError() {
        return this.httpCode.getCode() >= 400;
    }

    @Override
    public boolean isOk() {
        int ic = this.httpCode.getCode();
        return ic >= 200 && ic < 300;
    }

    @Override
    public NWebResponse failFast() {
        if (this.isError()) {
            throw new NWebResponseException(this.msg, this.msgCode, this.httpCode);
        }
        return this;
    }

    @Override
    public NMsgCode getMsgCode() {
        return this.msgCode;
    }

    @Override
    public NWebResponse setMsgCode(NMsgCode msgCode) {
        this.msgCode = msgCode;
        return this;
    }

    @Override
    public String getContentType() {
        if (this.headers != null) {
            List<String> list = this.headers.getOrEmpty("Content-Type");
            for (String s : list) {
                if (s == null || s.isEmpty()) continue;
                return s;
            }
        }
        return null;
    }
}

