/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.util.NMaps;

public class DefaultNWebHeaders {
    private Map<String, List<String>> headers = NMaps.ofCaseInsensitiveKeyMap();

    public void addHeaders(DefaultNWebHeaders others, Mode mode) {
        if (others != null) {
            this.addHeadersMulti(others.headers, mode);
        }
    }

    public void addHeaders(Map<String, String> others, Mode mode) {
        if (others != null) {
            for (Map.Entry<String, String> e : others.entrySet()) {
                this.addHeader(e.getKey(), e.getValue(), mode);
            }
        }
    }

    public void addHeadersMulti(Map<String, List<String>> others, Mode mode) {
        if (others != null) {
            block4: for (Map.Entry<String, List<String>> e : others.entrySet()) {
                List<String> eList = e.getValue();
                if (eList == null || eList.isEmpty()) continue;
                switch ((mode == null ? Mode.ALWAYS : mode).ordinal()) {
                    case 3: {
                        List<String> l = this.headers.get(e.getKey());
                        if (l != null && !l.isEmpty()) continue block4;
                        for (String h : eList) {
                            this.addHeader(e.getKey(), h, Mode.ALWAYS);
                        }
                        continue block4;
                    }
                    case 2: {
                        List<String> l = this.headers.get(e.getKey());
                        if (l != null) {
                            l.clear();
                        }
                        for (String h : eList) {
                            this.addHeader(e.getKey(), h, Mode.ALWAYS);
                        }
                        continue block4;
                    }
                    default: {
                        for (String h : eList) {
                            this.addHeader(e.getKey(), h, mode);
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public void removeHeader(String name, String value) {
        if (value == null) {
            return;
        }
        List<String> l = this.headers.get(name);
        if (l != null) {
            l.remove(value);
            if (l.isEmpty()) {
                this.headers.remove(name);
            }
        }
    }

    public void addHeader(String name, String value, Mode mode) {
        if (name == null) {
            return;
        }
        if (value == null) {
            return;
        }
        List<String> l = this.headers.get(name);
        if (l == null) {
            l = new ArrayList<String>();
            this.headers.put(name, l);
            l.add(value);
        } else {
            switch ((mode == null ? Mode.ALWAYS : mode).ordinal()) {
                case 0: {
                    l.add(value);
                    break;
                }
                case 2: {
                    l.clear();
                    l.add(value);
                    break;
                }
                case 3: {
                    if (!l.isEmpty()) break;
                    l.add(value);
                    break;
                }
                case 1: {
                    if (l.contains(value)) break;
                    l.add(value);
                }
            }
        }
    }

    public void addHeaderIfNotExists(String name, String value) {
        if (value == null) {
            return;
        }
        List<String> l = this.headers.get(name);
        if (l == null) {
            l = new ArrayList<String>();
            this.headers.put(name, l);
            l.add(value);
        } else if (!l.contains(value)) {
            l.add(value);
        }
    }

    public String getFirst(String name) {
        List<String> u = this.headers.get(name);
        if (u != null) {
            return u.get(0);
        }
        return null;
    }

    public List<String> getOrEmpty(String name) {
        List<String> u = this.headers.get(name);
        if (u == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(u);
    }

    public List<String> getOrNull(String name) {
        List<String> u = this.headers.get(name);
        if (u == null) {
            return null;
        }
        if (this.headers.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(u);
    }

    public Map<String, List<String>> toMap() {
        Map<String, List<String>> headers2 = NMaps.ofCaseInsensitiveKeyMap();
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            headers2.put(e.getKey(), new ArrayList(e.getValue()));
        }
        return headers2;
    }

    public void clear() {
        this.headers.clear();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public static enum Mode {
        ALWAYS,
        NO_DUPLICATES,
        REPLACE,
        IF_EMPTY;

    }
}

