/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.NCmdLineFormatStrategy;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NCmdLineShellOptions;
import net.thevpc.nuts.runtime.standalone.xtra.shell.AbstractNixNShellHelper;
import net.thevpc.nuts.runtime.standalone.xtra.shell.ReplaceString;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class ShNShellHelper
extends AbstractNixNShellHelper {
    public static final ShNShellHelper SH = new ShNShellHelper();
    public static final ReplaceString SHEBAN_SH = new ReplaceString("#!/bin/sh", "#!.*");

    @Override
    public String getSysRcName() {
        return ".profile";
    }

    @Override
    public String getPathVarSep() {
        return ":";
    }

    @Override
    public String getExportCommand(String[] names) {
        return "export " + String.join((CharSequence)" ", names);
    }

    @Override
    public String getCallScriptCommand(String path, String ... args) {
        return ". " + this.dblQte(path) + " " + Arrays.stream(args).map(a -> this.dblQte((String)a)).collect(Collectors.joining(" "));
    }

    @Override
    public String getSetVarCommand(String name, String value) {
        return name + "=" + this.dblQte(value);
    }

    public String smpQte(String line) {
        return "'" + line + "'";
    }

    @Override
    public String getSetVarStaticCommand(String name, String value) {
        return name + "=" + this.smpQte(value) + "";
    }

    @Override
    public ReplaceString getShebanSh() {
        return SHEBAN_SH;
    }

    public String dblQte(String line) {
        return "\"" + line + "\"";
    }

    @Override
    public boolean isComments(String line) {
        line = line.trim();
        return line.startsWith("#");
    }

    @Override
    public String toCommentLine(String line) {
        return "# " + line;
    }

    @Override
    public String varRef(String v) {
        return "${" + v + "}";
    }

    @Override
    public String trimComments(String line) {
        if ((line = line.trim()).startsWith("#")) {
            while (line.startsWith("#")) {
                line = line.substring(1);
            }
            return line.trim();
        }
        return "";
    }

    @Override
    public String[] parseCmdLineArr(String commandLineString, boolean lenient) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block31: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case '\n': 
                        case '\r': {
                            continue block31;
                        }
                        case '\'': {
                            status = 2;
                            continue block31;
                        }
                        case '\"': {
                            status = 3;
                            continue block31;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block31;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block31;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                        case '\'': {
                            if (lenient) {
                                args.add(sb.toString());
                                sb.delete(0, sb.length());
                                status = 2;
                                continue block31;
                            }
                            throw new NParseException(NMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\"': {
                            if (lenient) {
                                args.add(sb.toString());
                                sb.delete(0, sb.length());
                                status = 3;
                                continue block31;
                            }
                            throw new NParseException(NMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block31;
                        }
                    }
                    sb.append(c);
                    continue block31;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                    }
                    sb.append(c);
                    continue block31;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block31;
                        }
                        case '\\': {
                            i = this.readEscapedBash(charArray, i + 1, sb);
                            continue block31;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                if (lenient) break;
                throw new NParseException(NMsg.ofPlain("expected '"));
            }
        }
        return args.toArray(new String[0]);
    }

    public int readEscapedBash(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case ' ': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case ';': 
            case '<': 
            case '>': 
            case '\\': 
            case '|': 
            case '~': {
                sb.append(c);
                break;
            }
            default: {
                sb.append('\\').append(c);
            }
        }
        return i;
    }

    private boolean isVarOrOption(String arg) {
        return Pattern.compile("[-+]{0,3}(//)?[!~]?[a-zA-Z][a-zA-Z0-9_]*").matcher(arg).matches();
    }

    private boolean isEnv(String arg) {
        return Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*").matcher(arg).matches();
    }

    @Override
    public String escapeArguments(String[] args, NCmdLineShellOptions options) {
        options = options == null ? new NCmdLineShellOptions() : options.copy();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.escapeArgument(arg, options));
        }
        return sb.toString();
    }

    @Override
    public String escapeArgument(String arg, NCmdLineShellOptions options) {
        int ii;
        NCmdLineFormatStrategy s;
        if (arg == null || arg.isEmpty()) {
            return "\"\"";
        }
        if (options == null) {
            options = new NCmdLineShellOptions();
        }
        if ((s = options.getFormatStrategy()) == null || s == NCmdLineFormatStrategy.DEFAULT) {
            s = NCmdLineFormatStrategy.SUPPORT_QUOTES;
        }
        if ((ii = arg.indexOf(61)) >= 0) {
            String q = arg.substring(0, ii);
            if (options.isExpectEnv()) {
                if (this.isEnv(q)) {
                    return q + "=" + this.escapeArgument(arg.substring(ii + 1), options.copy().setExpectEnv(false).setExpectOption(false));
                }
                options.setExpectEnv(false);
            }
            if (options.isExpectOption() && this.isVarOrOption(q)) {
                return q + "=" + this.escapeArgument(arg.substring(ii + 1), options.copy().setExpectEnv(false).setExpectOption(false));
            }
        }
        switch (s) {
            case NO_QUOTES: {
                StringBuilder sb = new StringBuilder();
                block17: for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '|': 
                        case '~': {
                            sb.append("\\").append(c);
                            continue block17;
                        }
                        case '\n': 
                        case '\r': {
                            throw new NIllegalArgumentException(NMsg.ofPlain("unsupported new line in arguments"));
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            case SUPPORT_QUOTES: {
                StringBuilder sb = new StringBuilder();
                for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\t': 
                        case ' ': 
                        case '\"': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case ';': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '|': 
                        case '~': {
                            return this.escapeArgument(arg, options.copy().setFormatStrategy(NCmdLineFormatStrategy.REQUIRE_QUOTES));
                        }
                        case '\n': 
                        case '\r': {
                            throw new NIllegalArgumentException(NMsg.ofPlain("unsupported new line in arguments"));
                        }
                    }
                    sb.append(c);
                }
                return sb.toString();
            }
            case REQUIRE_QUOTES: {
                StringBuilder sb = new StringBuilder();
                sb.append("\"");
                block19: for (char c : arg.toCharArray()) {
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '\\': {
                            sb.append("\\").append(c);
                            continue block19;
                        }
                        case '\n': 
                        case '\r': {
                            throw new NIllegalArgumentException(NMsg.ofPlain("unsupported new line in arguments"));
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                sb.append("\"");
                return sb.toString();
            }
        }
        throw new NUnsupportedEnumException(s);
    }
}

