/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.shell;

import java.nio.file.Path;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.NameBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.ndi.base.BaseSystemNdi;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.settings.util.PathInfo;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.runtime.standalone.xtra.shell.ScriptBuilder;

public abstract class AbstractScriptBuilder
implements ScriptBuilder {
    private NId anyId;
    private String path;
    private String type;
    private NShellFamily shellFamily;

    public AbstractScriptBuilder(NShellFamily shellFamily, String type, NId anyId) {
        this.shellFamily = shellFamily;
        this.anyId = anyId.builder().setRepository(null).build();
        this.type = type;
    }

    public NShellFamily getShellFamily() {
        return this.shellFamily;
    }

    public NId getAnyId() {
        return this.anyId;
    }

    public String getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public AbstractScriptBuilder setPath(Path path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public AbstractScriptBuilder setPath(NPath path) {
        this.path = path == null ? null : path.toString();
        return this;
    }

    public AbstractScriptBuilder setPath(String preferredName) {
        this.path = preferredName;
        return this;
    }

    public PathInfo buildAddLine(BaseSystemNdi ndi) {
        return ndi.addFileLine(this.type, this.anyId, NPath.of(this.path), ndi.getCommentLineConfigHeader(), this.buildString(), NShellHelper.of(this.getShellFamily()).getShebanSh(), this.shellFamily);
    }

    @Override
    public PathInfo build() {
        NDefinition anyIdDef = NSearchCmd.of(this.anyId).setLatest(true).setDistinct(true).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinitions().findSingleton().get();
        NId anyId = anyIdDef.getId();
        String path = NameBuilder.id(anyId, this.path, "%n", anyIdDef.getDescriptor()).buildName();
        NPath script = NPath.of(path);
        String newContent = this.buildString();
        PathInfo.Status update = CoreIOUtils.tryWrite(newContent.getBytes(), script, "UpdateScript");
        script.addPermissions(NPathPermission.CAN_EXECUTE);
        return new PathInfo(this.type, anyId, script, update);
    }
}

