/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.io.NpsStatus;
import net.thevpc.nuts.io.NpsType;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNPsInfoBuilder;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class WindowsPsCsvParser {
    private NConnectionString connectionString;
    private NExecTargetInfo target;

    public WindowsPsCsvParser(NConnectionString connectionString, NExecTargetInfo target) {
        this.connectionString = connectionString;
        this.target = target;
    }

    public NStream<NPsInfo> parse(Reader reader) {
        final BufferedReader br = new BufferedReader(reader);
        return NStream.ofIterator(new Iterator<NPsInfo>(){
            NPsInfo last = null;
            boolean headerRead;
            String[] columns;

            @Override
            public boolean hasNext() {
                do {
                    String line = null;
                    try {
                        line = br.readLine();
                    }
                    catch (IOException e) {
                        throw new NIOException(e);
                    }
                    if (line == null) {
                        this.last = null;
                        return false;
                    }
                    if (!this.headerRead) {
                        this.columns = WindowsPsCsvParser.this.readColumns(line);
                        this.headerRead = true;
                        try {
                            line = br.readLine();
                        }
                        catch (IOException e) {
                            throw new NIOException(e);
                        }
                        if (line == null) {
                            return false;
                        }
                    }
                    String[] value = WindowsPsCsvParser.this.readColumns(line);
                    this.last = WindowsPsCsvParser.this.createNPsInfo(value, this.columns);
                } while (this.last == null);
                return true;
            }

            @Override
            public NPsInfo next() {
                return this.last;
            }
        });
    }

    private String[] readColumns(String line) {
        if (line.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                if (inQuotes && i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    sb.append('\"');
                    ++i;
                    continue;
                }
                inQuotes = !inQuotes;
                continue;
            }
            if (c == ',' && !inQuotes) {
                fields.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        fields.add(sb.toString());
        return fields.toArray(new String[0]);
    }

    private NPsInfo createNPsInfo(String[] values, String[] columns) {
        DefaultNPsInfoBuilder v = new DefaultNPsInfoBuilder();
        boolean empty = true;
        block36: for (int i = 0; i < columns.length; ++i) {
            String key = columns[i];
            String value = values[i];
            switch (key) {
                case "VSZ": {
                    v.setVirtualMemorySize(NLiteral.of(value).asLong().orElse(0L));
                    empty = false;
                    continue block36;
                }
                case "RSS": {
                    v.setResidentSetSize(NLiteral.of(value).asLong().orElse(0L));
                    empty = false;
                    continue block36;
                }
                case "PID": {
                    v.setId(value);
                    empty = false;
                    continue block36;
                }
                case "TIME": {
                    String normalized = value.replace(',', '.');
                    BigDecimal seconds = new BigDecimal(normalized);
                    long millis = seconds.multiply(BigDecimal.valueOf(1000L)).longValueExact();
                    v.setTime(millis);
                    empty = false;
                    continue block36;
                }
                case "STAT": {
                    switch (NStringUtils.trim(value).toLowerCase()) {
                        case "suspended": {
                            v.setStatus(NpsStatus.SUSPENDED);
                            break;
                        }
                        case "sleeping": {
                            v.setStatus(NpsStatus.WAITING_FOR_EVENT);
                            break;
                        }
                        case "running": {
                            v.setStatus(NpsStatus.RUNNING);
                            break;
                        }
                        case "idle": {
                            v.setStatus(NpsStatus.IDLE);
                            break;
                        }
                        default: {
                            v.setStatus(NpsStatus.UNKNOWN);
                        }
                    }
                    empty = false;
                    continue block36;
                }
                case "MEM": {
                    v.setPercentMem(NLiteral.of(value.replace(",", ".")).asDouble().orElse(0.0));
                    empty = false;
                    continue block36;
                }
                case "USER": {
                    v.setUser(value);
                    empty = false;
                    continue block36;
                }
                case "TTY": {
                    if ("N/A".equals(value)) {
                        // empty if block
                    }
                    empty = false;
                    continue block36;
                }
                case "START": {
                    if (!"N/A".equals(value)) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
                        LocalDateTime localDateTime = LocalDateTime.parse(value, formatter);
                        v.setStartTime(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                    }
                    empty = false;
                    continue block36;
                }
                case "COMMAND": {
                    this.setCommand(v, value);
                    empty = false;
                }
            }
        }
        if (empty) {
            return null;
        }
        return this._build(v);
    }

    private NPsInfo _build(DefaultNPsInfoBuilder v) {
        v.setType(NpsType.PROCESS);
        return v.build();
    }

    private void setCommand(DefaultNPsInfoBuilder v, String line) {
        block11: {
            v.setCmdLine(line);
            NCmdLines nCmdLines = NCmdLines.of().setShellFamily(NShellFamily.WIN_CMD).setLenient(true);
            try {
                v.setCmdLineArgs(nCmdLines.parseCmdLine(line).map(NCmdLine::toStringArray).orElse(null));
            }
            catch (Exception ex) {
                if (line.indexOf("\"\"") < 0) break block11;
                line = line.replace("\"\"", "\"");
                try {
                    v.setCmdLineArgs(nCmdLines.parseCmdLine(line).map(NCmdLine::toStringArray).orElse(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (v.getCmdLineArgs() != null && v.getCmdLineArgs().length > 0) {
            String[] a = v.getCmdLineArgs();
            if (a.length > 0) {
                int x = Math.max(a[0].lastIndexOf("/"), a[0].lastIndexOf("\\"));
                if (x >= 0) {
                    v.setName(NStringUtils.trimToNull(a[0].substring(x + 1)));
                } else {
                    v.setName(NStringUtils.trimToNull(a[0]));
                }
            }
        } else {
            int x = Math.max(v.getCmdLine().lastIndexOf("/"), v.getCmdLine().lastIndexOf("\\"));
            if (x >= 0) {
                v.setName(NStringUtils.trimToNull(v.getCmdLine().substring(x + 1)));
            } else {
                v.setName(NStringUtils.trimToNull(v.getCmdLine()));
            }
        }
    }
}

