/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.StringReader;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.runtime.standalone.xtra.ps.WindowsPs1Parser;
import net.thevpc.nuts.util.NStream;

public class WindowsPs1Caller {
    private NConnectionString connectionString;
    private NExecTargetInfo target;

    public WindowsPs1Caller(NConnectionString connectionString, NExecTargetInfo target) {
        this.connectionString = connectionString;
        this.target = target;
    }

    public NStream<NPsInfo> call(boolean failFast) {
        String cmd = "Get-WmiObject Win32_Process | ForEach-Object { $o=$_.GetOwner(); $user=if($o){$o.User}else{'N/A'}; $mem=Get-WmiObject Win32_ComputerSystem; $state=if ($_.ExecutionState -eq 0) {'Running'} elseif ($_.ExecutionState -eq 2) {'Sleeping'} else {'Suspended'}; $start=if ($_.CreationDate) {$_.CreationDate.Substring(0,12)} else {'N/A'}; New-Object PSObject -Property @{ USER=$user; PID=$_.ProcessId; CPU=([math]::Round(($_.KernelModeTime+$_.UserModeTime)/1e7,2)); MEM=([math]::Round($_.WorkingSetSize/$mem.TotalPhysicalMemory*100,2)); VSZ=[long]($_.VirtualSize/1KB); RSS=[long]($_.WorkingSetSize/1KB); TTY='N/A'; STAT=$state; START=$start; TIME=([math]::Round(($_.KernelModeTime+$_.UserModeTime)/1e7,2)); COMMAND=$_.CommandLine } }";
        NExecCmd u = NExecCmd.of().setIn(NExecInput.ofNull()).at(this.connectionString).grabErr().grabOut().addCommand("powershell.exe", "-Command", cmd).setFailFast(failFast);
        String grabbedOutString = u.getGrabbedOutString();
        try (StringReader br = new StringReader(grabbedOutString);){
            NStream<NPsInfo> nStream = new WindowsPs1Parser().parse(br);
            return nStream;
        }
    }
}

