/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.io.NpsStatus;
import net.thevpc.nuts.io.NpsType;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNPsInfoBuilder;
import net.thevpc.nuts.util.CharPredicate;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringBuilder;

public class UnixPsParser {
    public NStream<NPsInfo> parse(Reader reader) {
        final BufferedReader br = new BufferedReader(reader);
        try {
            br.readLine();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        final CharPredicate spaces = c -> c == ' ' || c == '\t';
        return NStream.ofIterator(new Iterator<NPsInfo>(){
            NPsInfo last = null;

            @Override
            public boolean hasNext() {
                String line;
                do {
                    line = null;
                    try {
                        line = br.readLine();
                    }
                    catch (IOException e) {
                        throw new NIOException(e);
                    }
                    if (line != null) continue;
                    return false;
                } while ((line = line.trim()).isEmpty());
                NStringBuilder sb = new NStringBuilder(line);
                DefaultNPsInfoBuilder pi = new DefaultNPsInfoBuilder();
                pi.setUser(sb.readUntil(spaces));
                sb.readWhile(spaces);
                pi.setId(sb.readUntil(spaces));
                sb.readWhile(spaces);
                pi.setPercentCpu(NLiteral.of(sb.readUntil(spaces)).asDouble().orElse(0.0));
                sb.readWhile(spaces);
                pi.setPercentMem(NLiteral.of(sb.readUntil(spaces)).asDouble().orElse(0.0));
                sb.readWhile(spaces);
                pi.setVirtualMemorySize(NLiteral.of(sb.readUntil(spaces)).asLong().orElse(0L));
                sb.readWhile(spaces);
                pi.setResidentSetSize(NLiteral.of(sb.readUntil(spaces)).asLong().orElse(0L));
                sb.readWhile(spaces);
                pi.setTerminal(UnixPsParser.parseTty(sb.readUntil(spaces)));
                sb.readWhile(spaces);
                String stat = sb.readUntil(spaces);
                sb.readWhile(spaces);
                HashSet<String> s = new HashSet<String>();
                pi.setStatus(UnixPsParser.parseStat(stat, s));
                pi.setStatusFlags(s);
                pi.setStartTime(UnixPsParser.parseStartDateAux(sb.readUntil(spaces)));
                sb.readWhile(spaces);
                pi.setTime(UnixPsParser.parseTime(sb.readUntil(spaces)));
                sb.readWhile(spaces);
                String cmd = sb.readUntil(spaces);
                sb.readWhile(spaces);
                if (cmd == null) {
                    pi.setType(NpsType.UNKNOWN);
                    pi.setCmdLine(cmd);
                    pi.setCmdLineArgs(null);
                } else if (cmd.startsWith("[") && cmd.endsWith("]")) {
                    pi.setType(NpsType.KERNEL_THREAD);
                    cmd = cmd.substring(1, cmd.length() - 1);
                    pi.setCmdLine(cmd);
                    pi.setCmdLineArgs(null);
                    int x = cmd.indexOf("/");
                    if (x >= 0) {
                        pi.setName(cmd.substring(0, x));
                    } else {
                        pi.setName(cmd);
                    }
                } else {
                    pi.setType(NpsType.PROCESS);
                    pi.setCmdLine(cmd);
                    pi.setCmdLineArgs(NCmdLine.parse(cmd).map(NCmdLine::toStringArray).orElse(null));
                    String[] a = pi.getCmdLineArgs();
                    if (a.length > 0) {
                        int x = a[0].lastIndexOf("/");
                        if (x >= 0) {
                            pi.setName(a[0].substring(x + 1));
                        } else {
                            pi.setName(cmd);
                        }
                    }
                }
                this.last = pi.build();
                return true;
            }

            @Override
            public NPsInfo next() {
                return this.last;
            }
        });
    }

    public static long parseTime(String time) {
        String[] parts = time.split(":");
        try {
            if (parts.length == 2) {
                int minutes = Integer.parseInt(parts[0]);
                int seconds = Integer.parseInt(parts[1]);
                return (minutes * 60 + seconds) * 1000;
            }
            if (parts.length == 3) {
                int hours = Integer.parseInt(parts[0]);
                int minutes = Integer.parseInt(parts[1]);
                int seconds = Integer.parseInt(parts[2]);
                return (hours * 3600 + minutes * 60 + seconds) * 1000;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0L;
    }

    public static NpsStatus parseStat(String stat, Set<String> s) {
        NpsStatus status = null;
        if (stat != null) {
            block17: for (char c : stat.toCharArray()) {
                switch (c) {
                    case 'D': {
                        status = NpsStatus.WAITING_FOR_IO;
                        continue block17;
                    }
                    case 'I': {
                        status = NpsStatus.IDLE;
                        continue block17;
                    }
                    case 'R': {
                        status = NpsStatus.RUNNING;
                        continue block17;
                    }
                    case 'S': {
                        status = NpsStatus.WAITING_FOR_EVENT;
                        continue block17;
                    }
                    case 'T': {
                        status = NpsStatus.STOPPED;
                        continue block17;
                    }
                    case 't': {
                        status = NpsStatus.STOPPED;
                        continue block17;
                    }
                    case 'W': {
                        status = NpsStatus.WAITING_FOR_IO;
                        continue block17;
                    }
                    case 'X': {
                        status = NpsStatus.DEAD;
                        continue block17;
                    }
                    case 'Z': {
                        status = NpsStatus.ZOMBIE;
                        continue block17;
                    }
                    case '<': {
                        s.add("high-priority");
                        continue block17;
                    }
                    case 'N': {
                        s.add("low-priority");
                        continue block17;
                    }
                    case 'L': {
                        s.add("pages-locked");
                        continue block17;
                    }
                    case 's': {
                        s.add("session-leader");
                        continue block17;
                    }
                    case 'l': {
                        s.add("multi-threaded");
                        continue block17;
                    }
                    case '+': {
                        s.add("foreground");
                        continue block17;
                    }
                    default: {
                        s.add("unknown-" + String.valueOf(c));
                    }
                }
            }
        }
        return status;
    }

    public static String parseTty(String tty) {
        if (tty == null) {
            return null;
        }
        if ((tty = tty.trim()).isEmpty()) {
            return null;
        }
        if (tty.equals("?")) {
            return null;
        }
        return tty;
    }

    public static Instant parseStartDateAux(String auxStatDate) {
        if (NBlankable.isBlank(auxStatDate)) {
            return null;
        }
        if (auxStatDate.length() == 5 && auxStatDate.matches("[a-zA-Z]{3}[0-9]{2}")) {
            int year = Integer.parseInt(auxStatDate.substring(auxStatDate.length() - 2));
            String monthName = auxStatDate.substring(0, auxStatDate.length() - 2);
            int month = 1;
            switch (monthName.trim().toLowerCase()) {
                case "jan": {
                    month = 1;
                    break;
                }
                case "feb": {
                    month = 2;
                    break;
                }
                case "mar": {
                    month = 3;
                    break;
                }
                case "apr": {
                    month = 4;
                    break;
                }
                case "may": {
                    month = 5;
                    break;
                }
                case "jun": {
                    month = 6;
                    break;
                }
                case "jul": {
                    month = 7;
                    break;
                }
                case "aug": {
                    month = 8;
                    break;
                }
                case "sep": {
                    month = 9;
                    break;
                }
                case "oct": {
                    month = 10;
                    break;
                }
                case "nov": {
                    month = 11;
                    break;
                }
                case "dec": {
                    month = 12;
                    break;
                }
                default: {
                    return null;
                }
            }
            String yearString = String.format("%04d", 2000 + year);
            String monthString = String.format("%02d", month);
            String fullDateStr = yearString + "-" + monthString + "-01";
            LocalDate localDate = LocalDate.parse(fullDateStr);
            LocalDateTime dateTime = localDate.atStartOfDay();
            return dateTime.atZone(ZoneId.systemDefault()).toInstant();
        }
        if (auxStatDate.matches("[0-9]+:[0-9]+")) {
            String[] parts = auxStatDate.split(":");
            String timeStr = String.format("%02d", NLiteral.of(parts[0]).asInt().get()) + ":" + String.format("%02d", NLiteral.of(parts[1]).asInt().get()) + ":00";
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
            LocalTime time = LocalTime.parse(timeStr, formatter);
            LocalDateTime dateTime = LocalDate.now().atTime(time);
            return dateTime.atZone(ZoneId.systemDefault()).toInstant();
        }
        if (auxStatDate.matches("[0-9]{4}")) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy");
            LocalTime time = LocalTime.parse(auxStatDate, formatter);
            LocalDateTime dateTime = LocalDate.now().atTime(time);
            return dateTime.atZone(ZoneId.systemDefault()).toInstant();
        }
        return null;
    }

    public static Instant parseStartDateLong(String lstart) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);
        LocalDateTime dateTime = LocalDateTime.parse(lstart.replace("  ", " "), formatter);
        return dateTime.atZone(ZoneId.systemDefault()).toInstant();
    }
}

