/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.ps;

import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecTargetInfo;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPs;
import net.thevpc.nuts.io.NPsInfo;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.platform.NPlatformLocation;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamEmpty;
import net.thevpc.nuts.runtime.standalone.util.stream.NStreamFromNIterator;
import net.thevpc.nuts.runtime.standalone.xtra.ps.DefaultNPsInfoBuilder;
import net.thevpc.nuts.runtime.standalone.xtra.ps.LinuxPsParser;
import net.thevpc.nuts.runtime.standalone.xtra.ps.UnixPsParser;
import net.thevpc.nuts.runtime.standalone.xtra.ps.WindowsPs1Caller;
import net.thevpc.nuts.runtime.standalone.xtra.ps.WindowsPsCsvCaller;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NUnsupportedOperationException;
import net.thevpc.nuts.util.NUtils;

public class DefaultNPs
implements NPs {
    private NPlatformFamily platformFamily;
    private NConnectionString connectionString;
    private boolean failFast;

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    @Override
    public NConnectionString getConnectionString() {
        return this.connectionString;
    }

    @Override
    public NPs setConnectionString(String host) {
        this.connectionString = host == null ? null : NConnectionString.of(host);
        return this;
    }

    @Override
    public NPs at(String host) {
        return this.setConnectionString(host);
    }

    @Override
    public NPs setConnectionString(NConnectionString host) {
        this.connectionString = host;
        return this;
    }

    @Override
    public NPs at(NConnectionString host) {
        return this.setConnectionString(host);
    }

    @Override
    public NPs setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public boolean isSupportedKillProcess() {
        NOsFamily f = NWorkspace.of().getOsFamily();
        return f == NOsFamily.LINUX || f == NOsFamily.MACOS || f == NOsFamily.UNIX;
    }

    @Override
    public boolean killProcess(String processId) {
        switch (NWorkspace.of().getOsFamily()) {
            case LINUX: 
            case MACOS: 
            case UNIX: {
                return NExecCmd.ofSystem("kill", "-9", processId).at(this.connectionString).setFailFast(this.isFailFast()).getResultCode() == 0;
            }
            case WINDOWS: {
                String taskkill = NWorkspace.of().findSysCommand("taskkill").orNull();
                if (taskkill != null) {
                    return NExecCmd.ofSystem(taskkill, "/PID", processId, "/F").at(this.connectionString).setFailFast(this.isFailFast()).getResultCode() == 0;
                }
                throw new NUnsupportedOperationException(NMsg.ofC("unsupported kill process in : %s", NWorkspace.of().getOsFamily().id()));
            }
        }
        if (this.isFailFast()) {
            throw new NUnsupportedOperationException(NMsg.ofC("unsupported kill process in : %s", NWorkspace.of().getOsFamily().id()));
        }
        return false;
    }

    @Override
    public NPs failFast(boolean failFast) {
        return this.setFailFast(failFast);
    }

    @Override
    public NPs failFast() {
        return this.failFast(true);
    }

    @Override
    public NPlatformFamily getPlatformFamily() {
        return this.platformFamily;
    }

    @Override
    public NPs setPlatformFamily(NPlatformFamily platformFamily) {
        this.platformFamily = platformFamily;
        return this;
    }

    private static String getJpsJavaHome2(String version) {
        NPlatformLocation[] availableJava;
        ArrayList<String> detectedJavaHomes = new ArrayList<String>();
        String jh = System.getProperty("java.home");
        detectedJavaHomes.add(jh);
        String v = DefaultNPs.getJpsJavaHome(jh);
        if (v != null) {
            return v;
        }
        NWorkspace workspace = NWorkspace.of();
        NVersionFilter nvf = NBlankable.isBlank(version) ? null : NVersion.get(version).get().filter();
        for (NPlatformLocation java2 : availableJava = (NPlatformLocation[])workspace.findPlatforms(NPlatformFamily.JAVA, java -> "jdk".equals(java.getPackaging()) && (nvf == null || nvf.acceptVersion(NVersion.get(java.getVersion()).get()))).toArray(NPlatformLocation[]::new)) {
            detectedJavaHomes.add(java2.getPath());
            v = DefaultNPs.getJpsJavaHome(java2.getPath());
            if (v == null) continue;
            return v;
        }
        throw new NExecutionException(NMsg.ofC("unable to resolve a valid jdk installation. Either run nuts with a valid JDK/SDK (not JRE) or register a valid one using 'nuts settings' command. All the followings are invalid : \n%s", String.join((CharSequence)"\n", detectedJavaHomes)), 2);
    }

    private static String getJpsJavaHome(String base) {
        File jh = new File(base);
        if (new File(jh, ".." + File.separator + "bin" + File.separator + "jps").exists()) {
            return jh.getParent();
        }
        if (new File(jh, "bin" + File.separator + "jps").exists()) {
            return jh.getPath();
        }
        return null;
    }

    @Override
    public NStream<NPsInfo> getResultList() {
        NExecTargetInfo target = NBlankable.isBlank(this.connectionString) ? null : NExecCmd.ofSystem(new String[0]).at(this.connectionString).probeTarget();
        NOsFamily cmdOsFamily = target == null ? NWorkspace.of().getOsFamily() : target.getOsFamily();
        NPlatformFamily processType = NUtils.firstNonNull(this.platformFamily, NPlatformFamily.OS);
        switch (processType) {
            case JAVA: {
                return this.getResultListJava(target, cmdOsFamily);
            }
            case OS: {
                return this.getResultListOS(target, cmdOsFamily);
            }
        }
        if (this.isFailFast()) {
            throw new NIllegalArgumentException(NMsg.ofC("unsupported list processes of type : %s", processType));
        }
        return new NStreamEmpty<NPsInfo>("process-" + processType.id());
    }

    private NStream<NPsInfo> getResultListOS(NExecTargetInfo target, NOsFamily cmdOsFamily) {
        switch (cmdOsFamily) {
            case LINUX: {
                NExecCmd u = NExecCmd.of().setIn(NExecInput.ofNull()).at(this.connectionString).addCommand("ps", "-eo", "user,pid,%cpu,%mem,vsz,rss,tty,stat,lstart,time,command").grabErr().setFailFast(this.isFailFast()).grabOut();
                String grabbedOutString = u.getGrabbedOutString();
                return new LinuxPsParser().parse(new StringReader(grabbedOutString));
            }
            case MACOS: 
            case UNIX: {
                NExecCmd u = NExecCmd.of().setIn(NExecInput.ofNull()).at(this.connectionString).addCommand("ps", "aux").grabErr().setFailFast(this.isFailFast()).grabOut();
                return new UnixPsParser().parse(new StringReader(u.getGrabbedOutString()));
            }
            case WINDOWS: {
                boolean IMPL_WmiObject_Win32_Process_Csv = true;
                int IMPL_WmiObject_Win32_Process_NoFile = 2;
                int mode = 2;
                switch (mode) {
                    case 1: {
                        return new WindowsPsCsvCaller(this.connectionString, target).call(this.isFailFast());
                    }
                    case 2: {
                        return new WindowsPs1Caller(this.connectionString, target).call(this.isFailFast());
                    }
                }
            }
        }
        if (this.isFailFast()) {
            throw new NIllegalArgumentException(NMsg.ofC("unsupported list processes of type : OS"));
        }
        return new NStreamEmpty<NPsInfo>("process");
    }

    private NStream<NPsInfo> getResultListJava(NExecTargetInfo target, NOsFamily cmdOsFamily) {
        String separator;
        boolean remote;
        boolean bl = remote = !NBlankable.isBlank(this.connectionString);
        if (remote) {
            switch (cmdOsFamily) {
                case WINDOWS: {
                    separator = "\\";
                    break;
                }
                default: {
                    separator = "/";
                    break;
                }
            }
        } else {
            separator = File.separator;
        }
        NIterator it = NIteratorBuilder.ofSupplier(() -> {
            String cmd = "jps";
            NExecCmd b = null;
            boolean mainArgs = true;
            boolean vmArgs = true;
            String jdkHome = null;
            if (!remote) {
                jdkHome = DefaultNPs.getJpsJavaHome2("");
            }
            if (jdkHome != null) {
                cmd = jdkHome + separator + "bin" + separator + cmd;
            }
            b = NExecCmd.of().system().at(this.connectionString).addCommand(cmd).addCommand("-l" + (mainArgs ? "m" : "") + (vmArgs ? "v" : "")).grabAll().setFailFast(this.isFailFast());
            b.getResultCode();
            if (b.getResultCode() == 0) {
                String out = b.getGrabbedOutString();
                String[] split = out.split("\n");
                return Arrays.asList(split).iterator();
            }
            return NIteratorBuilder.emptyIterator();
        }, () -> NElement.ofString("jps")).map(NFunction.of(line -> {
            DefaultNPsInfoBuilder p = new DefaultNPsInfoBuilder();
            int s1 = line.indexOf(32);
            int s2 = line.indexOf(32, s1 + 1);
            String pid = line.substring(0, s1).trim();
            String cls = line.substring(s1 + 1, s2 < 0 ? line.length() : s2).trim();
            String cmdLineString = s2 >= 0 ? line.substring(s2 + 1).trim() : "";
            String[] parsedCmdLine = null;
            parsedCmdLine = this.betterArgs(pid, target);
            if (parsedCmdLine == null) {
                parsedCmdLine = NCmdLine.of(cmdLineString, null).toStringArray();
            }
            p.setId(pid).setName(cls).setCmdLine(cmdLineString).setCmdLineArgs(parsedCmdLine);
            return p.build();
        }).redescribe((Supplier)NElementDescribables.ofDesc("processInfo"))).build();
        return new NStreamFromNIterator<NPsInfo>("process-" + this.getPlatformFamily(), it);
    }

    private String[] betterArgs(String pid, NExecTargetInfo target) {
        switch (target == null ? NWorkspace.of().getOsFamily() : target.getOsFamily()) {
            case LINUX: 
            case MACOS: 
            case UNIX: {
                try {
                    NPath procFile;
                    NPath nPath = procFile = NBlankable.isBlank(this.connectionString) ? NPath.of("/proc/" + pid + "/cmdline") : NPath.of(this.connectionString.withPath("/proc/" + pid + "/cmdline"));
                    if (procFile.exists()) {
                        return procFile.readString().split("\u0000");
                    }
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

