/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb.mem;

import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStoreDefaultFactory;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.mem.NanoDBDefaultIndexInMem;
import net.thevpc.nuts.util.NStream;

public class NanoDBTableStoreMem<T>
implements NanoDBTableStore<T> {
    public static final String NANODB_TABLE_0_8_1 = "nanodb-table-0.8.1";
    private final Object tableLock = new Object();
    private final Map<String, IndexInfo> indexDefinitions = new HashMap<String, IndexInfo>();
    private final String tableName;
    private final NanoDB db;
    private FileChannel readChannel;
    private Class<T> rowType;
    private List<T> rows = new ArrayList<T>();

    public NanoDBTableStoreMem(Class<T> rowType, String tableName, NanoDB db, NanoDBIndexDefinition<T>[] indexDefinitions) {
        this.rowType = rowType;
        this.db = db;
        this.tableName = tableName;
        for (NanoDBIndexDefinition<T> indexDefinition : indexDefinitions) {
            this.indexDefinitions.put(indexDefinition.getIndexName(), new IndexInfo(indexDefinition));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long position) {
        Object object = this.tableLock;
        synchronized (object) {
            return this.rows.get((int)position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(T a) {
        Object object = this.tableLock;
        synchronized (object) {
            int len = this.rows.size();
            this.rows.add(a);
            this.updateIndices(a, len);
            return len;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public NStream<T> stream() {
        return NStream.ofStream(new ArrayList<T>(this.rows).stream());
    }

    @Override
    public Iterable<T> items() {
        return new ArrayList<T>(this.rows);
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayList<T>(this.rows).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndices(T a, long objectId) {
        Object object = this.tableLock;
        synchronized (object) {
            for (IndexInfo value : this.indexDefinitions.values()) {
                NanoDBIndex fi = value.getData();
                fi.put(value.getDefinition().getIndexedValue(a), objectId);
                value.dirty = true;
            }
        }
    }

    @Override
    public NStream<T> findByIndex(String indexName, Object value) {
        return NStream.ofStream(this.resolveIndexInfo(indexName).getData().get(value).mapToObj(pos -> this.get(pos)));
    }

    @Override
    public <T> NStream<T> findIndexValues(String indexName) {
        return NStream.ofStream(this.resolveIndexInfo(indexName).getData().findAll());
    }

    @Override
    public long getFileLength() {
        return this.rows.size();
    }

    private IndexInfo resolveIndexInfo(String name) {
        IndexInfo y = this.indexDefinitions.get(name);
        if (y == null) {
            throw new IllegalArgumentException("not found index: " + name);
        }
        return y;
    }

    private class IndexInfo {
        NanoDBIndexDefinition def;
        NanoDBIndex data;
        boolean dirty;

        public IndexInfo(NanoDBIndexDefinition def) {
            this.def = def;
        }

        public NanoDBIndexDefinition getDefinition() {
            return this.def;
        }

        public void flushIfDirty() {
            if (this.dirty) {
                this.flush();
                this.dirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = NanoDBTableStoreMem.this.tableLock;
            synchronized (object) {
                this.data.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoDBIndex getData() {
            Object object = NanoDBTableStoreMem.this.tableLock;
            synchronized (object) {
                NanoDBDefaultIndexInMem fi;
                if (this.data != null) {
                    return this.data;
                }
                this.data = fi = new NanoDBDefaultIndexInMem(this.def.getIndexType(), NanoDBTableStoreMem.this.db.getSerializers().findSerializer(this.def.getIndexType(), this.def.isNullable()), new DBIndexValueStoreDefaultFactory(), new HashMap());
                return fi;
            }
        }

        private String getIndexName() {
            return this.def.getIndexName();
        }
    }
}

