/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb.file;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStoreDefaultFactory;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDB;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBDefaultOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndexDefinition;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBInputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBOutputStream;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBSerializer;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBTableStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.file.NanoDBDefaultIndex;
import net.thevpc.nuts.util.NStream;

public class NanoDBTableStoreFile<T>
implements NanoDBTableStore<T> {
    public static final String NANODB_TABLE_0_8_1 = "nanodb-table-0.8.1";
    private final Object tableLock = new Object();
    private final NanoDBSerializer<T> serializer;
    private final Map<String, IndexInfo> indexDefinitions = new HashMap<String, IndexInfo>();
    private final File dir;
    private final String tableName;
    private final NanoDB db;
    private NanoDBOutputStream writeStream;
    private NanoDBInputStream readStream;
    private FileChannel readChannel;
    private Class<T> rowType;

    public NanoDBTableStoreFile(Class<T> rowType, File dir, String tableName, NanoDBSerializer<T> serializer, NanoDB db, NanoDBIndexDefinition<T>[] indexDefinitions) {
        this.rowType = rowType;
        this.dir = dir;
        this.db = db;
        this.tableName = tableName;
        this.serializer = serializer;
        for (NanoDBIndexDefinition<T> indexDefinition : indexDefinitions) {
            this.indexDefinitions.put(indexDefinition.getIndexName(), new IndexInfo(indexDefinition));
        }
    }

    public static int getUTFLength(String s) {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        int init = 0;
        try {
            DataOutputStream r = new DataOutputStream(o);
            r.flush();
            init = o.toByteArray().length;
            r.writeUTF(s);
            r.flush();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
        return o.toByteArray().length - init;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long position) {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.readStream == null) {
                try {
                    FileInputStream readStreamFIS = new FileInputStream(this.getTableFile());
                    this.readChannel = readStreamFIS.getChannel();
                    this.readStream = new NanoDBDefaultInputStream(readStreamFIS);
                }
                catch (FileNotFoundException e) {
                    throw new NIOException(e);
                }
            }
            try {
                this.readChannel.position(position);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            return this.serializer.read(this.readStream, this.rowType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(T a) {
        Object object = this.tableLock;
        synchronized (object) {
            File tableFile = this.getTableFile();
            boolean writeHeader = false;
            long len = 0L;
            if (!tableFile.exists() || tableFile.length() == 0L) {
                writeHeader = true;
            } else {
                len = tableFile.length();
            }
            if (this.writeStream == null) {
                try {
                    File p = tableFile.getParentFile();
                    if (p != null) {
                        p.mkdirs();
                    }
                    this.writeStream = new NanoDBDefaultOutputStream(new FileOutputStream(tableFile, true));
                }
                catch (FileNotFoundException e) {
                    throw new NIOException(e);
                }
            }
            if (writeHeader) {
                this.writeStream.writeUTF(NANODB_TABLE_0_8_1);
                this.writeStream.flush();
                len = this.writeStream.getPosition();
            }
            this.serializer.write(a, this.writeStream);
            this.updateIndices(a, len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.writeStream != null) {
                this.writeStream.flush();
            }
            for (IndexInfo value : this.indexDefinitions.values()) {
                value.flushIfDirty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.tableLock;
        synchronized (object) {
            this.flush();
            if (this.writeStream != null) {
                this.writeStream.flush();
                this.writeStream.close();
                this.writeStream = null;
            }
            if (this.readStream != null) {
                this.readStream.close();
                this.readStream = null;
            }
            if (this.readChannel != null) {
                this.readChannel = null;
            }
        }
    }

    @Override
    public NStream<T> stream() {
        return NStream.ofStream(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false));
    }

    @Override
    public Iterable<T> items() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return NanoDBTableStoreFile.this.iterator();
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            T nextValue;
            private NanoDBInputStream is;
            private boolean closed;
            private String header;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.closed) {
                    return false;
                }
                Object object = NanoDBTableStoreFile.this.tableLock;
                synchronized (object) {
                    if (this.is == null && NanoDBTableStoreFile.this.getTableFile().exists()) {
                        try {
                            this.is = new NanoDBDefaultInputStream(new FileInputStream(NanoDBTableStoreFile.this.getTableFile()));
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                        this.header = this.is.readUTF();
                    }
                    if (this.is != null) {
                        try {
                            this.nextValue = NanoDBTableStoreFile.this.serializer.read(this.is, NanoDBTableStoreFile.this.rowType);
                            return this.nextValue != null;
                        }
                        catch (Exception ex) {
                            try {
                                this.is.close();
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                this.is = null;
                                this.closed = true;
                            }
                            if (ex instanceof UncheckedIOException && ex.getCause() instanceof EOFException) {
                                return false;
                            }
                            if (ex instanceof NIOException) {
                                if (ex.getCause() instanceof EOFException) {
                                    return false;
                                }
                                throw (NIOException)ex;
                            }
                            throw new NIOException(ex);
                        }
                    }
                    return false;
                }
            }

            @Override
            public T next() {
                return this.nextValue;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndices(T a, long objectId) {
        Object object = this.tableLock;
        synchronized (object) {
            for (IndexInfo value : this.indexDefinitions.values()) {
                NanoDBIndex fi = value.getData();
                fi.put(value.getDefinition().getIndexedValue(a), objectId);
                value.dirty = true;
            }
        }
    }

    private File getTableFile() {
        return new File(this.dir, this.tableName + ".table");
    }

    @Override
    public NStream<T> findByIndex(String indexName, Object value) {
        return NStream.ofStream(this.resolveIndexInfo(indexName).getData().get(value).mapToObj(pos -> this.get(pos)));
    }

    @Override
    public <T> NStream<T> findIndexValues(String indexName) {
        return NStream.ofStream(this.resolveIndexInfo(indexName).getData().findAll());
    }

    @Override
    public long getFileLength() {
        return this.getTableFile().length();
    }

    private IndexInfo resolveIndexInfo(String name) {
        IndexInfo y = this.indexDefinitions.get(name);
        if (y == null) {
            throw new IllegalArgumentException("not found index: " + name);
        }
        return y;
    }

    private class IndexInfo {
        NanoDBIndexDefinition def;
        NanoDBIndex data;
        boolean dirty;

        public IndexInfo(NanoDBIndexDefinition def) {
            this.def = def;
        }

        public NanoDBIndexDefinition getDefinition() {
            return this.def;
        }

        public void flushIfDirty() {
            if (this.dirty) {
                this.flush();
                this.dirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = NanoDBTableStoreFile.this.tableLock;
            synchronized (object) {
                this.data.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NanoDBIndex getData() {
            Object object = NanoDBTableStoreFile.this.tableLock;
            synchronized (object) {
                if (this.data != null) {
                    return this.data;
                }
                NanoDBDefaultIndex fi = new NanoDBDefaultIndex(this.def.getIndexType(), NanoDBTableStoreFile.this.db.getSerializers().findSerializer(this.def.getIndexType(), this.def.isNullable()), new DBIndexValueStoreDefaultFactory(), new HashMap(), this.getIndexFile());
                fi.load();
                this.data = fi;
                return fi;
            }
        }

        private File getIndexFile() {
            return new File(NanoDBTableStoreFile.this.dir, NanoDBTableStoreFile.this.tableName + "." + this.getIndexName() + ".index");
        }

        private String getIndexName() {
            return this.def.getIndexName();
        }
    }
}

