/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.nanodb.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.DBIndexValueStore;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.NanoDBIndex;
import net.thevpc.nuts.runtime.standalone.xtra.nanodb.file.NanoDBDefaultIndex;

public class DBIndexValueFileStore
implements DBIndexValueStore {
    public static final String NANODB_INDEX_STORE_0_8_1 = "nanodb-index-store-0.8.1";
    private File file;
    private DataOutputStream out;
    private final NanoDBIndex index;
    private final Object indexKey;

    public DBIndexValueFileStore(NanoDBIndex index, Object indexKey) {
        this.index = index;
        this.indexKey = indexKey;
    }

    public File getFile() {
        if (this.file == null) {
            File indexFile = ((NanoDBDefaultIndex)this.index).getFile();
            String indexFileName = indexFile.getName();
            this.file = indexFileName.endsWith(".index") ? new File(indexFile.getParentFile(), indexFileName.substring(0, indexFileName.length() - ".index".length()) + "." + this.indexKey + ".index-store") : new File(indexFile.getParentFile(), indexFileName + "." + this.indexKey + ".index-store");
        }
        return this.file;
    }

    @Override
    public void add(long position) {
        if (this.out == null) {
            try {
                File pf = this.getFile().getParentFile();
                if (pf != null) {
                    pf.mkdirs();
                }
                this.out = new DataOutputStream(new FileOutputStream(this.getFile(), true));
                this.out.writeUTF(NANODB_INDEX_STORE_0_8_1);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }
        try {
            this.out.writeLong(position);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        try {
            this.out.close();
            this.out = null;
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void addAll(long[] positions) {
        if (this.out == null) {
            try {
                File pf = this.getFile().getParentFile();
                if (pf != null) {
                    pf.mkdirs();
                }
                this.out = new DataOutputStream(new FileOutputStream(this.getFile(), true));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            for (long position : positions) {
                this.out.writeLong(position);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        try {
            this.out.close();
            this.out = null;
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public LongStream stream() {
        PrimitiveIterator.OfLong iterator = new PrimitiveIterator.OfLong(){
            final DataInputStream in;
            long nextValue;
            final String header;
            {
                try {
                    this.in = new DataInputStream(new FileInputStream(DBIndexValueFileStore.this.getFile()));
                    this.header = this.in.readUTF();
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.in.available() > 0) {
                        this.nextValue = this.in.readLong();
                        return false;
                    }
                }
                catch (EOFException ex) {
                    return false;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
                return true;
            }

            @Override
            public long nextLong() {
                return this.nextValue;
            }
        };
        return StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    @Override
    public boolean isMem() {
        return false;
    }

    @Override
    public void flush() {
    }
}

