/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.mon;

import java.util.logging.Level;
import net.thevpc.nuts.runtime.standalone.xtra.mon.NProgressMonitorHelper;
import net.thevpc.nuts.time.NProgressHandler;
import net.thevpc.nuts.time.NProgressHandlerEvent;
import net.thevpc.nuts.time.NProgressMonitor;

public class FreqProgressHandler
implements NProgressHandler {
    private long freq;
    private long lastMessageTime;
    private long lastProgressTime;
    private Level level = Level.INFO;
    private NProgressMonitor delegate;

    public FreqProgressHandler(NProgressMonitor delegate, long freq) {
        this.delegate = delegate;
        if (freq < 0L) {
            freq = 0L;
        }
        this.freq = freq;
    }

    public NProgressMonitor getDelegate() {
        return this.delegate;
    }

    @Override
    public void onEvent(NProgressHandlerEvent event) {
        switch (event.getEventType()) {
            case PROGRESS: {
                double progress = event.getModel().getProgress();
                long newd = System.currentTimeMillis();
                if (newd <= this.lastProgressTime + this.freq && progress != 0.0 && progress != 1.0 && !Double.isNaN(progress)) break;
                this.getDelegate().setProgress(progress);
                this.lastProgressTime = newd;
                break;
            }
            case MESSAGE: {
                long newd = System.currentTimeMillis();
                if (newd <= this.lastMessageTime + this.freq) break;
                this.getDelegate().setMessage(event.getModel().getMessage());
                this.lastMessageTime = newd;
                break;
            }
            default: {
                NProgressMonitorHelper.processState(this.getDelegate(), event);
            }
        }
    }
}

