/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.mon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceModel;
import net.thevpc.nuts.runtime.standalone.xtra.mon.DefaultNProgressHandlerEvent;
import net.thevpc.nuts.runtime.standalone.xtra.mon.DefaultNProgressMonitorModel;
import net.thevpc.nuts.runtime.standalone.xtra.mon.DeltaProgressMonitorInc;
import net.thevpc.nuts.runtime.standalone.xtra.mon.FreqProgressHandler;
import net.thevpc.nuts.runtime.standalone.xtra.mon.LongIterationProgressMonitorInc;
import net.thevpc.nuts.runtime.standalone.xtra.mon.NProgressMonitorInc;
import net.thevpc.nuts.runtime.standalone.xtra.mon.ProgressMonitorTranslator;
import net.thevpc.nuts.runtime.standalone.xtra.mon.SilentProgressHandler;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NClock;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressEventType;
import net.thevpc.nuts.time.NProgressHandler;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.time.NProgressMonitor;
import net.thevpc.nuts.time.NProgressMonitors;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class DefaultProgressMonitor
implements NProgressMonitor {
    public static final NMsg EMPTY_MESSAGE = NMsg.ofPlain("");
    private List<NProgressListener> listeners = new ArrayList<NProgressListener>();
    private DefaultNProgressMonitorModel model = new DefaultNProgressMonitorModel();
    private boolean strictComputationMonitor = true;
    private NProgressHandler spi;
    private NProgressMonitorInc incrementor;

    public DefaultProgressMonitor(String id, NProgressHandler spi, NProgressMonitorInc incrementor) {
        this.model.setId(id == null ? UUID.randomUUID().toString() : id);
        this.spi = spi;
        this.incrementor = incrementor;
    }

    @Override
    public void runWithAll(Runnable ... runnables) {
        NProgressMonitor mon = NProgressMonitor.of();
        mon.start();
        runnables = (Runnable[])Arrays.stream(runnables).filter(x -> x != null).toArray(Runnable[]::new);
        NProgressMonitor[] mons = mon.split(runnables.length);
        for (int i = 0; i < mons.length; ++i) {
            mons[i].runWith(runnables[i]);
        }
        mon.complete();
    }

    @Override
    public void runWithAll(Runnable[] runnables, double[] weights) {
        NAssert.requireEquals(Integer.valueOf(runnables.length), Integer.valueOf(weights.length), "runWithAll");
        int count = 0;
        for (int i = 0; i < runnables.length; ++i) {
            if (runnables[i] == null) continue;
            ++count;
        }
        Runnable[] runnables2 = new Runnable[count];
        double[] weights2 = new double[count];
        count = 0;
        for (int i = 0; i < runnables.length; ++i) {
            if (runnables[i] == null) continue;
            runnables2[count] = runnables[i];
            weights2[count] = weights[i];
            ++count;
        }
        NProgressMonitor mon = NProgressMonitor.of();
        mon.start();
        NProgressMonitor[] mons = mon.split(weights2);
        for (int i = 0; i < mons.length; ++i) {
            mons[i].runWith(runnables2[i]);
        }
        mon.complete();
    }

    @Override
    public void runWith(Runnable runnable) {
        NWorkspaceModel m = NWorkspaceExt.of().getModel();
        m.currentProgressMonitors.runWith(this, runnable);
    }

    @Override
    public <T> T callWith(NCallable<T> callable) {
        NWorkspaceModel m = NWorkspaceExt.of().getModel();
        return m.currentProgressMonitors.callWith(this, callable);
    }

    @Override
    public final NProgressMonitor setProgress(double progress, NMsg message) {
        this.setProgress(progress);
        if (message != null) {
            this.setMessage(message);
        }
        return this;
    }

    @Override
    public NProgressMonitor start(NMsg message) {
        if (!this.isStarted()) {
            this.model.setStarted(true);
            this.model.setProgress(0.0);
            this.model.getChronometer().start();
            this.setMessageIfNotNull(message);
            this.fireEvent(NProgressEventType.START, "started", false);
        }
        return this;
    }

    @Override
    public NProgressMonitor start() {
        return this.start(null);
    }

    @Override
    public NProgressMonitor complete() {
        return this.complete(null);
    }

    @Override
    public NProgressMonitor complete(NMsg message) {
        return this.setTerminated(true, message);
    }

    @Override
    public NProgressMonitor undoComplete() {
        return this.undoComplete(null);
    }

    @Override
    public NProgressMonitor undoComplete(NMsg message) {
        return this.setTerminated(false, message);
    }

    protected NProgressMonitor setTerminated(boolean terminated, NMsg message) {
        if (terminated) {
            if (!this.isCompleted()) {
                if (!this.isStarted()) {
                    this.model.setStarted(true);
                    this.model.getChronometer().start();
                    this.fireEvent(NProgressEventType.START, "started", false);
                }
                this.model.setProgress(1.0);
                this.setMessageIfNotNull(message);
                boolean oldCompleted = this.model.isCompleted();
                if (!oldCompleted) {
                    this.model.setCompleted(true);
                    this.fireEvent(NProgressEventType.COMPLETE, "completed", oldCompleted);
                }
            }
        } else if (this.isCompleted()) {
            this.model.setCompleted(false);
            this.fireEvent(NProgressEventType.UNDO_COMPLETE, "completed", false);
        }
        return this;
    }

    @Override
    public NProgressMonitor cancel() {
        return this.cancel(null);
    }

    @Override
    public NProgressMonitor cancel(NMsg message) {
        return this.setCancelled(true, message);
    }

    @Override
    public NProgressMonitor undoCancel() {
        return this.undoCancel(null);
    }

    @Override
    public NProgressMonitor undoCancel(NMsg message) {
        return this.setCancelled(false, message);
    }

    protected NProgressMonitor setCancelled(boolean cancel, NMsg message) {
        if (cancel) {
            if (!this.isCanceled()) {
                this.model.setCancelled(true);
                this.setMessageIfNotNull(message);
                this.fireEvent(NProgressEventType.CANCEL, "canceled", false);
            }
        } else if (this.isCanceled()) {
            this.model.setCancelled(false);
            this.setMessageIfNotNull(message);
            this.fireEvent(NProgressEventType.UNDO_CANCEL, "canceled", true);
        }
        return this;
    }

    @Override
    public NProgressMonitor undoSuspend() {
        return this.undoSuspend(null);
    }

    @Override
    public NProgressMonitor undoSuspend(NMsg message) {
        return this.setSuspended(false, null);
    }

    @Override
    public NProgressMonitor suspend() {
        return this.suspend(null);
    }

    @Override
    public NProgressMonitor suspend(NMsg message) {
        return this.setSuspended(true, null);
    }

    public NProgressMonitor setSuspended(boolean suspend, NMsg message) {
        if (suspend) {
            if (!this.isSuspended()) {
                this.model.setSuspended(true);
                this.setMessageIfNotNull(message);
                this.fireEvent(NProgressEventType.SUSPEND, "suspended", false);
            }
        } else if (this.isSuspended()) {
            this.model.setSuspended(false);
            this.setMessageIfNotNull(message);
            this.fireEvent(NProgressEventType.UNDO_SUSPEND, "suspended", true);
        }
        return this;
    }

    @Override
    public boolean isSuspended() {
        return this.model.isSuspended();
    }

    @Override
    public boolean isCompleted() {
        return this.model.isCompleted();
    }

    @Override
    public boolean isBlocked() {
        return this.model.isBlocked();
    }

    @Override
    public NProgressMonitor block() {
        return this.block(null);
    }

    @Override
    public NProgressMonitor block(NMsg message) {
        return this.setBlocked(true, message);
    }

    @Override
    public NProgressMonitor undoBlock() {
        return this.undoBlock(null);
    }

    @Override
    public NProgressMonitor undoBlock(NMsg message) {
        return this.setBlocked(false, message);
    }

    public NProgressMonitor setBlocked(boolean block, NMsg message) {
        if (block) {
            if (!this.model.isBlocked()) {
                this.model.setBlocked(true);
                this.setMessageIfNotNull(message);
                this.fireEvent(NProgressEventType.BLOCK, "blocked", false);
            }
        } else if (this.model.isBlocked()) {
            this.model.setBlocked(false);
            this.setMessageIfNotNull(message);
            this.fireEvent(NProgressEventType.UNDO_BLOCK, "blocked", true);
        }
        return this;
    }

    @Override
    public boolean isStarted() {
        return this.model.isStarted();
    }

    @Override
    public boolean isCanceled() {
        return this.model.isCancelled();
    }

    @Override
    public void reset() {
        ArrayList<String> props = new ArrayList<String>();
        if (this.isStarted()) {
            this.model.setStarted(false);
            props.add("started");
        }
        if (this.isCanceled()) {
            this.model.setCancelled(false);
            props.add("canceled");
        }
        if (this.isCompleted()) {
            this.model.setCompleted(false);
            props.add("completed");
        }
        if (this.isSuspended()) {
            this.model.setSuspended(false);
            props.add("suspended");
        }
        if (this.isBlocked()) {
            this.model.setBlocked(false);
            props.add("blocked");
        }
        if (!props.isEmpty()) {
            String property = String.join((CharSequence)",", props);
            this.model.getChronometer().reset();
            this.fireEvent(NProgressEventType.RESET, property, null);
        }
    }

    @Override
    public String getId() {
        return this.model.getId();
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    protected void setName(String name) {
        String old = this.model.getName();
        if (!Objects.equals(old, name)) {
            this.model.setName(name);
            this.fireEvent(NProgressEventType.UPDATE, "name", old);
        }
    }

    @Override
    public NMsg getDescription() {
        return this.model.getDescription();
    }

    protected NProgressMonitor setDescription(NMsg desc) {
        NMsg old = this.model.getDescription();
        if (!Objects.equals(old, desc)) {
            this.model.setDescription(desc);
            this.fireEvent(NProgressEventType.UPDATE, "description", old);
        }
        return this;
    }

    @Override
    public NProgressMonitor addListener(NProgressListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public NProgressMonitor removeListener(NProgressListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public NProgressListener[] getListeners() {
        return this.listeners.toArray(new NProgressListener[0]);
    }

    @Override
    public NDuration getDuration() {
        return this.model.getChronometer().getDuration();
    }

    @Override
    public NClock getStartClock() {
        return this.model.getChronometer().getStartClock();
    }

    @Override
    public final NProgressMonitor setMessage(NMsg message) {
        NMsg old = this.getMessage();
        if (this.setMessage0(message)) {
            this.fireEvent(NProgressEventType.MESSAGE, "message", old);
        }
        return this;
    }

    @Override
    public NMsg getMessage() {
        return this.model.getMessage();
    }

    @Override
    public boolean isIndeterminate() {
        return Double.isNaN(this.model.getProgress());
    }

    @Override
    public double getProgress() {
        return this.model.getProgress();
    }

    private final boolean setMessageIfNotNull(NMsg message) {
        if (message != null) {
            return this.setMessage0(message);
        }
        return false;
    }

    private final boolean setMessage0(NMsg message) {
        NMsg newMessage;
        NMsg nMsg = newMessage = message == null ? EMPTY_MESSAGE : message;
        if (!Objects.equals(this.getMessage(), newMessage)) {
            this.model.setMessage(newMessage);
            return true;
        }
        return false;
    }

    private void fireEvent(NProgressEventType state, String propertyName, Object oldValue) {
        this.spi.onEvent(new DefaultNProgressHandlerEvent(state, propertyName, this.model, NSession.of()));
        block4: for (NProgressListener listener : this.getListeners()) {
            switch (state) {
                case START: {
                    listener.onProgress(NProgressEvent.ofStart(null, this.getMessage(), -1L));
                    continue block4;
                }
                case COMPLETE: {
                    listener.onProgress(NProgressEvent.ofComplete(null, this.getMessage(), this.model.getGlobalCount(), this.model.getGlobalDurationNanos(), this.model.getProgress(), this.model.getPartialCount(), this.model.getPartialDurationNanos(), this.model.getLength(), this.model.getException()));
                    continue block4;
                }
                default: {
                    listener.onProgress(NProgressEvent.ofProgress(null, this.getMessage(), this.model.getGlobalCount(), this.model.getGlobalDurationNanos(), this.model.getProgress(), this.model.getPartialCount(), this.model.getPartialDurationNanos(), this.model.getLength(), this.model.getException()));
                }
            }
        }
    }

    @Override
    public final NProgressMonitor setProgress(double progress) {
        double oldProgress;
        if (!this.isStarted()) {
            this.start();
        }
        if (this.isCanceled()) {
            return this;
        }
        if (this.isCompleted()) {
            if (progress < 1.0) {
                this.undoComplete();
            } else {
                return this;
            }
        }
        if (this.isSuspended()) {
            while (this.isSuspended()) {
                NWorkspaceProfilerImpl.sleep(500L, "DefaultProgressMonitor::setProgress/Suspended");
            }
        }
        if ((progress < 0.0 || progress > 1.0) && !Double.isNaN(progress)) {
            if (this.strictComputationMonitor) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid Progress value [0..1] : %s", progress));
            }
            if (progress < 0.0) {
                progress = 0.0;
            } else if (progress > 1.0) {
                progress = 1.0;
            }
        }
        if ((oldProgress = this.getProgress()) != progress) {
            this.model.setProgress(progress);
            this.fireEvent(NProgressEventType.PROGRESS, "progress", oldProgress);
        }
        if (progress >= 1.0 && !this.isCompleted()) {
            this.complete();
        }
        return this;
    }

    @Override
    public final NProgressMonitor setProgress(long i, long max) {
        return this.setProgress(i, max, null);
    }

    @Override
    public final NProgressMonitor setProgress(long i, long max, NMsg message) {
        return this.setProgress(1.0 * (double)i / (double)max, message);
    }

    @Override
    public final NProgressMonitor setProgress(long i, long maxi, long j, long maxj) {
        return this.setProgress(i, maxi, j, maxj, null);
    }

    @Override
    public final NProgressMonitor setProgress(long i, long j, long maxi, long maxj, NMsg message) {
        return this.setProgress((1.0 * (double)i * (double)maxi + (double)j) / (double)(maxi * maxj), message);
    }

    @Override
    public final NProgressMonitor inc() {
        this.inc(null);
        return this;
    }

    @Override
    public final NProgressMonitor inc(NMsg message) {
        NProgressMonitorInc incrementor = this.incrementor;
        NAssert.requireNonNull(incrementor, "incrementor");
        double oldProgress = this.getProgress();
        double newProgress = incrementor.inc(oldProgress);
        this.setProgress(newProgress, message);
        return this;
    }

    @Override
    public final NDuration getEstimatedTotalDuration() {
        double d = this.getProgress();
        NDuration spent = this.getDuration();
        if (spent == null) {
            return null;
        }
        return spent.mul(1.0 / d);
    }

    @Override
    public final NDuration getEstimatedRemainingDuration() {
        double d = this.getProgress();
        NDuration spent = this.getDuration();
        if (spent == null) {
            return null;
        }
        double d2 = (1.0 - d) / d;
        return spent.mul(d2);
    }

    @Override
    public NProgressMonitor setIndeterminate() {
        return this.setIndeterminate(null);
    }

    @Override
    public NProgressMonitor setIndeterminate(NMsg message) {
        return this.setProgress(Double.NaN, message);
    }

    public DefaultProgressMonitor setIncrementor(NProgressMonitorInc incrementor) {
        this.incrementor = incrementor;
        return this;
    }

    public NProgressMonitorInc getIncrementor() {
        return this.incrementor;
    }

    public NProgressHandler getSpi() {
        return this.spi;
    }

    @Override
    public NProgressMonitor translate(long index, long max) {
        return new DefaultProgressMonitor(null, new ProgressMonitorTranslator(this, 1.0 / (double)max, (double)index * (1.0 / (double)max)), null);
    }

    @Override
    public NProgressMonitor translate(long i, long imax, long j, long jmax) {
        return new DefaultProgressMonitor(null, new ProgressMonitorTranslator(this, 1.0 / (double)(imax * jmax), (1.0 * (double)i * (double)imax + (double)j) / (double)(imax * jmax)), null);
    }

    @Override
    public NProgressMonitor stepInto(NMsg message) {
        NProgressMonitorInc incrementor = this.getIncrementor();
        NAssert.requireNonNull(incrementor, "incrementor");
        double a = this.getProgress();
        double b = incrementor.inc(a);
        if (message != null) {
            this.setMessage(message);
        }
        return this.translate(b - a, a);
    }

    @Override
    public NProgressMonitor stepInto(long index, long max) {
        return this.translate(1.0 / (double)max, (double)index * (1.0 / (double)max));
    }

    @Override
    public NProgressMonitor temporize(long freq) {
        return new DefaultProgressMonitor(null, new FreqProgressHandler(this, freq), null);
    }

    @Override
    public NProgressMonitor incremental(long iterations) {
        this.setIncrementor(new LongIterationProgressMonitorInc(iterations));
        return this;
    }

    @Override
    public NProgressMonitor incremental(double delta) {
        this.setIncrementor(new DeltaProgressMonitorInc(delta));
        return this;
    }

    @Override
    public NProgressMonitor translate(double factor, double start) {
        return new DefaultProgressMonitor(null, new ProgressMonitorTranslator(this, factor, start), null);
    }

    @Override
    public NProgressMonitor[] split(int nbrElements) {
        double[] dd = new double[nbrElements];
        Arrays.fill(dd, 1.0);
        return this.split(dd);
    }

    @Override
    public NProgressMonitor[] split(double ... weight) {
        boolean enabledElement;
        int i;
        NProgressMonitor[] all = new NProgressMonitor[weight.length];
        double[] coeffsOffsets = new double[weight.length];
        double[] xweight = new double[weight.length];
        double coeffsSum = 0.0;
        for (int i2 = 0; i2 < weight.length; ++i2) {
            if (!(weight[i2] > 0.0)) continue;
            coeffsSum += weight[i2];
        }
        double coeffsOffset = 0.0;
        for (i = 0; i < weight.length; ++i) {
            boolean bl = enabledElement = weight[i] > 0.0;
            if (!enabledElement) continue;
            coeffsOffsets[i] = coeffsOffset;
            xweight[i] = weight[i] / coeffsSum;
            coeffsOffset += xweight[i];
        }
        for (i = 0; i < weight.length; ++i) {
            enabledElement = weight[i] > 0.0;
            all[i] = enabledElement ? this.translate(xweight[i], coeffsOffsets[i]) : NProgressMonitors.of().ofSilent();
        }
        return all;
    }

    @Override
    public boolean isSilent() {
        return this.getSpi() instanceof SilentProgressHandler;
    }
}

