/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.idresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;

public class NMetaInfIdResolver {
    public NId[] resolvePomIds(NPath baseUrl) {
        return this.resolvePomIds(baseUrl, null);
    }

    public NId[] resolvePomIds(NPath baseUrl, String referenceResourcePath) {
        NId id;
        URLPart[] children;
        ArrayList<NId> all = new ArrayList<NId>();
        URLPart aa = URLPart.of(baseUrl.toURL().get());
        String basePath = aa.getPath().substring(0, aa.getPath().length() - (referenceResourcePath == null ? 0 : referenceResourcePath.length()));
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        URLPart p = aa.rootSibling(basePath + "META-INF/nuts");
        int beforeSize = all.size();
        for (URLPart url : children = p.getChildren(false, true, new NJsonURLFilter())) {
            if (url == null) continue;
            try (InputStream is = url.getInputStream();){
                NDescriptor d = NDescriptorParser.of().parse(is).get();
                id = d.getId();
                if (id == null || id.getVersion() == null || id.getVersion().isBlank()) continue;
                all.add(id);
            }
            catch (Exception ex) {
                NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse pom file %s : %s", url, ex).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
            }
        }
        for (URLPart url : children = p.getChildren(false, true, new NPropsURLFilter())) {
            if (url == null) continue;
            try {
                Properties prop = new Properties();
                try (InputStream is22 = url.getInputStream();){
                    prop.load(is22);
                }
                catch (IOException is22) {
                    // empty catch block
                }
                String version = prop.getProperty("id");
                if (NBlankable.isBlank(version) || (id = NId.get(version).orNull()) == null || id.getVersion() == null || id.getVersion().isBlank()) continue;
                all.add(id);
            }
            catch (Exception ex) {
                NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse pom file %s : %s", url, ex).asFineAlert());
            }
        }
        if (beforeSize == all.size() && basePath.endsWith("/target/classes/")) {
            String string = basePath.substring(0, basePath.length() - "/target/classes/".length()) + "/pom.xml";
        }
        return all.toArray(new NId[0]);
    }

    public NId[] resolvePomIds(Class clazz) {
        Class s;
        ArrayList<NId> all = new ArrayList<NId>();
        try {
            String n = clazz.getName().replace('.', '/').concat(".class");
            Enumeration<URL> r = clazz.getClassLoader().getResources(n);
            for (URL url : Collections.list(r)) {
                all.addAll(Arrays.asList(this.resolvePomIds(NPath.of(url), n)));
            }
        }
        catch (IOException ex) {
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("failed to parse class %s : %s", clazz.getName(), ex).asFinestAlert());
        }
        if (all.isEmpty() && JavaClassUtils.isCGLib(clazz) && (s = JavaClassUtils.unwrapCGLib(clazz)) != null) {
            return this.resolvePomIds(s);
        }
        return all.toArray(new NId[0]);
    }

    public NPomId resolvePomId(Class clazz, String groupId, String artifactId, String defaultValue) {
        String ver = this.resolvePomVersion(clazz, groupId, artifactId, defaultValue);
        return new NPomId(groupId, artifactId, ver);
    }

    public String resolvePomVersion(String groupId, String artifactId, String defaultValue) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(url.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public String resolvePomVersion(Class clazz, String groupId, String artifactId, String defaultValue) {
        URL url = clazz.getClassLoader().getResource("META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        if (url != null) {
            Properties p = new Properties();
            try {
                p.load(url.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String version = p.getProperty("version");
            if (version != null && version.trim().length() != 0) {
                return version;
            }
        }
        return defaultValue;
    }

    public NPomId resolvePropertiesPomId(InputStream stream) {
        Properties prop = new Properties();
        try {
            prop.load(stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String version = prop.getProperty("version");
        String groupId = prop.getProperty("groupId");
        String artifactId = prop.getProperty("artifactId");
        if (version != null && version.trim().length() != 0) {
            return new NPomId(groupId, artifactId, version);
        }
        return null;
    }

    public NPomId[] resolveJarPomIds(InputStream jarStream) throws IOException {
        final ArrayList list = new ArrayList();
        this.visitZipStream(jarStream, new InputStreamVisitor(){

            @Override
            public boolean visit(String path, InputStream inputStream) {
                NPomId id;
                if (path.startsWith("META-INF/") && path.endsWith("/pom.properties") && (id = NMetaInfIdResolver.this.resolvePropertiesPomId(inputStream)) != null) {
                    list.add(new NPomId(id.getGroupId(), id.getArtifactId(), id.getVersion()));
                }
                return true;
            }
        });
        return list.toArray(new NPomId[0]);
    }

    public NPomId resolveJarPomId(InputStream jarStream) throws IOException {
        NPomId[] v = this.resolveJarPomIds(jarStream);
        if (v.length == 0) {
            return null;
        }
        if (v.length >= 2) {
            throw new IllegalArgumentException("too many Ids");
        }
        return v[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitZipStream(InputStream zipFile, InputStreamVisitor visitor) throws IOException {
        try (ZipInputStream zis = null;){
            zis = new ZipInputStream(zipFile);
            ZipEntry ze = zis.getNextEntry();
            final ZipInputStream finalZis = zis;
            InputStream entryInputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return finalZis.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return finalZis.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return finalZis.read(b, off, len);
                }

                @Override
                public void close() throws IOException {
                    finalZis.closeEntry();
                }
            };
            while (ze != null) {
                String fileName = ze.getName();
                if (!fileName.endsWith("/") && !visitor.visit(fileName, entryInputStream)) {
                    break;
                }
                ze = zis.getNextEntry();
            }
        }
        return false;
    }

    private static class NJsonURLFilter
    implements Predicate<URLPart> {
        @Override
        public boolean test(URLPart path) {
            return path.getName().equals("nuts.json");
        }
    }

    private static class NPropsURLFilter
    implements Predicate<URLPart> {
        @Override
        public boolean test(URLPart path) {
            return path.getName().equals("nuts.properties");
        }
    }

    private static interface InputStreamVisitor {
        public boolean visit(String var1, InputStream var2) throws IOException;
    }
}

