/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.glob;

import java.io.File;
import java.util.regex.Pattern;
import net.thevpc.nuts.expr.NGlob;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNGlob
implements NGlob {
    private String separator = File.separator;

    @Override
    public String getSeparator() {
        return this.separator;
    }

    @Override
    public NGlob setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public boolean isGlob(String pattern) {
        if (pattern == null) {
            return false;
        }
        for (char c : pattern.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '[': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Pattern toPattern(String pattern) {
        if (NBlankable.isBlank(pattern)) {
            return GlobUtils.PATTERN_ALL;
        }
        return GlobUtils.glob(pattern, this.getSeparator());
    }

    @Override
    public String toPatternString(String pattern) {
        if (NBlankable.isBlank(pattern)) {
            return ".*";
        }
        return GlobUtils.globString(pattern, this.getSeparator());
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

