/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr.template;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.ProcessStreamContext;
import net.thevpc.nuts.runtime.standalone.xtra.expr.template.TagNode;
import net.thevpc.nuts.util.NBlankable;

class ForTagNode
extends TagNode {
    private String expr;
    private VarLoopInfo varLoopInfo;
    TagNode body;
    private static String WN = "[a-zA-Z][a-zA-Z0-9_]*";
    static Pattern forVarPattern = Pattern.compile("(?<varName>" + WN + ")\\s*(,\\s*(?<indexName>" + WN + "))?\\s*:(?<any>.*)");

    public ForTagNode(String expr) {
        this.expr = expr.trim();
        Matcher m1 = forVarPattern.matcher(expr.trim());
        if (!m1.matches()) {
            throw new IllegalArgumentException("for expression must be like  \":for <var>:<expr>\" or :for <init>,<cond>,<inc>");
        }
        this.varLoopInfo = new VarLoopInfo(m1.group("varName"), m1.group("indexName"), m1.group("any"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(ProcessStreamContext ctx) throws IOException {
        if (this.varLoopInfo == null) return;
        final Object o = ctx.eval(this.varLoopInfo.iterableExpr);
        Iterator it = null;
        if (o != null) {
            if (o.getClass().isArray()) {
                final int len = Array.getLength(o);
                it = new Iterator(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < len;
                    }

                    public Object next() {
                        Object v = Array.get(o, this.i);
                        ++this.i;
                        return v;
                    }
                };
            } else if (o instanceof Iterator) {
                it = (Iterator)o;
            } else {
                if (!(o instanceof Iterable)) throw new IllegalArgumentException("not iterable " + this.varLoopInfo.iterableExpr + " as " + o.getClass());
                it = ((Iterable)o).iterator();
            }
        } else {
            it = Collections.emptyIterator();
        }
        int index = 0;
        while (it.hasNext()) {
            Object v = it.next();
            ctx.setVar(this.varLoopInfo.varName, v);
            if (!NBlankable.isBlank(this.varLoopInfo.indexName)) {
                ctx.setVar(this.varLoopInfo.indexName, index);
            }
            if (this.body != null) {
                this.body.run(ctx);
            }
            ++index;
        }
    }

    public String toString() {
        return "For{, expr='" + this.expr + '\'' + ", varLoopInfo=" + this.varLoopInfo + ", body=" + this.body + '}';
    }

    private static class VarLoopInfo {
        String varName;
        String indexName;
        String iterableExpr;

        public VarLoopInfo(String varName, String indexName, String iterableExpr) {
            this.varName = varName;
            this.indexName = indexName;
            this.iterableExpr = iterableExpr;
        }
    }
}

