/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprOpAssociativity;
import net.thevpc.nuts.expr.NExprOpDeclaration;
import net.thevpc.nuts.expr.NExprOpNode;
import net.thevpc.nuts.expr.NExprOpType;
import net.thevpc.nuts.expr.NToken;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultFunctionNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultIfNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultLiteralNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultNExprInterpolatedStrNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultOpNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.DefaultWordNode;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NExprWithCache;
import net.thevpc.nuts.runtime.standalone.xtra.expr.NTokenIterator;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class SyntaxParser {
    NTokenIterator tokens;
    NExprWithCache withCache;

    public SyntaxParser(String anyStr, NExprWithCache withCache) {
        this(new NTokenIterator(new StringReader(anyStr == null ? "" : anyStr)), withCache);
    }

    public SyntaxParser(NTokenIterator tokens, NExprWithCache withCache) {
        this.tokens = tokens;
        this.withCache = withCache;
    }

    public NOptional<NExprNode> parse() {
        NOptional<NExprNode> e = this.nextExpr();
        if (!e.isPresent()) {
            return e;
        }
        NToken peeked = this.peekSkipSpace();
        if (peeked != null) {
            return NOptional.ofError(() -> NMsg.ofC("unexpected token %s, after reading %s", peeked, e.get()));
        }
        return e;
    }

    private NOptional<NExprNode> nextExpr() {
        return this.nextNonTerminal(0);
    }

    String opName(NToken t) {
        if (t == null) {
            return null;
        }
        switch (t.ttype) {
            case -18: 
            case -17: 
            case -15: 
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: 
            case -1: 
            case 10: 
            case 40: 
            case 41: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return null;
            }
        }
        String s = t.sval;
        if (s == null) {
            s = String.valueOf((char)t.ttype);
        }
        return s;
    }

    boolean isCloseParStart(NToken t, int ttype) {
        if (t == null) {
            return false;
        }
        switch (ttype) {
            case 40: {
                return t.ttype == 41;
            }
            case 91: {
                return t.ttype == 93;
            }
            case 123: {
                return t.ttype == 125;
            }
        }
        return false;
    }

    boolean isNonTerminalIf(NToken t) {
        if (t == null) {
            return false;
        }
        return "if".equals(t.sval);
    }

    boolean isOpenParStart(NToken t) {
        if (t == null) {
            return false;
        }
        switch (t.ttype) {
            case 40: 
            case 91: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    boolean isOpenPar(NToken t, NExprOpType opType) {
        if (t == null) {
            return false;
        }
        switch (t.ttype) {
            case 40: 
            case 91: 
            case 123: {
                return this.withCache.getOp(t, opType) != null;
            }
        }
        return false;
    }

    boolean isOpIgnoresMissingSecondOperand(NToken t, NExprOpType opType) {
        if (t == null) {
            return false;
        }
        switch (t.ttype) {
            case 59: {
                return true;
            }
        }
        return false;
    }

    private boolean isInfixOpZipped(String name, String uniformName) {
        if (name == null) {
            return false;
        }
        switch (name) {
            case ";": {
                return true;
            }
        }
        return false;
    }

    boolean isOpAcceptsMissingSecondOperand(NToken t, NExprOpType opType) {
        if (t == null) {
            return false;
        }
        return false;
    }

    private NOptional<NExprNode> nextNonTerminalIf() {
        NToken t = this.peekSkipSpace();
        if (t == null) {
            return NOptional.ofError(() -> NMsg.ofPlain("expected if"));
        }
        if (!this.isNonTerminalIf(t)) {
            return NOptional.ofError(() -> NMsg.ofPlain("expected if"));
        }
        NToken startPar = this.tokens.next();
        NOptional<NExprNode> cond = this.nextExpr();
        if (cond.isNotPresent()) {
            return NOptional.ofNamedEmpty("condition for if statement");
        }
        NOptional<NExprNode> trueNode = this.nextExpr();
        if (cond.isNotPresent()) {
            return NOptional.ofNamedEmpty("true statement for if statement");
        }
        t = this.peekSkipSpace();
        if (t != null && "else".equals(t.sval)) {
            this.tokens.next();
            t = this.peekSkipSpace();
            if (t != null) {
                NOptional<NExprNode> falseNode = this.nextExpr();
                if (falseNode.isNotPresent()) {
                    return NOptional.ofNamedEmpty("false statement for if statement");
                }
                return NOptional.of(new DefaultIfNode(cond.get(), trueNode.get(), falseNode.get()));
            }
            return NOptional.ofError(() -> NMsg.ofPlain("expected else statement"));
        }
        return NOptional.of(new DefaultIfNode(cond.get(), trueNode.get(), null));
    }

    private NToken peekSkipSpace() {
        NToken t;
        while ((t = this.tokens.peek()) != null) {
            if (t.ttype != -17) {
                return t;
            }
            this.tokens.next();
        }
        return null;
    }

    private NOptional<NExprNode> nextTerminalOrStmt() {
        NToken t = this.peekSkipSpace();
        if (t == null) {
            return NOptional.ofError(() -> NMsg.ofPlain("expected non terminal"));
        }
        if (this.isNonTerminalIf(t)) {
            return this.nextNonTerminalIf();
        }
        return this.nextTerminal();
    }

    private NOptional<NExprNode> _nextOpenPar(NToken t) {
        if (this.isOpenParStart(t)) {
            NToken startPar = this.tokens.next();
            NToken p2 = this.peekSkipSpace();
            if (p2 == null) {
                NToken finalT = t;
                return NOptional.ofError(() -> NMsg.ofPlain("expected closing " + finalT.sval));
            }
            if (this.isCloseParStart(p2, t.ttype)) {
                this.tokens.next();
                return NOptional.of(new DefaultOpNode(t.sval, t.sval + p2.sval, NExprOpType.PREFIX, -1, new ArrayList<NExprNode>()));
            }
            ArrayList<NExprNode> args = new ArrayList<NExprNode>();
            NOptional<NExprNode> e = this.nextExpr();
            if (!e.isPresent()) {
                return e;
            }
            args.add(e.get());
            while (true) {
                if ((p2 = this.peekSkipSpace()) == null) {
                    NToken finalT = t;
                    return NOptional.ofError(() -> NMsg.ofPlain("expected closing " + finalT.sval));
                }
                if (this.isCloseParStart(p2, t.ttype)) {
                    this.tokens.next();
                    return NOptional.of(new DefaultOpNode(t.sval, t.sval + p2.sval, NExprOpType.PREFIX, -1, args));
                }
                if (!p2.sval.equals(",")) break;
                this.tokens.next();
                e = this.nextExpr();
                if (!e.isPresent()) {
                    return e;
                }
                args.add(e.get());
            }
            return NOptional.ofError(() -> NMsg.ofPlain("expected ','"));
        }
        return null;
    }

    private NOptional<NExprNode> _nextPrefixOp(NToken t, int precedence) {
        NExprOpDeclaration op = this.withCache.getOp(t, NExprOpType.PREFIX);
        if (op != null && op.getPrecedence() >= precedence) {
            this.tokens.next();
            NOptional<NExprNode> q = this.nextNonTerminal(precedence);
            if (q.isEmpty()) {
                return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
            }
            if (q.isError()) {
                return q;
            }
            return NOptional.of(new DefaultOpNode(t.image, this.opName(t), NExprOpType.PREFIX, op.getPrecedence(), Arrays.asList(q.get())));
        }
        return this.nextTerminalOrStmt();
    }

    private NOptional<NExprNode> _nextPostfixOp(NOptional<NExprNode> first, int precedence) {
        NToken t;
        while ((t = this.peekSkipSpace()) != null) {
            if (this.isOpenPar(t, NExprOpType.POSTFIX)) {
                NOptional<NExprNode> e = this.nextTerminalOrStmt();
                NOptional<NExprNode> finalFirst = first;
                NToken finalInfixOp = t;
                first = e.map(x -> {
                    ArrayList<NExprNode> cc = new ArrayList<NExprNode>();
                    cc.add((NExprNode)finalFirst.get());
                    cc.addAll(x.getChildren());
                    String opName = "()";
                    switch (finalInfixOp.ttype) {
                        case 91: {
                            opName = "[]";
                            break;
                        }
                        case 40: {
                            opName = "()";
                            break;
                        }
                        case 123: {
                            opName = "{}";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unsupported");
                        }
                    }
                    return new DefaultOpNode(finalInfixOp.sval, opName, NExprOpType.POSTFIX, -1, cc);
                });
                continue;
            }
            NExprOpDeclaration op = this.withCache.getOp(t, NExprOpType.POSTFIX);
            if (op == null || op.getPrecedence() < precedence) break;
            this.tokens.next();
            first = NOptional.of(new DefaultOpNode(t.sval, this.opName(t), NExprOpType.POSTFIX, op.getPrecedence(), Arrays.asList(first.get())));
        }
        return first;
    }

    private NOptional<NExprNode> nextNonTerminal(int precedence) {
        NOptional<NExprNode> v;
        NToken t = this.peekSkipSpace();
        if (t == null) {
            return NOptional.ofError(() -> NMsg.ofPlain("expected non terminal"));
        }
        NOptional<NExprNode> first = null;
        if (precedence == 0 && (v = this._nextOpenPar(t)) != null && (first = v) != null) {
            if (first.isEmpty()) {
                return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
            }
            if (first.isError()) {
                return first;
            }
        }
        if (first == null) {
            first = this._nextPrefixOp(t, precedence);
            if (first.isEmpty()) {
                return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
            }
            if (first.isError()) {
                return first;
            }
        }
        if ((first = this._nextInfixOp(first, precedence)).isError()) {
            return first;
        }
        return this._nextPostfixOp(first, precedence);
    }

    private NOptional<NExprNode> _nextInfixOp(NOptional<NExprNode> first, int precedence) {
        NExprOpDeclaration op;
        NToken infixOp;
        while ((infixOp = this.peekSkipSpace()) != null && (op = this.withCache.getOp(infixOp, NExprOpType.INFIX)) != null && op.getPrecedence() >= precedence) {
            NOptional<NExprNode> q;
            this.tokens.next();
            int nextPrecedence = op.getPrecedence();
            if (op.getAssociativity() == NExprOpAssociativity.LEFT) {
                --nextPrecedence;
            }
            if ((q = this.nextNonTerminal(nextPrecedence)).isEmpty()) {
                if (this.isOpIgnoresMissingSecondOperand(infixOp, NExprOpType.INFIX)) continue;
                if (this.isOpAcceptsMissingSecondOperand(infixOp, NExprOpType.INFIX)) {
                    first = NOptional.of(this.createInfixOpNodeOrCombine(infixOp.sval, this.opName(infixOp), op.getPrecedence(), first.get(), null));
                    continue;
                }
                return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
            }
            if (q.isError()) {
                if (this.isOpIgnoresMissingSecondOperand(infixOp, NExprOpType.INFIX)) continue;
                if (this.isOpAcceptsMissingSecondOperand(infixOp, NExprOpType.INFIX)) {
                    first = NOptional.of(this.createInfixOpNodeOrCombine(infixOp.sval, this.opName(infixOp), op.getPrecedence(), first.get(), null));
                    continue;
                }
                return q;
            }
            first = NOptional.of(this.createInfixOpNodeOrCombine(infixOp.sval, this.opName(infixOp), op.getPrecedence(), first.get(), q.get()));
        }
        return first;
    }

    private NExprOpNode createInfixOpNodeOrCombine(String name, String uniformName, int precedence, NExprNode a, NExprNode b) {
        if (this.isInfixOpZipped(name, uniformName) && (a != null && a.getName().equals(name) || b != null && b.getName().equals(name))) {
            ArrayList<NExprNode> aa = new ArrayList<NExprNode>();
            if (a != null && a.getName().equals(name)) {
                aa.addAll(a.getChildren());
            } else {
                aa.add(a);
            }
            if (b != null && b.getName().equals(name)) {
                aa.addAll(b.getChildren());
            } else {
                aa.add(b);
            }
            return new DefaultOpNode(name, uniformName, NExprOpType.INFIX, precedence, aa);
        }
        return new DefaultOpNode(name, uniformName, NExprOpType.INFIX, precedence, new ArrayList<NExprNode>(Arrays.asList(a, b)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NOptional<NExprNode> nextTerminal() {
        NToken t = this.peekSkipSpace();
        if (t == null) {
            return NOptional.ofEmpty(() -> NMsg.ofPlain("expected terminal"));
        }
        switch (t.ttype) {
            case 40: {
                NToken t0 = t;
                this.tokens.next();
                t = this.peekSkipSpace();
                ArrayList<NExprNode> all = new ArrayList<NExprNode>();
                if (t.ttype == 41) {
                    t = this.tokens.next();
                    return NOptional.of(new DefaultOpNode(t0.sval, "(", NExprOpType.PREFIX, -1, all));
                } else {
                    while (true) {
                        NOptional<NExprNode> e;
                        if ((e = this.nextExpr()).isEmpty()) {
                            return NOptional.ofError(() -> NMsg.ofPlain("empty expression"));
                        }
                        all.add(e.get());
                        t = this.peekSkipSpace();
                        if (t.ttype == 41) {
                            t = this.tokens.next();
                            return NOptional.of(new DefaultOpNode(t0.sval, "(", NExprOpType.PREFIX, -1, all));
                        }
                        if (t.ttype != 44) return NOptional.ofError(() -> NMsg.ofPlain("expected ',' or ')'"));
                        this.tokens.next();
                    }
                }
            }
            case 91: {
                NToken t0 = t;
                this.tokens.next();
                t = this.peekSkipSpace();
                ArrayList<NExprNode> all = new ArrayList<NExprNode>();
                if (t.ttype == 93) {
                    t = this.tokens.next();
                    return NOptional.of(new DefaultOpNode(t0.sval, "[", NExprOpType.PREFIX, -1, all));
                } else {
                    while (true) {
                        NOptional<NExprNode> e;
                        if ((e = this.nextExpr()).isEmpty()) {
                            return NOptional.ofError(() -> NMsg.ofPlain("empty expression"));
                        }
                        all.add(e.get());
                        t = this.peekSkipSpace();
                        if (t.ttype == 93) {
                            t = this.tokens.next();
                            return NOptional.of(new DefaultOpNode(t0.sval, "[", NExprOpType.PREFIX, -1, all));
                        }
                        if (t.ttype != 44) return NOptional.ofError(() -> NMsg.ofPlain("expected ',' or ']'"));
                        this.tokens.next();
                    }
                }
            }
            case 123: {
                NToken t0 = t;
                this.tokens.next();
                t = this.peekSkipSpace();
                ArrayList<NExprNode> all = new ArrayList<NExprNode>();
                if (t.ttype == 125) {
                    t = this.tokens.next();
                    return NOptional.of(new DefaultOpNode(t0.sval, "{", NExprOpType.PREFIX, -1, all));
                } else {
                    while (true) {
                        NOptional<NExprNode> e;
                        if ((e = this.nextExpr()).isEmpty()) {
                            return NOptional.ofError(() -> NMsg.ofPlain("empty expression"));
                        }
                        all.add(e.get());
                        t = this.peekSkipSpace();
                        if (t.ttype == 125) {
                            t = this.tokens.next();
                            return NOptional.of(new DefaultOpNode(t0.sval, "{", NExprOpType.PREFIX, -1, all));
                        }
                        if (t.ttype != 44) return NOptional.ofError(() -> NMsg.ofPlain("expected ',' or '}'"));
                        this.tokens.next();
                    }
                }
            }
            case -3: {
                String n = t.sval;
                this.tokens.next();
                t = this.peekSkipSpace();
                if (t == null || t.ttype != 40) return NOptional.of(new DefaultWordNode(n));
                ArrayList<NExprNode> functionParams = new ArrayList<NExprNode>();
                this.tokens.next();
                t = this.peekSkipSpace();
                if (t.ttype == 41) {
                    this.tokens.next();
                    return NOptional.of(new DefaultFunctionNode(n, functionParams.toArray(new NExprNode[0])));
                } else {
                    NOptional<NExprNode> e = this.nextExpr();
                    if (e.isEmpty()) {
                        return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
                    }
                    if (e.isError()) {
                        return e;
                    }
                    functionParams.add(e.get());
                    while ((t = this.peekSkipSpace()) != null) {
                        if (t.ttype == 41) {
                            this.tokens.next();
                            return NOptional.of(new DefaultFunctionNode(n, functionParams.toArray(new NExprNode[0])));
                        }
                        if (t.ttype != 44) return NOptional.ofError(() -> NMsg.ofPlain("expected ',' or ')'"));
                        this.tokens.next();
                        e = this.nextExpr();
                        if (e.isEmpty()) {
                            return NOptional.ofError(() -> NMsg.ofPlain("expected expression"));
                        }
                        if (e.isError()) {
                            return e;
                        }
                        functionParams.add(e.get());
                    }
                }
                return NOptional.of(new DefaultFunctionNode(n, functionParams.toArray(new NExprNode[0])));
            }
            case -15: 
            case -14: 
            case -13: 
            case -12: 
            case -11: 
            case -10: {
                this.tokens.next();
                return NOptional.of(new DefaultLiteralNode(t.nval));
            }
            case -18: {
                this.tokens.next();
                if (t.image.charAt(0) != '$') return NOptional.of(new DefaultLiteralNode(t.sval));
                return NOptional.of(new DefaultNExprInterpolatedStrNode(t.sval));
            }
        }
        NToken ftok = t;
        return NOptional.ofError(() -> NMsg.ofC("unsupported %s", ftok));
    }
}

