/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.expr;

import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.expr.NExprDeclarations;
import net.thevpc.nuts.expr.NExprLiteralNode;
import net.thevpc.nuts.expr.NExprNode;
import net.thevpc.nuts.expr.NExprNodeType;
import net.thevpc.nuts.util.NOptional;

public class DefaultLiteralNode
implements NExprLiteralNode {
    private final Object lit;

    @Override
    public NExprNodeType getType() {
        return NExprNodeType.LITERAL;
    }

    @Override
    public Object getValue() {
        return this.lit;
    }

    @Override
    public List<NExprNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public String getName() {
        return null;
    }

    public DefaultLiteralNode(Object lit) {
        this.lit = lit;
    }

    @Override
    public NOptional<Object> eval(NExprDeclarations context) {
        return NOptional.ofNullable(this.lit);
    }

    public String toString() {
        if (this.lit == null) {
            return "null";
        }
        if (this.lit instanceof String) {
            StringBuilder sb = new StringBuilder("\"");
            block6: for (char c : this.lit.toString().toCharArray()) {
                switch (c) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block6;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append("\"");
            return sb.toString();
        }
        return String.valueOf(this.lit);
    }
}

