/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.execentries;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.app.NAppDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NLibPaths;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.NPomXmlParser;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.pom.api.NPomId;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaJarUtils;
import net.thevpc.nuts.runtime.standalone.xtra.idresolver.NMetaInfIdResolver;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNLibPaths
implements NLibPaths {
    private final NWorkspace workspace;

    public DefaultNLibPaths(NWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public List<NExecutionEntry> parseExecutionEntries(NPath file) {
        if (file.getName().toLowerCase().endsWith(".jar")) {
            List<NExecutionEntry> list;
            block18: {
                InputStream in = file.getInputStream();
                try {
                    list = this.parseExecutionEntries(in, "jar", file.toAbsolute().normalize().toString());
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                in.close();
            }
            return list;
        }
        if (file.getName().toLowerCase().endsWith(".class")) {
            List<NExecutionEntry> list;
            block19: {
                InputStream in = file.getInputStream();
                try {
                    list = this.parseExecutionEntries(in, "class", file.toAbsolute().normalize().toString());
                    if (in == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                in.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<NExecutionEntry> parseExecutionEntries(InputStream inputStream, String type, String sourceName) {
        if ("jar".equals(type)) {
            return JavaJarUtils.parseJarExecutionEntries(inputStream);
        }
        if ("class".equals(type)) {
            NExecutionEntry u = JavaClassUtils.parseClassExecutionEntry(inputStream, sourceName);
            return u == null ? Collections.emptyList() : Arrays.asList(u);
        }
        return Collections.emptyList();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public List<NPath> resolveLibPaths(Class<?> clazz) {
        return JavaClassUtils.resolveURLs(clazz).stream().map(x -> NPath.of(x)).collect(Collectors.toList());
    }

    @Override
    public NOptional<NPath> resolveLibPath(Class<?> clazz) {
        List<NPath> c = this.resolveLibPaths(clazz);
        return c.isEmpty() ? NOptional.ofNamedEmpty("LibPath fo " + clazz) : NOptional.of(c.get(0));
    }

    @Override
    public NOptional<NId> resolveId(Class<?> clazz) {
        clazz = JavaClassUtils.unwrapCGLib(clazz);
        List<NId> pomIds = this.resolveIds(clazz);
        Object defaultValue = null;
        if (pomIds.isEmpty()) {
            return NOptional.ofNamedEmpty("Id fo " + clazz);
        }
        if (pomIds.size() > 1) {
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("multiple ids found : %s for class %s and id %s", Arrays.asList(pomIds), clazz, defaultValue).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
        }
        return NOptional.of(pomIds.get(0));
    }

    @Override
    public NOptional<NId> resolveId(NPath path) {
        List<NId> pomIds = this.resolveIds(path);
        Object defaultValue = null;
        if (pomIds.isEmpty()) {
            return NOptional.ofNamedEmpty("Id fo " + path);
        }
        if (pomIds.size() > 1) {
            NLog.of(NPomXmlParser.class).log(NMsg.ofC("multiple ids found : %s for path %s and id %s", Arrays.asList(pomIds), path, defaultValue).withIntent(NMsgIntent.ALERT).withLevel(Level.FINEST));
        }
        return NOptional.of(pomIds.get(0));
    }

    @Override
    public List<NId> resolveIds(NPath path) {
        LinkedHashSet<NId> all = new LinkedHashSet<NId>();
        NPomId[] u = MavenUtils.createPomIdResolver(this.workspace).resolvePomIds(path);
        all.addAll(Arrays.asList(new NMetaInfIdResolver().resolvePomIds(path)));
        for (NPomId uu : u) {
            all.add(NId.get(uu.getGroupId() + ":" + uu.getArtifactId() + "#" + uu.getVersion()).get());
        }
        return new ArrayList<NId>(all);
    }

    @Override
    public List<NId> resolveIds(Class<?> clazz) {
        clazz = JavaClassUtils.unwrapCGLib(clazz);
        LinkedHashSet<NId> all = new LinkedHashSet<NId>();
        NAppDefinition annotation = clazz.getAnnotation(NAppDefinition.class);
        if (annotation != null && !NBlankable.isBlank(annotation.id())) {
            all.add(NId.get(annotation.id()).get());
        }
        NPomId[] u = MavenUtils.createPomIdResolver(this.workspace).resolvePomIds(clazz);
        all.addAll(Arrays.asList(new NMetaInfIdResolver().resolvePomIds(clazz)));
        for (NPomId uu : u) {
            all.add(NId.get(uu.getGroupId() + ":" + uu.getArtifactId() + "#" + uu.getVersion()).get());
        }
        return new ArrayList<NId>(all);
    }
}

