/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.digest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NHex;

public class NDigestUtils {
    public static byte[] evalMD5(String input) {
        byte[] bytesOfMessage = input.getBytes(StandardCharsets.UTF_8);
        return NDigestUtils.evalMD5(bytesOfMessage);
    }

    public static String evalMD5Hex(Path path) {
        return NHex.fromBytes(NDigestUtils.evalMD5(path));
    }

    public static byte[] evalMD5(Path path) {
        byte[] byArray;
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            byArray = NDigestUtils.evalMD5(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
        ((InputStream)is).close();
        return byArray;
    }

    public static String evalMD5Hex(InputStream input) {
        return NHex.fromBytes(NDigestUtils.evalMD5(input));
    }

    public static byte[] evalHash(InputStream input, String algo) {
        try {
            MessageDigest md = MessageDigest.getInstance(algo);
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NIOException(new IOException(e));
        }
    }

    public static byte[] evalMD5(InputStream input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    md.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NIOException(e);
        }
    }

    public static byte[] evalMD5(byte[] bytesOfMessage) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(bytesOfMessage);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NIOException(e);
        }
    }

    public static String evalSHA1Hex(NPath file) {
        String string;
        block8: {
            InputStream is = file.getInputStream();
            try {
                string = NDigestUtils.evalSHA1Hex(is, true);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String evalSHA1(File file) {
        try {
            return NDigestUtils.evalSHA1Hex(new FileInputStream(file), true);
        }
        catch (FileNotFoundException e) {
            throw new NIOException(e);
        }
    }

    public static char[] evalSHA1(char[] input) {
        byte[] bytes = NIOUtils.charsToBytes(input);
        char[] r = NDigestUtils.evalSHA1HexChars(new ByteArrayInputStream(bytes), true);
        Arrays.fill(bytes, (byte)0);
        return r;
    }

    public static String evalSHA1(String input) {
        return NDigestUtils.evalSHA1Hex(new ByteArrayInputStream(input.getBytes()), true);
    }

    public static String evalSHA1Hex(InputStream input, boolean closeStream) {
        return NHex.fromBytes(NDigestUtils.evalSHA1(input, closeStream));
    }

    public static char[] evalSHA1HexChars(InputStream input, boolean closeStream) {
        return NHex.fromBytes(NDigestUtils.evalSHA1(input, closeStream)).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] evalSHA1(InputStream input, boolean closeStream) {
        try {
            MessageDigest sha1 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new NIOException(ex);
            }
            byte[] buffer = new byte[8192];
            int len = 0;
            try {
                len = input.read(buffer);
                while (len != -1) {
                    sha1.update(buffer, 0, len);
                    len = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            byte[] byArray = sha1.digest();
            return byArray;
        }
        finally {
            if (closeStream && input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
        }
    }
}

