/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.cp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NCpValidator;
import net.thevpc.nuts.io.NCpValidatorException;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NInterruptException;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.xtra.cp.MiddleTransferException;
import net.thevpc.nuts.runtime.standalone.xtra.cp.ReaderInputSource;
import net.thevpc.nuts.runtime.standalone.xtra.cp.WriterOutputTarget;
import net.thevpc.nuts.runtime.standalone.xtra.time.NProgressUtils;
import net.thevpc.nuts.runtime.standalone.xtra.time.SingletonNInputStreamProgressFactory;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.time.NProgressEvent;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.time.NProgressListener;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNCp
implements NCp {
    private final NWorkspace workspace;
    private NCpValidator checker;
    private boolean skipRoot = false;
    private int maxRepeatCount = 3;
    private NInputSource source;
    private NOutputTarget target;
    private NProgressFactory progressMonitorFactory;
    private boolean interrupted;
    private boolean recursive;
    private boolean mkdirs;
    private NInterruptible interruptibleInstance;
    private Object sourceOrigin;
    private String sourceTypeName;
    private NMsg actionMsg;
    private Set<NPathOption> options = new LinkedHashSet<NPathOption>();

    public DefaultNCp(NWorkspace workspace) {
        this.workspace = workspace;
    }

    private static Path transformPath(Path f, Path sourceBase, Path targetBase) {
        String bs;
        String fs = f.toString();
        if (fs.startsWith(bs = sourceBase.toString())) {
            String relative = fs.substring(bs.length());
            if (!relative.startsWith(File.separator)) {
                relative = File.separator + relative;
            }
            String x = targetBase + relative;
            return Paths.get(x, new String[0]);
        }
        throw new RuntimeException("Invalid path " + f);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNCp.class);
    }

    @Override
    public NInputSource getSource() {
        return this.source;
    }

    @Override
    public NCp setSource(NPath source) {
        this.source = source;
        return this;
    }

    @Override
    public NCp setSource(InputStream source) {
        this.source = source == null ? null : NInputSource.of(source);
        return this;
    }

    @Override
    public NCp setSource(File source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NCp setSource(Path source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NCp setSource(URL source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NCp setSource(String source) {
        this.source = source == null ? null : NPath.of(source);
        return this;
    }

    @Override
    public NCp setSource(byte[] source) {
        this.source = source == null ? null : NInputSource.of(source);
        return this;
    }

    @Override
    public NCp from(NInputSource source) {
        this.source = source;
        return this;
    }

    @Override
    public NCp from(NPath source) {
        this.source = source;
        return this;
    }

    @Override
    public NCp from(Reader source) {
        this.source = source == null ? null : new ReaderInputSource(this.workspace, source);
        return this;
    }

    @Override
    public NCp to(NOutputTarget target) {
        this.target = target;
        return this;
    }

    @Override
    public NCp to(Writer target) {
        this.target = target == null ? null : new WriterOutputTarget(this.workspace, target);
        return this;
    }

    @Override
    public NCp from(InputStream source) {
        return this.setSource(source);
    }

    @Override
    public NCp from(File source) {
        return this.setSource(source);
    }

    @Override
    public NCp from(Path source) {
        return this.setSource(source);
    }

    @Override
    public NCp from(URL source) {
        return this.setSource(source);
    }

    @Override
    public NCp from(byte[] source) {
        return this.setSource(source);
    }

    @Override
    public NOutputTarget getTarget() {
        return this.target;
    }

    @Override
    public NCp setTarget(OutputStream target) {
        this.target = target == null ? null : NOutputTarget.of(target);
        return this;
    }

    @Override
    public NCp setTarget(NPrintStream target) {
        this.target = target;
        return this;
    }

    @Override
    public NCp setTarget(NPath target) {
        this.target = target;
        return this;
    }

    @Override
    public NCp setTarget(Path target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NCp setTarget(File target) {
        this.target = target == null ? null : NPath.of(target);
        return this;
    }

    @Override
    public NCp setTarget(NOutputTarget target) {
        this.target = target;
        return this;
    }

    @Override
    public NCp setSource(NInputSource source) {
        this.source = source;
        return this;
    }

    @Override
    public NCp to(OutputStream target) {
        return this.setTarget(target);
    }

    @Override
    public NCp to(NPrintStream target) {
        return this.setTarget(target);
    }

    @Override
    public NCp to(Path target) {
        return this.setTarget(target);
    }

    @Override
    public NCp to(File target) {
        return this.setTarget(target);
    }

    @Override
    public NCp to(NPath target) {
        this.target = target;
        return this;
    }

    @Override
    public NCp addOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.add(o);
            }
        }
        return this;
    }

    @Override
    public NCp removeOptions(NPathOption ... pathOptions) {
        if (pathOptions != null) {
            for (NPathOption o : pathOptions) {
                if (o == null) continue;
                this.options.remove(o);
            }
        }
        return this;
    }

    @Override
    public NCp clearOptions() {
        this.options.clear();
        return this;
    }

    @Override
    public Set<NPathOption> getOptions() {
        return new LinkedHashSet<NPathOption>(this.options);
    }

    @Override
    public NCpValidator getValidator() {
        return this.checker;
    }

    @Override
    public DefaultNCp setValidator(NCpValidator checker) {
        this.checker = checker;
        return this;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public NCp setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    @Override
    public boolean isMkdirs() {
        return this.mkdirs;
    }

    @Override
    public NCp setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
        return this;
    }

    @Override
    public byte[] getByteArrayResult() {
        NMemoryPrintStream b = NPrintStream.ofMem();
        this.to(b);
        this.removeOptions(NPathOption.SAFE);
        this.run();
        return b.getBytes();
    }

    @Override
    public String getStringResult() {
        return new String(this.getByteArrayResult());
    }

    @Override
    public NCp run() {
        NAssert.requireNonBlank(this.source, "source");
        NAssert.requireNonBlank(this.target, "target");
        NInputSource _source = this.source;
        if (_source instanceof NPath && ((NPath)_source).isDirectory()) {
            if (!(this.target instanceof NPath)) {
                throw new NIllegalArgumentException(NMsg.ofC("unsupported copy of directory to %s", this.target));
            }
            Path fromPath = ((NPath)_source).toPath().get();
            Path toPath = ((NPath)this.target).toPath().get();
            CopyData cd = new CopyData();
            if (this.options.contains(NPathOption.LOG) || this.options.contains(NPathOption.TRACE) || this.getProgressFactory() != null) {
                this.prepareCopyFolder(fromPath, cd);
                this.copyFolderWithMonitor(fromPath, toPath, cd);
            } else {
                this.copyFolderNoMonitor(fromPath, toPath, cd);
            }
            return this;
        }
        this.copyStream();
        return this;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressMonitorFactory;
    }

    @Override
    public NCp setProgressFactory(NProgressFactory value) {
        this.progressMonitorFactory = value;
        return this;
    }

    @Override
    public NCp setProgressMonitor(NProgressListener value) {
        this.progressMonitorFactory = value == null ? null : new SingletonNInputStreamProgressFactory(value);
        return this;
    }

    @Override
    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    @Override
    public NCp setSkipRoot(boolean skipRoot) {
        this.skipRoot = skipRoot;
        return this;
    }

    @Override
    public NCp interrupt() {
        if (this.interruptibleInstance != null) {
            this.interruptibleInstance.interrupt();
        }
        this.interrupted = true;
        return this;
    }

    @Override
    public Object getSourceOrigin() {
        return this.sourceOrigin;
    }

    @Override
    public NCp setSourceOrigin(Object sourceOrigin) {
        this.sourceOrigin = sourceOrigin;
        return this;
    }

    @Override
    public NMsg getActionMessage() {
        return this.actionMsg;
    }

    @Override
    public DefaultNCp setActionMessage(NMsg actionMsg) {
        this.actionMsg = actionMsg;
        return this;
    }

    @Override
    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    @Override
    public NCp setSourceTypeName(String sourceTypeName) {
        this.sourceTypeName = sourceTypeName;
        return this;
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new NInterruptException();
        }
    }

    private void prepareCopyFolder(Path d, final CopyData f) {
        try {
            Files.walkFileTree(d, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    DefaultNCp.this.checkInterrupted();
                    ++f.folders;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    DefaultNCp.this.checkInterrupted();
                    ++f.files;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NIOException(exc);
        }
    }

    private void copyFolderWithMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        final long start = System.nanoTime();
        Object origin = this.getSourceOrigin();
        final NProgressListener m = NProgressUtils.createProgressMonitor(NProgressUtils.MonitorType.DEFAULT, NPath.of(srcBase), origin, this.workspace, this.options.contains(NPathOption.LOG), this.options.contains(NPathOption.TRACE), this.getProgressFactory());
        final NText srcBaseMessage = NText.of(srcBase);
        m.onProgress(NProgressEvent.ofStart(srcBase, NMsg.ofNtf(srcBaseMessage), f.files + f.folders));
        try {
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    DefaultNCp.this.checkInterrupted();
                    ++f.doneFolders;
                    NPath.of(DefaultNCp.transformPath(dir, srcBase, targetBase)).mkdirs();
                    m.onProgress(NProgressEvent.ofProgress(srcBase, NMsg.ofNtf(srcBaseMessage), f.doneFiles + f.doneFolders, System.nanoTime() - start, null, 0L, 0L, f.files + f.folders, null));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNCp.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNCp.this.copy(file, DefaultNCp.transformPath(file, srcBase, targetBase), (Set<NPathOption>)DefaultNCp.this.options);
                    m.onProgress(NProgressEvent.ofProgress(srcBase, NMsg.ofNtf(srcBaseMessage), f.doneFiles + f.doneFolders, System.nanoTime() - start, null, 0L, 0L, f.files + f.folders, null));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NIOException(exc);
        }
        finally {
            m.onProgress(NProgressEvent.ofComplete(srcBase, NMsg.ofNtf(srcBaseMessage), f.files + f.folders, System.nanoTime() - start, null, 0L, 0L, f.files + f.folders, null));
        }
    }

    public Path copy(Path source, Path target, Set<NPathOption> options) throws IOException {
        if (options.contains(NPathOption.INTERRUPTIBLE)) {
            if (Files.exists(target, new LinkOption[0]) && !options.contains(NPathOption.REPLACE_EXISTING)) {
                return null;
            }
            try (InputStream in = NInputSourceBuilder.of(Files.newInputStream(source, new OpenOption[0])).setInterruptible(true).createInputStream();){
                this.interruptibleInstance = (NInterruptible)((Object)in);
                try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                    this.transferTo(in, out);
                }
            }
            return target;
        }
        return Files.copy(source, target, CoreIOUtils.asCopyOptions(options).toArray(new CopyOption[0]));
    }

    public long copy(InputStream in, Path target, Set<NPathOption> options) throws IOException {
        if (options.contains(NPathOption.INTERRUPTIBLE)) {
            in = NInputSourceBuilder.of(in).setInterruptible(true).createInputStream();
            this.interruptibleInstance = (NInterruptible)((Object)in);
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                long l = this.transferTo(in, out);
                return l;
            }
        }
        return Files.copy(in, target, CoreIOUtils.asCopyOptions(options).toArray(new CopyOption[0]));
    }

    public long copy(InputStream in, OutputStream out, Set<NPathOption> options) throws IOException {
        if (options.contains(NPathOption.INTERRUPTIBLE)) {
            in = NInputSourceBuilder.of(in).setInterruptible(true).createInputStream();
            this.interruptibleInstance = (NInterruptible)((Object)in);
            return this.transferTo(in, out);
        }
        return NIOUtils.copy(in, out);
    }

    public long copy(Reader in, Writer out, Set<NPathOption> options) throws IOException {
        return NIOUtils.copy(in, out);
    }

    public long copy(Path source, OutputStream out) throws IOException {
        if (this.options.contains(NPathOption.INTERRUPTIBLE)) {
            try (InputStream in = NInputSourceBuilder.of(Files.newInputStream(source, new OpenOption[0])).setInterruptible(true).createInputStream();){
                this.interruptibleInstance = (NInterruptible)((Object)in);
                try {
                    long l = this.transferTo(in, out);
                    return l;
                }
                catch (IOException ex) {
                    throw new MiddleTransferException(ex);
                }
            }
        }
        return Files.copy(source, out);
    }

    private long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        int DEFAULT_BUFFER_SIZE = 8192;
        NAssert.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = in.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            this.checkInterrupted();
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    private void copyFolderNoMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        try {
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    DefaultNCp.this.checkInterrupted();
                    ++f.doneFolders;
                    NPath.of(DefaultNCp.transformPath(dir, srcBase, targetBase)).mkdirs();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNCp.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNCp.this.copy(file, DefaultNCp.transformPath(file, srcBase, targetBase), (Set<NPathOption>)DefaultNCp.this.options);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    DefaultNCp.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new NIOException(exc);
        }
    }

    private void copyStream() {
        NAssert.requireNonBlank(this.source, "source");
        NAssert.requireNonBlank(this.target, "target");
        boolean safe = this.options.contains(NPathOption.SAFE);
        if (safe) {
            this.copyStreamSafe(this.source, this.target);
        } else {
            this.copyStreamOnce(this.source, this.target);
        }
    }

    private void copyStreamSafe(NInputSource source, NOutputTarget target) {
        if (source.isMultiRead()) {
            this.copyStreamMulti(source, target);
        } else {
            this.copyStreamOnce(source, target);
        }
    }

    private void copyStreamMulti(NInputSource source, NOutputTarget target) {
        int repeatCount = 1;
        int maxRepeatCount = this.maxRepeatCount;
        if (maxRepeatCount < 1) {
            maxRepeatCount = 3;
        }
        for (int i = repeatCount; i <= maxRepeatCount; ++i) {
            try {
                if (i > 1 && this._LOG().isLoggable(Level.FINEST)) {
                    this._LOG().log(NMsg.ofC("repeat download #%s %s", i, source).asFinest().withIntent(NMsgIntent.START));
                }
                this.copyStreamOnce(source, target);
                return;
            }
            catch (NIOException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof SocketException || cause instanceof SocketTimeoutException || cause instanceof MiddleTransferException) continue;
                throw ex;
            }
        }
    }

    private NPath asValidSourcePath() {
        NPath p;
        if (this.source != null && this.source instanceof NPath && (p = (NPath)this.source).isRegularFile()) {
            return p;
        }
        return null;
    }

    private NPath asValidTargetPath() {
        if (this.target != null && this.target instanceof NPath) {
            NPath p = (NPath)this.target;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStreamOnce(NInputSource source, NOutputTarget target) {
        NSession session = this.workspace.currentSession();
        NAssert.requireNonNull(source, "source");
        NAssert.requireNonNull(target, "target");
        NOutputTarget2 _target2 = new NOutputTarget2(target);
        NInputSource2 _source2 = new NInputSource2(source);
        boolean safe = this.options.contains(NPathOption.SAFE);
        if (this.checker != null && _target2.jpath == null && !safe) {
            throw new NIllegalArgumentException(NMsg.ofNtf("unsupported validation if neither safeCopy is armed nor path is defined"));
        }
        NMsg loggedSrc = _source2.source.getMetaData().getMessage().orElse(NMsg.ofPlain("unknown-source"));
        NMsg loggedTarget = target.getMetaData().getMessage().orElse(NMsg.ofPlain("unknown-target"));
        NMsg m = this.getActionMessage();
        if (m == null) {
            m = NMsg.ofPlain("copy");
        }
        if (this.options.contains(NPathOption.LOG)) {
            session.getTerminal().printProgress(NMsg.ofC("%-14s %s to %s", m, loggedSrc, loggedTarget));
        }
        if (this.options.contains(NPathOption.LOG) || this.options.contains(NPathOption.TRACE) || this.getProgressFactory() != null) {
            NInputStreamMonitor monitor = NInputStreamMonitor.of();
            monitor.setSource(_source2.source);
            monitor.setLogProgress(this.options.contains(NPathOption.LOG));
            monitor.setTraceProgress(this.options.contains(NPathOption.TRACE));
            monitor.setOrigin(this.getSourceOrigin());
            monitor.setSourceTypeName(this.getSourceTypeName());
            _source2.source = NInputSource.of(monitor.setProgressFactory(this.getProgressFactory()).setLength(_source2.source.getMetaData().getContentLength().orElse(-1L)).setLogProgress(this.options.contains(NPathOption.LOG)).create());
        }
        NChronometer chrono = NChronometer.startNow();
        if (this._LOG().isLoggable(Level.FINEST)) {
            this._LOG().log(NMsg.ofC("%s %s to %s", m, loggedSrc, loggedTarget).asFinest().withIntent(NMsgIntent.START));
        }
        try {
            block80: {
                if (safe) {
                    Path temp = null;
                    if (_target2.jpath != null) {
                        NPath.of(_target2.jpath).mkParentDirs();
                        temp = _target2.jpath.resolveSibling(_target2.jpath.getFileName() + "~");
                    } else {
                        temp = NPath.ofTempFile("temp~").toPath().get();
                    }
                    if (_source2.jpath != null) {
                        this.copy(_source2.jpath, temp, new HashSet<NPathOption>(Collections.singletonList(NPathOption.REPLACE_EXISTING)));
                    } else {
                        try (InputStream ins = _source2.source.getInputStream();){
                            this.copy(ins, temp, new HashSet<NPathOption>(Collections.singletonList(NPathOption.REPLACE_EXISTING)));
                        }
                    }
                    this._validate(temp);
                    if (_target2.jpath != null) {
                        try {
                            Files.move(temp, _target2.jpath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (FileSystemException e) {
                            if (NIOUtils.compareContent(temp, _target2.jpath)) {
                                if (temp != null && Files.exists(temp, new LinkOption[0])) {
                                    Files.delete(temp);
                                }
                                return;
                            }
                            throw e;
                        }
                        temp = null;
                        break block80;
                    }
                    OutputStream ops = target.getOutputStream();
                    try {
                        this.copy(temp, ops);
                    }
                    finally {
                        if (temp != null && Files.exists(temp, new LinkOption[0])) {
                            Files.delete(temp);
                        }
                    }
                }
                if (_target2.jpath != null) {
                    Path to = _target2.jpath;
                    NPath.of(to).mkParentDirs();
                    if (_source2.jpath != null) {
                        this.copy(_source2.jpath, to, new HashSet<NPathOption>(Collections.singletonList(NPathOption.REPLACE_EXISTING)));
                    } else {
                        try (InputStream ins = _source2.source.getInputStream();){
                            this.copy(ins, to, new HashSet<NPathOption>(Collections.singletonList(NPathOption.REPLACE_EXISTING)));
                        }
                    }
                    this._validate(to);
                } else {
                    ByteArrayOutputStream bos = null;
                    if (this.checker != null) {
                        bos = new ByteArrayOutputStream();
                        if (_source2.jpath != null) {
                            this.copy(_source2.jpath, bos);
                        } else {
                            try (InputStream ins = _source2.source.getInputStream();){
                                this.copy(ins, bos, this.options);
                            }
                        }
                        try (OutputStream ops = target.getOutputStream();){
                            this.copy((InputStream)new ByteArrayInputStream(bos.toByteArray()), ops, this.options);
                        }
                        this._validate(bos.toByteArray());
                    } else {
                        if (_source2.jpath != null) {
                            try (OutputStream ops = target.getOutputStream();){
                                this.copy(_source2.jpath, ops);
                            }
                        }
                        try (InputStream ins = _source2.source.getInputStream();
                             OutputStream ops = target.getOutputStream();){
                            this.copy(ins, ops, this.options);
                        }
                    }
                }
            }
            this._LOG().log(NMsg.ofC(NI18n.of("%s %s to %s"), m, _source2.source, loggedTarget).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS).withDurationMillis(chrono.getDurationMs()));
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofC("error % %s to %s : %s", m, _source2.source, loggedTarget, ex).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL).withDurationMillis(chrono.getDurationMs()));
            throw new NIOException(ex);
        }
    }

    private void _validate(Path temp) {
        if (this.checker != null) {
            try (InputStream in = Files.newInputStream(temp, new OpenOption[0]);){
                this.checker.validate(in);
            }
            catch (NCpValidatorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NCpValidatorException(NMsg.ofC("validate file %s failed", temp), (Throwable)ex);
            }
        }
    }

    private void _validate(byte[] temp) {
        if (this.checker != null) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(temp);){
                this.checker.validate(in);
            }
            catch (NCpValidatorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NCpValidatorException(NMsg.ofPlain("validate file failed"), (Throwable)ex);
            }
        }
    }

    private static class CopyData {
        long files;
        long folders;
        long doneFiles;
        long doneFolders;

        private CopyData() {
        }
    }

    private static class NOutputTarget2 {
        NOutputTarget target;
        NPath path;
        Path jpath;

        public NOutputTarget2(NOutputTarget target) {
            this.target = target;
            NPath nPath = this.path = this.target instanceof NPath ? (NPath)this.target : null;
            if (this.path != null && this.path.isLocal()) {
                this.jpath = this.path.toPath().orNull();
            }
        }
    }

    private static class NInputSource2 {
        NInputSource source;
        NPath path;
        Path jpath;

        public NInputSource2(NInputSource source) {
            this.source = source;
            NPath nPath = this.path = this.source instanceof NPath ? (NPath)this.source : null;
            if (this.path != null && this.path.isLocal()) {
                this.jpath = this.path.toPath().orNull();
            }
        }
    }
}

