/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.contenttype;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NContentTypeResolver;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNContentTypeResolver
implements NContentTypeResolver {
    Map<String, String> defaultExtensionToMimeType = new HashMap<String, String>();

    @Override
    public NScoredCallable<String> probeContentType(NPath path) {
        String contentType = null;
        if (path != null) {
            Path file;
            if (path.isRegularFile() && (file = path.toPath().orNull()) != null) {
                contentType = this.probeFile(file);
            }
            if (contentType == null) {
                URL url = path.toURL().orNull();
                try {
                    if (url != null) {
                        URLConnection c = url.openConnection();
                        DefaultNWebCli.prepareGlobalConnection(c);
                        contentType = c.getContentType();
                    }
                }
                catch (IOException c) {
                    // empty catch block
                }
            }
            if (contentType == null) {
                String e;
                String name = path.getName();
                try {
                    contentType = URLConnection.guessContentTypeFromName(name);
                }
                catch (Exception c) {
                    // empty catch block
                }
                if ((contentType == null || "text/plain".equals(contentType)) && (e = NPath.of(Paths.get(name, new String[0])).nameParts(NPathExtensionType.SHORT).getExtension()) != null && e.equalsIgnoreCase("ntf")) {
                    return NScoredCallable.of(20, "text/x-nuts-text-format");
                }
                if ((contentType == null || "text/plain".equals(contentType)) && (e = NPath.of(Paths.get(name, new String[0])).nameParts(NPathExtensionType.SHORT).getExtension()) != null && e.equalsIgnoreCase("nuts")) {
                    return NScoredCallable.of(20, "application/json");
                }
            }
            if (contentType != null) {
                return NScoredCallable.of(10, contentType);
            }
        }
        return NScoredCallable.ofInvalid(() -> NMsg.ofInvalidValue("content-type"));
    }

    /*
     * WARNING - void declaration
     */
    private String probeFile(Path file) {
        String contentType = null;
        try {
            contentType = Files.probeContentType(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NPath nPath = NPath.of(file);
        Set<Object> extensions = new HashSet<String>();
        extensions.add(nPath.nameParts(NPathExtensionType.LONG).getExtension());
        extensions.add(nPath.nameParts(NPathExtensionType.SHORT).getExtension());
        extensions.add(nPath.nameParts(NPathExtensionType.SMART).getExtension());
        extensions = extensions.stream().filter(NBlankable::isNonBlank).filter(x -> !x.isEmpty()).collect(Collectors.toSet());
        if (contentType == null) {
            for (String string : extensions) {
                String s;
                if (contentType != null) break;
                Iterator<String> iterator = this.findContentTypesByExtension(string).iterator();
                if (!iterator.hasNext()) continue;
                contentType = s = iterator.next();
            }
        }
        if (contentType == null && NWorkspace.of().getOsFamily().isPosix()) {
            if (contentType == null) {
                try {
                    int n;
                    String c2 = NExecCmd.of("file", "--mime-type", file.toString()).system().failFast().getGrabbedOutString();
                    if (c2 != null && (n = c2.lastIndexOf(58)) > 0) {
                        contentType = c2.substring(n + 1).trim();
                    }
                }
                catch (Exception c2) {
                    // empty catch block
                }
            }
            if (contentType == null) {
                try {
                    int n;
                    String c = NExecCmd.of("xdg-mime", "query", "filetype", file.toString()).system().failFast().getGrabbedOutString();
                    if (c != null && (n = c.indexOf(58)) > 0) {
                        contentType = c.substring(n + 1).trim();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (contentType != null) {
            void var6_15;
            String string = contentType;
            int n = -1;
            switch (string.hashCode()) {
                case -1248325150: {
                    if (!string.equals("application/zip")) break;
                    boolean bl = false;
                    break;
                }
                case 817335912: {
                    if (!string.equals("text/plain")) break;
                    boolean bl = true;
                }
            }
            switch (var6_15) {
                case 0: {
                    NRef<Boolean> isJar = NRef.of(false);
                    NRef<Boolean> isWar = NRef.of(false);
                    ZipUtils.visitZipStream(file, (path, inputStream) -> {
                        switch (path) {
                            case "META-INF/MANIFEST.MF": {
                                isJar.set(true);
                                if (!isJar.orElse(false).booleanValue() || !isWar.orElse(false).booleanValue()) break;
                                return NVisitResult.TERMINATE;
                            }
                            case "WEB-INF/web.xml": {
                                isWar.set(true);
                                if (!isJar.orElse(false).booleanValue() || !isWar.orElse(false).booleanValue()) break;
                                return NVisitResult.TERMINATE;
                            }
                        }
                        return NVisitResult.CONTINUE;
                    });
                    if (isWar.get().booleanValue()) {
                        return "application/x-webarchive";
                    }
                    if (!isJar.get().booleanValue()) break;
                    return "application/java-archive";
                }
                case 1: {
                    if (file.getFileName().toString().endsWith(".hl")) {
                        return "text/x-hl";
                    }
                    if (!file.getFileName().toString().endsWith(".ntf")) break;
                    return "text/x-ntf";
                }
            }
        }
        return contentType;
    }

    @Override
    public NScoredCallable<String> probeContentType(byte[] bytes) {
        String contentType = null;
        if (bytes != null) {
            try {
                contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(bytes));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (contentType != null) {
            return NScoredCallable.of(10, contentType);
        }
        return NScoredCallable.ofInvalid(() -> NMsg.ofInvalidValue("content-type"));
    }

    @Override
    public List<String> findExtensionsByContentType(String contentType) {
        Set v = (Set)this.model().contentTypesToExtensions.get(contentType);
        return v == null ? Collections.emptyList() : new ArrayList(v);
    }

    @Override
    public List<String> findContentTypesByExtension(String extension) {
        Set v = (Set)this.model().extensionsToContentType.get(extension);
        return v == null ? Collections.emptyList() : new ArrayList(v);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultNContentTypeResolverModel model() {
        NWorkspace nWorkspace = NWorkspace.of();
        synchronized (nWorkspace) {
            return NApp.of().getOrComputeProperty(DefaultNContentTypeResolverModel.class.getName(), NScopeType.WORKSPACE, () -> new DefaultNContentTypeResolverModel());
        }
    }

    public static class DefaultNContentTypeResolverModel {
        private Map<String, Set<String>> contentTypesToExtensions = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> extensionsToContentType = new HashMap<String, Set<String>>();

        public DefaultNContentTypeResolverModel() {
            try (BufferedReader is = new BufferedReader(new InputStreamReader(this.getClass().getResource("/net/thevpc/nuts/runtime/default-mime.types").openStream()));){
                String line = null;
                while ((line = is.readLine()) != null) {
                    List<String> splitted;
                    if ((line = line.trim()).isEmpty() || line.startsWith("#") || (splitted = NStringUtils.split(line, " \t", true, true)).size() <= 1) continue;
                    String contentType = splitted.get(0);
                    for (int i = 1; i < splitted.size(); ++i) {
                        String ext = splitted.get(i);
                        this.contentTypesToExtensions.computeIfAbsent(contentType, x -> new LinkedHashSet()).add(ext);
                        this.extensionsToContentType.computeIfAbsent(ext, x -> new LinkedHashSet()).add(contentType);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

