/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NUncompress;
import net.thevpc.nuts.io.NUncompressVisitor;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.spi.NUncompressPackaging;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class NUncompressZip
implements NUncompressPackaging {
    private String extractRoot(String fileName) {
        int si = fileName.indexOf("/");
        if (si >= 0) {
            return fileName.substring(0, si + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncompressPackage(NUncompress uncompress, NInputSource source) {
        NOutputTarget target = uncompress.getTarget();
        try {
            NPath _target = this.asValidTargetPath(target);
            if (_target == null) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid target %s", target));
            }
            Path folder = _target.toPath().get();
            NPath.of(folder).mkdirs();
            byte[] buffer = new byte[40960];
            try (InputStream _in = source.getInputStream();
                 ZipInputStream zis = new ZipInputStream(_in);){
                ZipEntry ze = zis.getNextEntry();
                String root = null;
                while (ze != null) {
                    Path newFile;
                    String fileName = ze.getName();
                    if (uncompress.isSkipRoot()) {
                        String root2 = this.extractRoot(fileName);
                        if (root == null) {
                            root = root2;
                        } else if (!Objects.equals(root2, root)) {
                            throw new IOException("not a single root zip : '" + root2 + "' <> '" + root + "'");
                        }
                        fileName = fileName.substring(root.length());
                    }
                    if (fileName.endsWith("/")) {
                        newFile = folder.resolve(fileName);
                        NPath.of(newFile).mkdirs();
                    } else {
                        newFile = folder.resolve(fileName);
                        this._LOG().log(NMsg.ofJ("file unzip : {0}", newFile).asFinestAlert());
                        if (newFile.getParent() != null) {
                            NPath.of(newFile).mkParentDirs();
                        }
                        try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofJ("error uncompressing {0} to {1} : {2}", source, target, ex).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            throw new NIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPackage(NUncompress uncompress, NInputSource source, NUncompressVisitor visitor) {
        try (InputStream _in = source.getInputStream();
             final ZipInputStream zis = new ZipInputStream(_in);){
            ZipEntry ze = zis.getNextEntry();
            String root = null;
            while (ze != null) {
                String fileName = ze.getName();
                if (uncompress.isSkipRoot()) {
                    if (root == null) {
                        if (fileName.endsWith("/")) {
                            root = fileName;
                            ze = zis.getNextEntry();
                            continue;
                        }
                        throw new IOException("not a single root zip");
                    }
                    if (fileName.startsWith(root)) {
                        fileName = fileName.substring(root.length());
                    } else {
                        throw new IOException("not a single root zip");
                    }
                }
                if (fileName.endsWith("/") ? !visitor.visitFolder(fileName) : !visitor.visitFile(fileName, new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zis.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return zis.read(b, off, len);
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zis.read(b);
                    }
                })) break;
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofJ("error visiting {0} : {2}", source, ex).asConfig().withIntent(NMsgIntent.FAIL));
            throw new NIOException(ex);
        }
    }

    protected NLog _LOG() {
        return NLog.of(NUncompressZip.class);
    }

    private NPath asValidTargetPath(NOutputTarget target) {
        if (target != null && target instanceof NPath) {
            NPath p = (NPath)target;
            return p;
        }
        return null;
    }

    @Override
    public int getScore(NScorableContext context) {
        NUncompress c = context.getCriteria(NUncompress.class);
        String z = NStringUtils.trim(c.getPackaging()).toLowerCase();
        if (z.isEmpty() || z.equals("zip") || z.equals("jar") || z.equals("war")) {
            return 10;
        }
        return -1;
    }
}

