/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NUncompress;
import net.thevpc.nuts.io.NUncompressVisitor;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.spi.NUncompressPackaging;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class NUncompressGzip
implements NUncompressPackaging {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPackage(NUncompress uncompress, NInputSource source, NUncompressVisitor visitor) {
        try {
            String baseName = source.getMetaData().getName().orElse("no-name");
            try (InputStream _in = source.getInputStream();
                 final GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = NPath.of(baseName).getName();
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                visitor.visitFile(n, new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zis.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return zis.read(b, off, len);
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zis.read(b);
                    }
                });
            }
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofJ("error uncompressing {0} to {1} : {2}", source, uncompress.getTarget(), ex).asConfig().withIntent(NMsgIntent.FAIL));
            throw new NIOException(ex);
        }
    }

    protected NLog _LOG() {
        return NLog.of(NUncompressGzip.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncompressPackage(NUncompress uncompress, NInputSource source) {
        NOutputTarget target = uncompress.getTarget();
        try {
            NPath _target = this.asValidTargetPath(target);
            if (_target == null) {
                throw new NIllegalArgumentException(NMsg.ofC("invalid target %s", target));
            }
            Path folder = _target.toPath().get();
            NPath.of(folder).mkdirs();
            String baseName = source.getMetaData().getName().orElse("no-name");
            byte[] buffer = new byte[1024];
            try (InputStream _in = source.getInputStream();
                 GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = NPath.of(baseName).getName();
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                Path newFile = folder.resolve(n);
                this._LOG().log(NMsg.ofJ("file unzip : {0}", newFile).asFinestAlert());
                if (newFile.getParent() != null) {
                    NPath.of(newFile).mkParentDirs();
                }
                try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofJ("error uncompressing {0} to {1} : {2}", source, target, ex).asConfig().withIntent(NMsgIntent.FAIL));
            throw new NIOException(ex);
        }
    }

    private NPath asValidTargetPath(NOutputTarget target) {
        if (target != null && target instanceof NPath) {
            NPath p = (NPath)target;
            return p;
        }
        return null;
    }

    @Override
    public int getScore(NScorableContext context) {
        NUncompress c = context.getCriteria(NUncompress.class);
        String z = NStringUtils.trim(c.getPackaging()).toLowerCase();
        if (z.equals("gzip") || z.equals("gz")) {
            return 10;
        }
        return -1;
    }
}

