/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.xtra.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.thevpc.nuts.io.NCompress;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.xtra.compress.DefaultNCompress;
import net.thevpc.nuts.spi.NCompressPackaging;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class NCompressZip
implements NCompressPackaging {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compressPackage(NCompress compress) {
        List<NInputSource> sources = compress.getSources();
        NAssert.requireNonBlank(sources, "source");
        NOutputTarget target = compress.getTarget();
        NAssert.requireNonBlank(target, "target");
        NChronometer chronometer = NChronometer.startNow();
        this._LOG().log(NMsg.ofC("compress %s to %s", sources, target).asFinest().withIntent(NMsgIntent.START).withLevel(Level.FINEST).withIntent(NMsgIntent.START));
        try {
            block37: {
                OutputStream fW = null;
                ZipOutputStream zip = null;
                if (target instanceof NPath) {
                    Path tempPath;
                    block36: {
                        tempPath = null;
                        if (compress.isSafe()) {
                            tempPath = NPath.ofTempFile("zip").toPath().get();
                        }
                        if (target instanceof NPath) {
                            ((NPath)target).mkParentDirs();
                        }
                        fW = tempPath == null ? target.getOutputStream() : Files.newOutputStream(tempPath, new OpenOption[0]);
                        try {
                            try {
                                zip = new ZipOutputStream(fW);
                                if (compress.isSkipRoot()) {
                                    for (NInputSource s : sources) {
                                        DefaultNCompress.Item file1 = new DefaultNCompress.Item(s, compress);
                                        if (file1.isSourceDirectory()) {
                                            for (DefaultNCompress.Item c : file1.list()) {
                                                this.add("", c, zip);
                                            }
                                            continue;
                                        }
                                        this.add("", file1, zip);
                                    }
                                    break block36;
                                }
                                for (NInputSource s : sources) {
                                    this.add("", new DefaultNCompress.Item(s, compress), zip);
                                }
                            }
                            finally {
                                if (zip != null) {
                                    zip.close();
                                }
                            }
                        }
                        finally {
                            if (fW != null) {
                                fW.close();
                            }
                        }
                    }
                    if (tempPath != null) {
                        if (target instanceof NPath) {
                            Files.move(tempPath, ((NPath)target).toPath().get(), StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            if (target instanceof NPath) {
                                try (InputStream ii = Files.newInputStream(tempPath, new OpenOption[0]);
                                     OutputStream jj = target.getOutputStream();){
                                    NIOUtils.copy(ii, jj);
                                    break block37;
                                }
                            }
                            NIOUtils.copy(Files.newInputStream(tempPath, new OpenOption[0]), target.getOutputStream());
                        }
                    }
                } else {
                    throw new NIllegalArgumentException(NMsg.ofC("unsupported target %s", target));
                }
            }
            this._LOG().log(NMsg.ofC("compressed %s to %s", sources, target).asFinest().withIntent(NMsgIntent.SUCCESS).withDurationMillis(chronometer.getDurationMs()));
        }
        catch (IOException ex) {
            this._LOG().log(NMsg.ofC("error compressing %s to %s : %s", sources, target, ex).asConfig().withIntent(NMsgIntent.FAIL).withDurationMillis(chronometer.getDurationMs()));
            throw new NIOException(ex);
        }
        catch (RuntimeException ex) {
            this._LOG().log(NMsg.ofC("error compressing %s to %s : %s", sources, target, ex).asConfig().withIntent(NMsgIntent.FAIL).withDurationMillis(chronometer.getDurationMs()));
            throw ex;
        }
    }

    protected NLog _LOG() {
        return NLog.of(NCompressZip.class);
    }

    private void add(String path, DefaultNCompress.Item srcFolder, ZipOutputStream zip) {
        if (srcFolder.isSourceDirectory()) {
            this.addFolderToZip(path, srcFolder, zip);
        } else {
            this.addFileToZip(path, srcFolder, zip, false);
        }
    }

    private void addFolderToZip(String path, DefaultNCompress.Item srcFolder, ZipOutputStream zip) throws UncheckedIOException {
        DefaultNCompress.Item[] dirChildren = srcFolder.list();
        if (dirChildren.length == 0) {
            this.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (DefaultNCompress.Item c : dirChildren) {
                if (path.equals("")) {
                    this.addFileToZip(srcFolder.getName(), c, zip, false);
                    continue;
                }
                this.addFileToZip(NCompressZip.concatPath(path, srcFolder.getName()), c, zip, false);
            }
        }
    }

    private String stripZipPath(String path) {
        if (path.length() > 1 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    private void addFileToZip(String path, DefaultNCompress.Item srcFile, ZipOutputStream zip, boolean flag) throws UncheckedIOException {
        String pathPrefix = path;
        if (!pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        try {
            if (flag) {
                zip.putNextEntry(new ZipEntry(this.stripZipPath(pathPrefix + srcFile.getName() + "/")));
            } else if (srcFile.isSourceDirectory()) {
                this.addFolderToZip(pathPrefix, srcFile, zip);
            } else {
                int len;
                byte[] buf = new byte[1024];
                InputStream in = srcFile.open();
                zip.putNextEntry(new ZipEntry(this.stripZipPath(pathPrefix + srcFile.getName())));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private static String concatPath(String a, String b) {
        if (a.endsWith("/")) {
            if (b.startsWith("/")) {
                return a + b.substring(1);
            }
            return a + b;
        }
        if (b.startsWith("/")) {
            return a + b;
        }
        return a + "/" + b;
    }

    @Override
    public int getScore(NScorableContext context) {
        NCompress c = context.getCriteria(NCompress.class);
        String z = NStringUtils.trim(c.getPackaging()).toLowerCase();
        if (z.isEmpty() || z.equals("zip") || z.equals("gzip") || z.equals("gz")) {
            return 10;
        }
        return -1;
    }
}

