/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.workspace.factorycache;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.workspace.factorycache.AbstractCachedConstructor;
import net.thevpc.nuts.runtime.standalone.workspace.factorycache.CachedConstructor;
import net.thevpc.nuts.runtime.standalone.workspace.factorycache.TypeAndArgTypes;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NArrays;

public class NBeanCache {
    private final Map<TypeAndArgTypes, CachedConstructor> cachedConstructors = new HashMap<TypeAndArgTypes, CachedConstructor>();
    private final NLog LOG;
    private final PrintStream log;

    public NBeanCache(NLog LOG, PrintStream log) {
        this.LOG = LOG;
        this.log = log;
    }

    private <T> Constructor<T> resolveExactConstructor(Class<T> t, Class[] argTypes) {
        Constructor<T> ctrl = null;
        try {
            ctrl = t.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            if (this.log != null) {
                this.log.println(NMsg.ofC("constructor not found %s(%s)", t.getName(), Arrays.stream(argTypes).map(x -> x.getName()).collect(Collectors.toList())));
            }
            return null;
        }
        ctrl.setAccessible(true);
        if (this.log != null) {
            this.log.println(NMsg.ofC("constructor found %s(%s)", t.getName(), Arrays.stream(argTypes).map(x -> x.getName()).collect(Collectors.toList())));
        }
        return ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CachedConstructor<T> findConstructor(Class<T> t, Class[] argTypes) {
        TypeAndArgTypes tt = new TypeAndArgTypes(t, argTypes);
        Map<TypeAndArgTypes, CachedConstructor> map = this.cachedConstructors;
        synchronized (map) {
            CachedConstructor o = this.cachedConstructors.get(tt);
            if (o != null) {
                return o;
            }
            if (this.cachedConstructors.containsKey(tt)) {
                return null;
            }
            CachedConstructor<T> c = this.createConstructor(tt);
            this.cachedConstructors.put(tt, c);
            return c;
        }
    }

    public <T> CachedConstructor<T> createConstructor(TypeAndArgTypes tt) {
        Class[] baseArgTypes = tt.getArgTypes();
        Class typeToInstantiate = tt.getType();
        if (baseArgTypes.length > 0) {
            Constructor<T> c = this.resolveExactConstructor(typeToInstantiate, NArrays.append(baseArgTypes, NSession.class));
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(NArrays.append(args, session));
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, NArrays.prepend(NSession.class, baseArgTypes));
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(NArrays.prepend(session, args));
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, NArrays.append(baseArgTypes, NWorkspace.class));
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(NArrays.append(args, session.getWorkspace()));
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, NArrays.prepend(NWorkspace.class, baseArgTypes));
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(NArrays.prepend(session.getWorkspace(), args));
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, baseArgTypes);
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(args);
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, new Class[]{NSession.class});
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(session);
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, new Class[]{NWorkspace.class});
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(session.getWorkspace());
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, new Class[0]);
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(new Object[0]);
                    }
                };
            }
        } else {
            Constructor<T> c = this.resolveExactConstructor(typeToInstantiate, new Class[]{NSession.class});
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(session);
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, new Class[]{NWorkspace.class});
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(NArrays.append(args, session.getWorkspace()));
                    }
                };
            }
            c = this.resolveExactConstructor(typeToInstantiate, new Class[0]);
            if (c != null) {
                return new AbstractCachedConstructor<T>(c){

                    @Override
                    public T newInstanceUnsafe(Object[] args, NSession session) throws InvocationTargetException, InstantiationException, IllegalAccessException {
                        return this.c.newInstance(new Object[0]);
                    }
                };
            }
        }
        return null;
    }
}

